/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Collection;
import javafx.beans.property.Property;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.scene.control.LocalDateTimePicker;

public class LocalDateTimePickerSkin
extends SkinBase<LocalDateTimePicker> {
    private CalendarPicker calendarPicker = null;

    public LocalDateTimePickerSkin(LocalDateTimePicker control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        this.calendarPicker.getStyleClass().addAll((Object[])new String[]{((Object)((Object)((LocalDateTimePicker)this.getSkinnable()))).getClass().getSimpleName()});
        this.calendarPicker.getStyleClass().addAll((Collection)((LocalDateTimePicker)this.getSkinnable()).getStyleClass());
        this.calendarPicker.styleProperty().bindBidirectional((Property)((LocalDateTimePicker)this.getSkinnable()).styleProperty());
        this.calendarPicker.localeProperty().bindBidirectional(((LocalDateTimePicker)this.getSkinnable()).localeProperty());
        DateTimeToCalendarHelper.syncLocalDateTime(this.calendarPicker.calendarProperty(), ((LocalDateTimePicker)this.getSkinnable()).localDateTimeProperty(), this.calendarPicker.localeProperty());
        DateTimeToCalendarHelper.syncLocalDateTime(this.calendarPicker.displayedCalendar(), ((LocalDateTimePicker)this.getSkinnable()).displayedLocalDateTimeProperty(), this.calendarPicker.localeProperty());
        DateTimeToCalendarHelper.syncLocalDateTimes(this.calendarPicker.highlightedCalendars(), ((LocalDateTimePicker)this.getSkinnable()).highlightedLocalDateTimes(), this.calendarPicker.localeProperty());
        DateTimeToCalendarHelper.syncLocalDateTimes(this.calendarPicker.disabledCalendars(), ((LocalDateTimePicker)this.getSkinnable()).disabledLocalDateTimes(), this.calendarPicker.localeProperty());
        this.calendarPicker.allowNullProperty().bindBidirectional((Property)((LocalDateTimePicker)this.getSkinnable()).allowNullProperty());
        this.calendarPicker.setCalendarRangeCallback(new Callback<CalendarPicker.CalendarRange, Void>(){

            public Void call(CalendarPicker.CalendarRange calendarRange) {
                Callback<LocalDateTimePicker.LocalDateTimeRange, Void> lCallback = ((LocalDateTimePicker)LocalDateTimePickerSkin.this.getSkinnable()).getLocalDateTimeRangeCallback();
                if (lCallback == null) {
                    return null;
                }
                return (Void)lCallback.call((Object)new LocalDateTimePicker.LocalDateTimeRange(DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(calendarRange.getStartCalendar()), DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(calendarRange.getEndCalendar())));
            }
        });
        this.calendarPicker.setValueValidationCallback(new Callback<Calendar, Boolean>(){

            public Boolean call(Calendar calendar) {
                Callback<LocalDateTime, Boolean> lCallback = ((LocalDateTimePicker)LocalDateTimePickerSkin.this.getSkinnable()).getValueValidationCallback();
                if (lCallback == null) {
                    return true;
                }
                return (Boolean)lCallback.call((Object)DateTimeToCalendarHelper.createLocalDateTimeFromCalendar(calendar));
            }
        });
    }

    private void createNodes() {
        this.calendarPicker = new CalendarPicker().withShowTime(true);
        this.getChildren().add((Object)this.calendarPicker);
        ((LocalDateTimePicker)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }
}

