/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import com.sun.javafx.css.converters.EnumConverter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.css.converters.SimpleDateFormatConverter;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$1;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$10;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$2;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$3;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$4;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$5;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$6;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$7;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$8;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$$Lambda$9;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$1$$Lambda$1;
import jfxtras.internal.scene.control.skin.CalendarTimePickerSkin$2$$Lambda$1;
import jfxtras.scene.control.CalendarTimePicker;

public class CalendarTimePickerSkin
extends SkinBase<CalendarTimePicker> {
    private final ObjectProperty<ShowTickLabels> showTickLabels = new SimpleStyleableObjectProperty<ShowTickLabels>(StyleableProperties.access$000(), (Object)this, "showTickLabels", (ShowTickLabels)((Object)StyleableProperties.access$000().getInitialValue(null))){
        {
            this.addListener(CalendarTimePickerSkin$1$$Lambda$1.lambdaFactory$(this));
        }

        private /* synthetic */ void lambda$new$31(Observable invalidationEvent) {
            CalendarTimePickerSkin.this.refreshLayout();
        }

        static /* synthetic */ void access$lambda$0(1 var0, Observable observable) {
            var0.lambda$new$31(observable);
        }
    };
    private final ObjectProperty<DateFormat> labelDateFormat = new SimpleStyleableObjectProperty<DateFormat>(StyleableProperties.access$200(), (Object)this, "labelDateFormat", (DateFormat)StyleableProperties.access$200().getInitialValue(null)){
        {
            this.addListener(CalendarTimePickerSkin$2$$Lambda$1.lambdaFactory$(this));
        }

        private /* synthetic */ void lambda$new$32(Observable invalidationEvent) {
            CalendarTimePickerSkin.this.refreshLayout();
            CalendarTimePickerSkin.this.refresh();
        }

        static /* synthetic */ void access$lambda$0(2 var0, Observable observable) {
            var0.lambda$new$32(observable);
        }
    };
    private final Slider hourScrollSlider = new Slider();
    private final Slider minuteScrollSlider = new Slider();
    private final Slider secondScrollSlider = new Slider();
    private final Text timeText = new Text("XX:XX:XX");
    final Pane hourLabelsPane = new Pane(){
        {
            this.prefWidthProperty().bind((ObservableValue)CalendarTimePickerSkin.this.hourScrollSlider.prefWidthProperty());
            this.layoutChildren();
        }

        protected void layoutChildren() {
            double lX;
            Text lText;
            int i;
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            Text lText2 = new Text("0");
            Rectangle lRectangle = new Rectangle(0.0, 0.0, CalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText2.prefHeight(0.0));
            lRectangle.setFill((Paint)Color.TRANSPARENT);
            this.getChildren().add((Object)lRectangle);
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 24;
            if (lNumberOfLabels >= 24) {
                lStep = 1;
            } else if (lNumberOfLabels >= 12) {
                lStep = 2;
            } else if (lNumberOfLabels >= 8) {
                lStep = 3;
            } else if (lNumberOfLabels >= 6) {
                lStep = 4;
            } else if (lNumberOfLabels > 4) {
                lStep = 6;
            } else if (lNumberOfLabels > 2) {
                lStep = 12;
            }
            for (i = 0; i < 24; i += lStep) {
                lText = new Text("" + i);
                lText.setY(lText.prefHeight(0.0));
                lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i - lText.prefWidth(0.0) / (double)(i == 23 ? 1 : 2) * (double)(i != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
            }
            for (i = 0; i < 24; ++i) {
                lText = new Text("0");
                lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i;
                this.getChildren().add((Object)new Line(lX, lText.prefHeight(0.0) + 3.0, lX, lText.prefHeight(0.0) + 3.0 + 3.0));
            }
        }
    };
    final Pane minuteLabelsPane = new Pane(){
        {
            this.layoutChildren();
        }

        protected void layoutChildren() {
            int i;
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            if (CalendarTimePickerSkin.this.getShowTickLabels() == ShowTickLabels.YES) {
                Text lText = new Text("0");
                Rectangle lRectangle = new Rectangle(0.0, 0.0, CalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText.prefHeight(0.0));
                lRectangle.setFill((Paint)Color.TRANSPARENT);
                this.getChildren().add((Object)lRectangle);
            }
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 60;
            if (lNumberOfLabels >= 60) {
                lStep = 1;
            } else if (lNumberOfLabels >= 30) {
                lStep = 2;
            } else if (lNumberOfLabels >= 20) {
                lStep = 3;
            } else if (lNumberOfLabels >= 15) {
                lStep = 4;
            } else if (lNumberOfLabels >= 12) {
                lStep = 5;
            } else if (lNumberOfLabels >= 6) {
                lStep = 10;
            } else if (lNumberOfLabels >= 4) {
                lStep = 15;
            } else if (lNumberOfLabels >= 2) {
                lStep = 30;
            }
            if (lStep < ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep()) {
                lStep = ((CalendarTimePicker)CalendarTimePickerSkin.this.getSkinnable()).getMinuteStep();
            }
            for (i = 0; i <= 59; i += lStep) {
                Text lText = new Text("" + i);
                lText.setY(lText.prefHeight(0.0));
                double lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i - lText.prefWidth(0.0) / (double)(i == 59 ? 1 : 2) * (double)(i != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
            }
            for (i = 0; i <= 59; ++i) {
                double lX = lScrollSliderOuterPadding + (CalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i;
                this.getChildren().add((Object)new Line(lX, 0.0, lX, 3.0));
            }
        }
    };
    static final Date DATE = new Date(8099, 0, 1, 2, 3, 4);
    private final AtomicInteger refreshingAtomicInteger = new AtomicInteger(0);
    private Calendar changingCalendar = null;

    public CalendarTimePickerSkin(CalendarTimePicker control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTimePicker)this.getSkinnable()).calendarProperty().addListener(CalendarTimePickerSkin$$Lambda$1.lambdaFactory$(this));
        ((CalendarTimePicker)this.getSkinnable()).minuteStepProperty().addListener(CalendarTimePickerSkin$$Lambda$2.lambdaFactory$(this));
        this.minuteScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getMinuteStep().doubleValue());
        ((CalendarTimePicker)this.getSkinnable()).secondStepProperty().addListener(CalendarTimePickerSkin$$Lambda$3.lambdaFactory$(this));
        this.secondScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getSecondStep().doubleValue());
        ((CalendarTimePicker)this.getSkinnable()).localeProperty().addListener(CalendarTimePickerSkin$$Lambda$4.lambdaFactory$(this));
        this.refresh();
    }

    public final ObjectProperty<ShowTickLabels> showTickLabelsProperty() {
        return this.showTickLabels;
    }

    public final void setShowTickLabels(ShowTickLabels value) {
        this.showTickLabelsProperty().set((Object)value);
    }

    public final ShowTickLabels getShowTickLabels() {
        return (ShowTickLabels)((Object)this.showTickLabels.get());
    }

    public final CalendarTimePickerSkin withShowTickLabels(ShowTickLabels value) {
        this.setShowTickLabels(value);
        return this;
    }

    public final ObjectProperty<DateFormat> labelDateFormatProperty() {
        return this.labelDateFormat;
    }

    public final void setLabelDateFormat(DateFormat value) {
        this.labelDateFormatProperty().set((Object)value);
    }

    public final DateFormat getLabelDateFormat() {
        if (this.labelDateFormat.get() == null) {
            return this.getLABEL_DATEFORMAT_DEFAULT();
        }
        DateFormat labelDateFormat = (DateFormat)this.labelDateFormat.get();
        if (labelDateFormat.getCalendar() == null) {
            labelDateFormat.setCalendar(Calendar.getInstance(((CalendarTimePicker)this.getSkinnable()).getLocale()));
        }
        if (labelDateFormat.getNumberFormat() == null) {
            labelDateFormat.setNumberFormat(NumberFormat.getInstance(((CalendarTimePicker)this.getSkinnable()).getLocale()));
        }
        labelDateFormat = (DateFormat)labelDateFormat.clone();
        labelDateFormat.setTimeZone(TimeZone.getDefault());
        return labelDateFormat;
    }

    public final CalendarTimePickerSkin withLabelDateFormat(DateFormat value) {
        this.setLabelDateFormat(value);
        return this;
    }

    private DateFormat getLABEL_DATEFORMAT_DEFAULT() {
        return DateFormat.getTimeInstance(3, ((CalendarTimePicker)this.getSkinnable()).getLocale());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CalendarTimePickerSkin.getClassCssMetaData();
    }

    private void createNodes() {
        this.hourScrollSlider.setId("hourSlider");
        this.hourScrollSlider.minProperty().set(0.0);
        this.hourScrollSlider.maxProperty().set(23.0);
        this.hourScrollSlider.setMajorTickUnit(12.0);
        this.hourScrollSlider.setMinorTickCount(3);
        this.hourScrollSlider.valueProperty().addListener(CalendarTimePickerSkin$$Lambda$5.lambdaFactory$(this));
        this.hourScrollSlider.valueChangingProperty().addListener(CalendarTimePickerSkin$$Lambda$6.lambdaFactory$(this));
        this.minuteScrollSlider.setId("minuteSlider");
        this.minuteScrollSlider.minProperty().set(0.0);
        this.minuteScrollSlider.maxProperty().set(59.0);
        this.minuteScrollSlider.setMajorTickUnit(10.0);
        this.minuteScrollSlider.valueProperty().addListener(CalendarTimePickerSkin$$Lambda$7.lambdaFactory$(this));
        this.minuteScrollSlider.valueChangingProperty().addListener(CalendarTimePickerSkin$$Lambda$8.lambdaFactory$(this));
        this.secondScrollSlider.setId("secondSlider");
        this.secondScrollSlider.minProperty().set(0.0);
        this.secondScrollSlider.maxProperty().set(59.0);
        this.secondScrollSlider.setMajorTickUnit(10.0);
        this.secondScrollSlider.valueProperty().addListener(CalendarTimePickerSkin$$Lambda$9.lambdaFactory$(this));
        this.secondScrollSlider.valueChangingProperty().addListener(CalendarTimePickerSkin$$Lambda$10.lambdaFactory$(this));
        this.timeText.setDisable(true);
        this.timeText.getStyleClass().add((Object)"timeLabel");
        this.refreshLayout();
        ((CalendarTimePicker)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    public void modifyChangingCalendarSecond(int seconds) {
        Calendar lCalendar = this.getChangingCalendar();
        lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
        int lSecondStep = ((CalendarTimePicker)this.getSkinnable()).getSecondStep();
        if (lSecondStep > 1 && (seconds += ((CalendarTimePicker)this.getSkinnable()).getSecondStep() / 2) > 59) {
            seconds -= lSecondStep;
        }
        lCalendar.set(13, seconds);
        lCalendar = CalendarTimePickerSkin.blockSecondsToStep(lCalendar, ((CalendarTimePicker)this.getSkinnable()).getMinuteStep());
        this.setChangingCalendar(lCalendar);
    }

    public void modifyChangingCalendarMinute(int minutes) {
        Calendar lCalendar = this.getChangingCalendar();
        lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
        int lMinuteStep = ((CalendarTimePicker)this.getSkinnable()).getMinuteStep();
        if (lMinuteStep > 1 && (minutes += ((CalendarTimePicker)this.getSkinnable()).getMinuteStep() / 2) > 59) {
            minutes -= lMinuteStep;
        }
        lCalendar.set(12, minutes);
        lCalendar = CalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((CalendarTimePicker)this.getSkinnable()).getMinuteStep());
        this.setChangingCalendar(lCalendar);
    }

    public void modifyChangingCalendarHour(int hour) {
        Calendar lCalendar = this.getChangingCalendar();
        lCalendar = lCalendar == null ? Calendar.getInstance() : (Calendar)lCalendar.clone();
        lCalendar.set(11, hour);
        this.setChangingCalendar(lCalendar);
    }

    private void refreshLayout() {
        DateFormat labelDateFormat = this.getLabelDateFormat();
        String formattedDate = labelDateFormat.format(DATE);
        this.getChildren().clear();
        StackPane lStackPane = new StackPane();
        VBox lVBox = new VBox(0.0);
        lVBox.alignmentProperty().set((Object)Pos.CENTER);
        if (formattedDate.contains("2")) {
            if (this.getShowTickLabels() == ShowTickLabels.YES) {
                lVBox.getChildren().add((Object)this.hourLabelsPane);
            }
            lVBox.getChildren().add((Object)this.hourScrollSlider);
        }
        if (formattedDate.contains("3")) {
            lVBox.getChildren().add((Object)this.minuteScrollSlider);
            if (this.getShowTickLabels() == ShowTickLabels.YES) {
                lVBox.getChildren().add((Object)this.minuteLabelsPane);
            }
        }
        if (formattedDate.contains("4")) {
            lVBox.getChildren().add((Object)this.secondScrollSlider);
        }
        lStackPane.getChildren().add((Object)lVBox);
        lStackPane.getChildren().add((Object)this.timeText);
        StackPane.setAlignment((Node)this.timeText, (Pos)(this.getShowTickLabels() == ShowTickLabels.YES ? Pos.CENTER : Pos.TOP_CENTER));
        this.getChildren().add((Object)lStackPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        try {
            this.refreshingAtomicInteger.addAndGet(1);
            Calendar lCalendar = this.getChangingCalendar();
            int lHour = lCalendar == null ? 0 : lCalendar.get(11);
            int lMinute = lCalendar == null ? 0 : lCalendar.get(12);
            int lSecond = lCalendar == null ? 0 : lCalendar.get(13);
            this.hourScrollSlider.valueProperty().set((double)lHour);
            this.minuteScrollSlider.valueProperty().set((double)lMinute);
            this.secondScrollSlider.valueProperty().set((double)lSecond);
            this.timeText.setText(lCalendar == null ? "" : this.getLabelDateFormat().format(lCalendar.getTime()));
        }
        finally {
            this.refreshingAtomicInteger.addAndGet(-1);
        }
    }

    public static Calendar blockMinutesToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null) {
            return calendar;
        }
        int lValue = calendar.get(12);
        if (stepSize == 1) {
            return calendar;
        }
        lValue /= stepSize.intValue();
        if (calendar.get(12) != (lValue *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            lCalendar.set(12, lValue);
            calendar = lCalendar;
        }
        return calendar;
    }

    public static Calendar blockSecondsToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null) {
            return calendar;
        }
        int lValue = calendar.get(13);
        if (stepSize == 1) {
            return calendar;
        }
        lValue /= stepSize.intValue();
        if (calendar.get(13) != (lValue *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            lCalendar.set(13, lValue);
            calendar = lCalendar;
        }
        return calendar;
    }

    private Calendar getChangingCalendar() {
        if (this.changingCalendar != null) {
            return this.changingCalendar;
        }
        return ((CalendarTimePicker)this.getSkinnable()).getCalendar();
    }

    public void setChangingCalendar(Calendar lCalendar) {
        if (!lCalendar.equals(this.getChangingCalendar())) {
            this.changingCalendar = lCalendar;
            this.refresh();
        }
    }

    public void acceptChangingCalendar() {
        if (this.changingCalendar != null) {
            if (this.callValueValidationCallback((Calendar)this.changingCalendar.clone())) {
                ((CalendarTimePicker)this.getSkinnable()).setCalendar(this.changingCalendar);
            }
            this.changingCalendar = null;
            this.refresh();
        }
    }

    private boolean callValueValidationCallback(Calendar value) {
        Callback<Calendar, Boolean> lCallback = ((CalendarTimePicker)this.getSkinnable()).getValueValidationCallback();
        if (lCallback == null) {
            return true;
        }
        return (Boolean)lCallback.call((Object)value);
    }

    private /* synthetic */ void lambda$createNodes$38(ObservableValue observable, Boolean oldValue, Boolean newValue) {
        if (this.refreshingAtomicInteger.get() > 0) {
            return;
        }
        this.acceptChangingCalendar();
    }

    private /* synthetic */ void lambda$createNodes$37(ObservableValue observable, Number oldValue, Number newValue) {
        if (this.refreshingAtomicInteger.get() > 0) {
            return;
        }
        this.modifyChangingCalendarSecond(newValue.intValue());
        if (!this.secondScrollSlider.valueChangingProperty().get()) {
            this.acceptChangingCalendar();
        }
    }

    private /* synthetic */ void lambda$createNodes$36(ObservableValue observable, Boolean oldValue, Boolean newValue) {
        if (this.refreshingAtomicInteger.get() > 0) {
            return;
        }
        this.acceptChangingCalendar();
    }

    private /* synthetic */ void lambda$createNodes$35(ObservableValue observable, Number oldValue, Number newValue) {
        if (this.refreshingAtomicInteger.get() > 0) {
            return;
        }
        this.modifyChangingCalendarMinute(newValue.intValue());
        if (!this.minuteScrollSlider.valueChangingProperty().get()) {
            this.acceptChangingCalendar();
        }
    }

    private /* synthetic */ void lambda$createNodes$34(ObservableValue observable, Boolean oldValue, Boolean newValue) {
        if (this.refreshingAtomicInteger.get() > 0) {
            return;
        }
        this.acceptChangingCalendar();
    }

    private /* synthetic */ void lambda$createNodes$33(ObservableValue observable, Number oldValue, Number newValue) {
        if (this.refreshingAtomicInteger.get() > 0) {
            return;
        }
        this.modifyChangingCalendarHour(newValue.intValue());
        if (!this.hourScrollSlider.valueChangingProperty().get()) {
            this.acceptChangingCalendar();
        }
    }

    private /* synthetic */ void lambda$construct$30(Observable observable) {
        this.refresh();
    }

    private /* synthetic */ void lambda$construct$29(Observable observable) {
        this.secondScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getSecondStep().doubleValue());
    }

    private /* synthetic */ void lambda$construct$28(Observable observable) {
        this.minuteScrollSlider.setBlockIncrement(((CalendarTimePicker)this.getSkinnable()).getMinuteStep().doubleValue());
    }

    private /* synthetic */ void lambda$construct$27(Observable observable) {
        this.refresh();
    }

    static /* synthetic */ void access$lambda$0(CalendarTimePickerSkin calendarTimePickerSkin, Observable observable) {
        calendarTimePickerSkin.lambda$construct$27(observable);
    }

    static /* synthetic */ void access$lambda$1(CalendarTimePickerSkin calendarTimePickerSkin, Observable observable) {
        calendarTimePickerSkin.lambda$construct$28(observable);
    }

    static /* synthetic */ void access$lambda$2(CalendarTimePickerSkin calendarTimePickerSkin, Observable observable) {
        calendarTimePickerSkin.lambda$construct$29(observable);
    }

    static /* synthetic */ void access$lambda$3(CalendarTimePickerSkin calendarTimePickerSkin, Observable observable) {
        calendarTimePickerSkin.lambda$construct$30(observable);
    }

    static /* synthetic */ void access$lambda$4(CalendarTimePickerSkin calendarTimePickerSkin, ObservableValue observableValue, Number number, Number number2) {
        calendarTimePickerSkin.lambda$createNodes$33(observableValue, number, number2);
    }

    static /* synthetic */ void access$lambda$5(CalendarTimePickerSkin calendarTimePickerSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        calendarTimePickerSkin.lambda$createNodes$34(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$6(CalendarTimePickerSkin calendarTimePickerSkin, ObservableValue observableValue, Number number, Number number2) {
        calendarTimePickerSkin.lambda$createNodes$35(observableValue, number, number2);
    }

    static /* synthetic */ void access$lambda$7(CalendarTimePickerSkin calendarTimePickerSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        calendarTimePickerSkin.lambda$createNodes$36(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$8(CalendarTimePickerSkin calendarTimePickerSkin, ObservableValue observableValue, Number number, Number number2) {
        calendarTimePickerSkin.lambda$createNodes$37(observableValue, number, number2);
    }

    static /* synthetic */ void access$lambda$9(CalendarTimePickerSkin calendarTimePickerSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        calendarTimePickerSkin.lambda$createNodes$38(observableValue, bl, bl2);
    }

    private static class StyleableProperties {
        private static final CssMetaData<CalendarTimePicker, ShowTickLabels> SHOW_TICKLABELS = new CssMetaDataForSkinProperty<CalendarTimePicker, CalendarTimePickerSkin, ShowTickLabels>("-fxx-show-ticklabels", (StyleConverter)new EnumConverter(ShowTickLabels.class), ShowTickLabels.NO){

            protected ObjectProperty<ShowTickLabels> getProperty(CalendarTimePickerSkin s) {
                return s.showTickLabelsProperty();
            }
        };
        private static final CssMetaData<CalendarTimePicker, DateFormat> LABEL_DATEFORMAT = new CssMetaDataForSkinProperty<CalendarTimePicker, CalendarTimePickerSkin, DateFormat>("-fxx-label-dateformat", (StyleConverter)new SimpleDateFormatConverter(), null){

            protected ObjectProperty<DateFormat> getProperty(CalendarTimePickerSkin s) {
                return s.labelDateFormatProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return SHOW_TICKLABELS;
        }

        static /* synthetic */ CssMetaData access$200() {
            return LABEL_DATEFORMAT;
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
            styleables.add(SHOW_TICKLABELS);
            styleables.add(LABEL_DATEFORMAT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum ShowTickLabels {
        YES,
        NO;

    }
}

