/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.skin;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$1;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$10;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$11;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$12;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$13;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$14;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$2;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$3;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$4;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$5;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$6;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$7;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$8;
import jfxtras.internal.scene.control.skin.CalendarTextFieldSkin$$Lambda$9;
import jfxtras.internal.scene.control.skin.DateTimeToCalendarHelper;
import jfxtras.scene.control.CalendarPicker;
import jfxtras.scene.control.CalendarTextField;
import jfxtras.scene.control.ImageViewButton;
import jfxtras.scene.control.LocalDatePicker;
import jfxtras.scene.control.LocalDateTextField;
import jfxtras.scene.control.LocalDateTimePicker;
import jfxtras.scene.control.LocalDateTimeTextField;
import jfxtras.scene.layout.VBox;
import jfxtras.util.NodeUtil;

public class CalendarTextFieldSkin
extends SkinBase<CalendarTextField> {
    private TextField textField = null;
    private ImageView imageView = null;
    private GridPane gridPane = null;
    public final BooleanProperty focusForwardingProperty = new SimpleBooleanProperty();
    private Popup popup = null;
    private CalendarPicker calendarPicker = null;

    public CalendarTextFieldSkin(CalendarTextField control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((CalendarTextField)this.getSkinnable()).calendarProperty().addListener(CalendarTextFieldSkin$$Lambda$1.lambdaFactory$(this));
        ((CalendarTextField)this.getSkinnable()).dateFormatProperty().addListener(CalendarTextFieldSkin$$Lambda$2.lambdaFactory$(this));
        ((CalendarTextField)this.getSkinnable()).textProperty().addListener(CalendarTextFieldSkin$$Lambda$3.lambdaFactory$(this));
        this.refreshValue();
        this.initFocusSimulation();
        ((CalendarTextField)this.getSkinnable()).pickerShowingProperty().addListener(CalendarTextFieldSkin$$Lambda$4.lambdaFactory$(this));
    }

    private void refreshValue() {
        Calendar c = ((CalendarTextField)this.getSkinnable()).getCalendar();
        String s = c == null ? "" : ((CalendarTextField)this.getSkinnable()).getDateFormat().format(c.getTime());
        this.textField.setText(s);
        if (!s.equals(((CalendarTextField)this.getSkinnable()).getText())) {
            ((CalendarTextField)this.getSkinnable()).setText(s);
        }
    }

    private void initFocusSimulation() {
        ((CalendarTextField)this.getSkinnable()).focusedProperty().addListener(CalendarTextFieldSkin$$Lambda$5.lambdaFactory$(this));
    }

    private void createNodes() {
        this.textField = new TextField();
        this.textField.setPrefColumnCount(20);
        this.textField.focusedProperty().addListener(CalendarTextFieldSkin$$Lambda$6.lambdaFactory$(this));
        this.textField.setOnAction(CalendarTextFieldSkin$$Lambda$7.lambdaFactory$(this));
        this.textField.setOnKeyPressed(CalendarTextFieldSkin$$Lambda$8.lambdaFactory$(this));
        this.textField.tooltipProperty().bindBidirectional((Property)((CalendarTextField)this.getSkinnable()).tooltipProperty());
        if (((CalendarTextField)this.getSkinnable()).getTooltip() == null) {
            ((CalendarTextField)this.getSkinnable()).setTooltip(new Tooltip("Type a date or use # for today, or +/-<number>[d|w|m|y] for delta's (for example: -3m for minus 3 months)\nUse cursor up and down plus optional shift (week), ctrl (month) or alt (year) for quick keyboard changes."));
        }
        this.textField.promptTextProperty().bind(((CalendarTextField)this.getSkinnable()).promptTextProperty());
        this.imageView = new ImageViewButton();
        this.imageView.getStyleClass().add((Object)"icon");
        this.imageView.setPickOnBounds(true);
        this.imageView.setOnMouseClicked(CalendarTextFieldSkin$$Lambda$9.lambdaFactory$(this));
        this.gridPane = new GridPane();
        this.gridPane.setHgap(3.0);
        this.gridPane.add((Node)this.textField, 0, 0);
        this.gridPane.add((Node)this.imageView, 1, 0);
        ColumnConstraints column0 = new ColumnConstraints(100.0, 10.0, Double.MAX_VALUE);
        column0.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column0});
        ((CalendarTextField)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
    }

    private void parse() {
        this.parse(this.textField.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String lText) {
        block19: {
            try {
                lText = lText.trim();
                if (lText.length() == 0) {
                    if (!((CalendarTextField)this.getSkinnable()).getAllowNull()) {
                        throw new IllegalArgumentException("Empty string would result in null and that is not allowed");
                    }
                    ((CalendarTextField)this.getSkinnable()).setCalendar(null);
                    return;
                }
                if (lText.startsWith("-") || lText.startsWith("+")) {
                    if (lText.startsWith("+")) {
                        lText = lText.substring(1);
                    }
                    int lUnit = 5;
                    if (lText.toLowerCase().endsWith("d")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 5;
                    }
                    if (lText.toLowerCase().endsWith("w")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 3;
                    }
                    if (lText.toLowerCase().endsWith("m")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 2;
                    }
                    if (lText.toLowerCase().endsWith("y")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 1;
                    }
                    int lDelta = Integer.parseInt(lText);
                    Calendar lCalendar = (Calendar)((CalendarTextField)this.getSkinnable()).getCalendar().clone();
                    lCalendar.add(lUnit, lDelta);
                    ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
                    break block19;
                }
                if (lText.equals("#")) {
                    ((CalendarTextField)this.getSkinnable()).setCalendar(Calendar.getInstance(((CalendarTextField)this.getSkinnable()).getLocale()));
                    break block19;
                }
                try {
                    Calendar lCalendar = ((CalendarTextField)this.getSkinnable()).getCalendar();
                    Date lDate = null;
                    for (DateFormat lDateFormat : ((CalendarTextField)this.getSkinnable()).getDateFormats()) {
                        try {
                            lDate = lDateFormat.parse(lText);
                            break;
                        }
                        catch (ParseException | DateTimeParseException e2) {
                        }
                    }
                    if (lDate == null) {
                        lDate = ((CalendarTextField)this.getSkinnable()).getDateFormat().parse(lText);
                    }
                    lCalendar = Calendar.getInstance(((CalendarTextField)this.getSkinnable()).getLocale());
                    lCalendar.setTime(lDate);
                    ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
                }
                finally {
                    this.refreshValue();
                }
            }
            catch (Throwable t) {
                if (((CalendarTextField)this.getSkinnable()).getParseErrorCallback() != null) {
                    ((CalendarTextField)this.getSkinnable()).getParseErrorCallback().call((Object)t);
                }
                t.printStackTrace();
            }
        }
    }

    private void setupPopup() {
        this.calendarPicker = new CalendarPicker();
        this.calendarPicker.setMode(CalendarPicker.Mode.SINGLE);
        this.calendarPicker.localeProperty().set(((CalendarTextField)this.getSkinnable()).localeProperty().get());
        this.calendarPicker.allowNullProperty().set(((CalendarTextField)this.getSkinnable()).allowNullProperty().get());
        this.calendarPicker.calendarProperty().set(((CalendarTextField)this.getSkinnable()).calendarProperty().get());
        DateTimeToCalendarHelper.sync(this.calendarPicker.disabledCalendars(), ((CalendarTextField)this.getSkinnable()).disabledCalendars());
        DateTimeToCalendarHelper.sync(this.calendarPicker.highlightedCalendars(), ((CalendarTextField)this.getSkinnable()).highlightedCalendars());
        this.calendarPicker.displayedCalendar().set((Object)((CalendarTextField)this.getSkinnable()).getDisplayedCalendar());
        this.calendarPicker.setCalendarRangeCallback(new Callback<CalendarPicker.CalendarRange, Void>(){

            public Void call(CalendarPicker.CalendarRange calendarRange) {
                Callback<CalendarPicker.CalendarRange, Void> lCallback = ((CalendarTextField)CalendarTextFieldSkin.this.getSkinnable()).getCalendarRangeCallback();
                if (lCallback == null) {
                    return null;
                }
                return (Void)lCallback.call((Object)calendarRange);
            }
        });
        this.calendarPicker.setValueValidationCallback(new Callback<Calendar, Boolean>(){

            public Boolean call(Calendar calendar) {
                Callback<Calendar, Boolean> lCallback = ((CalendarTextField)CalendarTextFieldSkin.this.getSkinnable()).getValueValidationCallback();
                if (lCallback == null) {
                    return true;
                }
                return (Boolean)lCallback.call((Object)calendar);
            }
        });
        this.popup = new Popup();
        this.popup.setAutoFix(true);
        this.popup.setAutoHide(true);
        this.popup.setHideOnEscape(true);
        BorderPane lBorderPane = new BorderPane(){

            public String getUserAgentStylesheet() {
                return ((CalendarTextField)CalendarTextFieldSkin.this.getSkinnable()).getUserAgentStylesheet();
            }
        };
        lBorderPane.getStyleClass().add((Object)(((Object)((Object)this)).getClass().getSimpleName() + "_popup"));
        lBorderPane.setCenter((Node)this.calendarPicker);
        this.calendarPicker.showTimeProperty().set((Object)((CalendarTextField)this.getSkinnable()).getShowTime());
        if (((CalendarTextField)this.getSkinnable()).getStyleClass().contains((Object)LocalDateTextField.class.getSimpleName())) {
            this.calendarPicker.getStyleClass().addAll((Object[])new String[]{LocalDatePicker.class.getSimpleName()});
        }
        if (((CalendarTextField)this.getSkinnable()).getStyleClass().contains((Object)LocalDateTimeTextField.class.getSimpleName())) {
            this.calendarPicker.getStyleClass().addAll((Object[])new String[]{LocalDateTimePicker.class.getSimpleName()});
        }
        if (((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
            VBox lVBox = new VBox();
            lBorderPane.rightProperty().set((Object)lVBox);
            ImageViewButton lAcceptIconImageView = new ImageViewButton();
            lAcceptIconImageView.getStyleClass().addAll((Object[])new String[]{"accept-icon"});
            lAcceptIconImageView.setPickOnBounds(true);
            lAcceptIconImageView.setOnMouseClicked(CalendarTextFieldSkin$$Lambda$10.lambdaFactory$(this));
            lVBox.add((Node)lAcceptIconImageView);
            ImageViewButton lCloseIconImageView = new ImageViewButton();
            lCloseIconImageView.getStyleClass().addAll((Object[])new String[]{"close-icon"});
            lCloseIconImageView.setPickOnBounds(true);
            lCloseIconImageView.setOnMouseClicked(CalendarTextFieldSkin$$Lambda$11.lambdaFactory$(this));
            lVBox.add((Node)lCloseIconImageView);
        }
        this.calendarPicker.calendarProperty().addListener(CalendarTextFieldSkin$$Lambda$12.lambdaFactory$(this));
        this.popup.setOnHiding(CalendarTextFieldSkin$$Lambda$13.lambdaFactory$(this));
        this.popup.getContent().setAll((Object[])new Node[]{lBorderPane});
        this.textField.setDisable(true);
        this.popup.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean showing) {
                ((CalendarTextField)CalendarTextFieldSkin.this.getSkinnable()).setPickerShowing(showing);
                if (!showing.booleanValue()) {
                    CalendarTextFieldSkin.this.popup.showingProperty().removeListener((ChangeListener)this);
                    CalendarTextFieldSkin.this.popup = null;
                }
            }
        });
    }

    private void showPopup() {
        if (this.popup == null) {
            this.setupPopup();
        }
        this.popup.show((Node)this.textField, NodeUtil.screenX((Node)this.getSkinnable()), NodeUtil.screenY((Node)this.getSkinnable()) + this.textField.getHeight());
        this.calendarPicker.requestFocus();
    }

    private /* synthetic */ void lambda$setupPopup$26(WindowEvent windowEvent) {
        if (!((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
            ((CalendarTextField)this.getSkinnable()).calendarProperty().set(this.calendarPicker.calendarProperty().get());
        }
        this.textField.setDisable(false);
    }

    private /* synthetic */ void lambda$setupPopup$25(Observable observable) {
        if (!((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue() && this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    private /* synthetic */ void lambda$setupPopup$24(MouseEvent mouseEvent) {
        this.popup.hide();
    }

    private /* synthetic */ void lambda$setupPopup$23(MouseEvent mouseEvent) {
        ((CalendarTextField)this.getSkinnable()).calendarProperty().set(this.calendarPicker.calendarProperty().get());
        this.popup.hide();
    }

    private /* synthetic */ void lambda$createNodes$22(MouseEvent evt) {
        if (this.textField.focusedProperty().get()) {
            this.parse();
        }
        ((CalendarTextField)this.getSkinnable()).setPickerShowing(true);
    }

    private /* synthetic */ void lambda$createNodes$21(KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
            this.parse();
            Calendar lCalendar = ((CalendarTextField)this.getSkinnable()).getCalendar();
            if (lCalendar == null) {
                return;
            }
            lCalendar = (Calendar)lCalendar.clone();
            int lField = 5;
            if (!keyEvent.isShiftDown() && keyEvent.isControlDown()) {
                lField = 2;
            }
            if (!keyEvent.isShiftDown() && keyEvent.isAltDown()) {
                lField = 1;
            }
            if (keyEvent.isShiftDown() && keyEvent.isControlDown() && ((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
                lField = 11;
            }
            if (keyEvent.isShiftDown() && keyEvent.isAltDown() && ((CalendarTextField)this.getSkinnable()).getShowTime().booleanValue()) {
                lField = 12;
            }
            lCalendar.add(lField, keyEvent.getCode() == KeyCode.UP ? 1 : -1);
            ((CalendarTextField)this.getSkinnable()).setCalendar(lCalendar);
        }
    }

    private /* synthetic */ void lambda$createNodes$20(ActionEvent actionEvent) {
        this.parse();
    }

    private /* synthetic */ void lambda$createNodes$19(Observable observable) {
        if (!this.textField.isFocused()) {
            this.parse();
        }
        this.focusForwardingProperty.set(this.textField.focusedProperty().get());
    }

    private /* synthetic */ void lambda$initFocusSimulation$18(ObservableValue observableValue, Boolean wasFocused, Boolean isFocused) {
        if (isFocused.booleanValue()) {
            Platform.runLater((Runnable)CalendarTextFieldSkin$$Lambda$14.lambdaFactory$(this));
        }
    }

    private /* synthetic */ void lambda$null$17() {
        this.textField.requestFocus();
    }

    private /* synthetic */ void lambda$construct$16(ObservableValue observable, Boolean oldValue, Boolean showing) {
        if (showing.booleanValue()) {
            this.showPopup();
        } else if (this.popup != null) {
            this.popup.hide();
        }
    }

    private /* synthetic */ void lambda$construct$15(Observable observable) {
        this.parse(((CalendarTextField)this.getSkinnable()).getText());
    }

    private /* synthetic */ void lambda$construct$14(ObservableValue observableValue, DateFormat oldValue, DateFormat newValue) {
        this.refreshValue();
    }

    private /* synthetic */ void lambda$construct$13(ObservableValue observableValue, Calendar oldValue, Calendar newValue) {
        this.refreshValue();
    }

    static /* synthetic */ void access$lambda$0(CalendarTextFieldSkin calendarTextFieldSkin, ObservableValue observableValue, Calendar calendar, Calendar calendar2) {
        calendarTextFieldSkin.lambda$construct$13(observableValue, calendar, calendar2);
    }

    static /* synthetic */ void access$lambda$1(CalendarTextFieldSkin calendarTextFieldSkin, ObservableValue observableValue, DateFormat dateFormat, DateFormat dateFormat2) {
        calendarTextFieldSkin.lambda$construct$14(observableValue, dateFormat, dateFormat2);
    }

    static /* synthetic */ void access$lambda$2(CalendarTextFieldSkin calendarTextFieldSkin, Observable observable) {
        calendarTextFieldSkin.lambda$construct$15(observable);
    }

    static /* synthetic */ void access$lambda$3(CalendarTextFieldSkin calendarTextFieldSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        calendarTextFieldSkin.lambda$construct$16(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$4(CalendarTextFieldSkin calendarTextFieldSkin, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        calendarTextFieldSkin.lambda$initFocusSimulation$18(observableValue, bl, bl2);
    }

    static /* synthetic */ void access$lambda$5(CalendarTextFieldSkin calendarTextFieldSkin, Observable observable) {
        calendarTextFieldSkin.lambda$createNodes$19(observable);
    }

    static /* synthetic */ void access$lambda$6(CalendarTextFieldSkin calendarTextFieldSkin, ActionEvent actionEvent) {
        calendarTextFieldSkin.lambda$createNodes$20(actionEvent);
    }

    static /* synthetic */ void access$lambda$7(CalendarTextFieldSkin calendarTextFieldSkin, KeyEvent keyEvent) {
        calendarTextFieldSkin.lambda$createNodes$21(keyEvent);
    }

    static /* synthetic */ void access$lambda$8(CalendarTextFieldSkin calendarTextFieldSkin, MouseEvent mouseEvent) {
        calendarTextFieldSkin.lambda$createNodes$22(mouseEvent);
    }

    static /* synthetic */ void access$lambda$9(CalendarTextFieldSkin calendarTextFieldSkin, MouseEvent mouseEvent) {
        calendarTextFieldSkin.lambda$setupPopup$23(mouseEvent);
    }

    static /* synthetic */ void access$lambda$10(CalendarTextFieldSkin calendarTextFieldSkin, MouseEvent mouseEvent) {
        calendarTextFieldSkin.lambda$setupPopup$24(mouseEvent);
    }

    static /* synthetic */ void access$lambda$11(CalendarTextFieldSkin calendarTextFieldSkin, Observable observable) {
        calendarTextFieldSkin.lambda$setupPopup$25(observable);
    }

    static /* synthetic */ void access$lambda$12(CalendarTextFieldSkin calendarTextFieldSkin, WindowEvent windowEvent) {
        calendarTextFieldSkin.lambda$setupPopup$26(windowEvent);
    }

    static /* synthetic */ void access$lambda$13(CalendarTextFieldSkin calendarTextFieldSkin) {
        calendarTextFieldSkin.lambda$null$17();
    }
}

