/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.internal.scene.control.fxml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javafx.scene.Node;
import jfxtras.fxml.BuilderService;
import jfxtras.internal.scene.control.fxml.AbstractBuilder;
import jfxtras.scene.control.CalendarPicker;

public class CalendarPickerBuilder
extends AbstractBuilder
implements BuilderService<CalendarPicker> {
    private static final SimpleDateFormat YMDSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat YMDHMSSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private Locale locale = null;
    private Calendar displayedCalendar = null;
    private String calendarText = null;
    private CalendarPicker.Mode mode = null;
    private Boolean showTime = null;
    private Boolean allowNull = null;

    public String getLocale() {
        return null;
    }

    public void setLocale(String value) {
        this.locale = Locale.forLanguageTag(value);
    }

    public String getDisplayedCalendar() {
        return null;
    }

    public void setDisplayedCalendar(String value) {
        try {
            this.displayedCalendar = Calendar.getInstance();
            this.displayedCalendar.setTime(YMDSimpleDateFormat.parse(value));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCalendar() {
        return null;
    }

    public void setCalendar(String value) {
        this.calendarText = value;
    }

    public String getMode() {
        return null;
    }

    public void setMode(String value) {
        this.mode = CalendarPicker.Mode.valueOf(value);
    }

    public String getShowTime() {
        return null;
    }

    public void setShowTime(String value) {
        this.showTime = Boolean.valueOf(value);
    }

    public String getAllowNull() {
        return null;
    }

    public void setAllowNull(String value) {
        this.allowNull = Boolean.valueOf(value);
    }

    public CalendarPicker build() {
        CalendarPicker lCalendarPicker = new CalendarPicker();
        if (this.showTime != null) {
            lCalendarPicker.setShowTime(this.showTime);
        }
        if (this.locale != null) {
            lCalendarPicker.setLocale(this.locale);
        }
        if (this.calendarText != null) {
            try {
                Calendar lCalendar = Calendar.getInstance();
                if (((Boolean)lCalendarPicker.showTimeProperty().get()).booleanValue()) {
                    lCalendar.setTime(YMDHMSSimpleDateFormat.parse(this.calendarText));
                } else {
                    lCalendar.setTime(YMDSimpleDateFormat.parse(this.calendarText));
                }
                lCalendarPicker.setCalendar(lCalendar);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.displayedCalendar != null) {
            lCalendarPicker.setDisplayedCalendar(this.displayedCalendar);
        }
        if (this.mode != null) {
            lCalendarPicker.setMode(this.mode);
        }
        if (this.allowNull != null) {
            lCalendarPicker.setAllowNull(this.allowNull);
        }
        this.applyCommonProperties((Node)lCalendarPicker);
        return lCalendarPicker;
    }

    public boolean isBuilderFor(Class<?> clazz) {
        return CalendarPicker.class.isAssignableFrom(clazz);
    }
}

