/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.rs422;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import org.mbari.awt.event.NonDigitConsumingKeyListener;
import org.mbari.util.Tuple2;
import org.mbari.vcr4j.udp.UDPError;
import org.mbari.vcr4j.udp.UDPState;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.avplayer.OpenVideoArchiveDialog;
import vars.avplayer.OpenVideoArchivePanel;
import vars.avplayer.rs422.RS422VideoParams;

public class UDPVideoPlayerDialogUI
extends OpenVideoArchiveDialog<UDPState, UDPError> {
    private JPanel topPanel;
    private JTextField hostTextField;
    private JTextField portTextField;

    public UDPVideoPlayerDialogUI(Window parent, ToolBelt toolBelt) {
        super(parent, toolBelt);
        this.initialize();
        this.pack();
    }

    private void initialize() {
        this.setPreferredSize(new Dimension(475, 550));
        this.getContentPane().add((Component)this.getTopPanel(), "North");
    }

    public JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setBorder(new TitledBorder(null, "Remote Timecode Server", 4, 2, null, null));
            JLabel lblHost = new JLabel("Host:");
            JLabel lblPort = new JLabel("Port:");
            GroupLayout gl_topPanel = new GroupLayout(this.topPanel);
            gl_topPanel.setHorizontalGroup(gl_topPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_topPanel.createSequentialGroup().addContainerGap().addGroup(gl_topPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lblHost).addComponent(lblPort)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_topPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getPortTextField(), -1, 417, Short.MAX_VALUE).addComponent(this.getHostTextField(), -1, 417, Short.MAX_VALUE)).addContainerGap()));
            gl_topPanel.setVerticalGroup(gl_topPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gl_topPanel.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(gl_topPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblHost).addComponent(this.getHostTextField(), -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_topPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getPortTextField(), -2, -1, -2).addComponent(lblPort)).addGap(6)));
            this.topPanel.setLayout(gl_topPanel);
        }
        return this.topPanel;
    }

    public JTextField getHostTextField() {
        if (this.hostTextField == null) {
            this.hostTextField = new JTextField();
            this.hostTextField.setColumns(10);
        }
        return this.hostTextField;
    }

    public JTextField getPortTextField() {
        if (this.portTextField == null) {
            this.portTextField = new JTextField();
            this.portTextField.addKeyListener((KeyListener)new NonDigitConsumingKeyListener());
            this.portTextField.setColumns(10);
        }
        return this.portTextField;
    }

    protected VideoArchive openVideoArchiveByParams() {
        VideoArchiveDAO dao = this.getToolBelt().getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        OpenVideoArchivePanel p = this.getCenterPanel();
        int sequenceNumber = Integer.parseInt(p.getSequenceNumberTextField().getText());
        String platform = (String)p.getCameraPlatformComboBox().getSelectedItem();
        int tapeNumber = Integer.parseInt(p.getTapeNumberTextField().getText());
        RS422VideoParams videoParams = new RS422VideoParams(platform, sequenceNumber, tapeNumber, p.getHdCheckBox().isSelected());
        String videoArchiveName = videoParams.getVideoArchiveName();
        VideoArchive videoArchive = dao.findOrCreateByParameters(platform, sequenceNumber, videoArchiveName);
        dao.endTransaction();
        return videoArchive;
    }

    public Tuple2<String, Integer> getRemoteConnectionParams() {
        return new Tuple2((Object)this.getHostTextField().getText(), (Object)Integer.parseInt(this.getPortTextField().getText()));
    }
}

