/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.rs422;

import java.awt.Frame;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.bushe.swing.event.EventBus;
import org.mbari.util.Tuple2;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.decorators.SchedulerVideoIO;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.udp.UDPError;
import org.mbari.vcr4j.udp.UDPState;
import org.mbari.vcr4j.udp.UDPVideoIO;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.VideoController;
import vars.avplayer.VideoPlayer;
import vars.avplayer.VideoPlayerDialogUI;
import vars.avplayer.rs422.ImageCaptureServiceRef;
import vars.avplayer.rs422.UDPVideoParams;
import vars.avplayer.rs422.UDPVideoPlayerDialogUI;
import vars.avplayer.rx.SetVideoArchiveMsg;
import vars.avplayer.rx.SetVideoControllerMsg;
import vars.shared.rx.RXEventBus;
import vars.shared.ui.GlobalStateLookup;

public class UDPVideoPlayer
implements VideoPlayer<UDPState, UDPError> {
    private final AtomicReference<VideoIO<UDPState, UDPError>> videoIORef = new AtomicReference();
    private ImageCaptureService imageCaptureService = ImageCaptureServiceRef.getImageCaptureService();
    private UDPVideoPlayerDialogUI dialogUI;

    public boolean canPlay(String mimeType) {
        return false;
    }

    public CompletableFuture<Tuple2<VideoArchive, VideoController<UDPState, UDPError>>> openVideoArchive(ToolBelt toolBelt, Object ... args) {
        String hostName = (String)args[0];
        Integer port = (Integer)args[1];
        String platformName = (String)args[2];
        Integer sequenceNumber = (Integer)args[3];
        Integer tapeNumber = (Integer)args[4];
        Boolean isHD = (Boolean)args[5];
        UDPVideoParams videoParams = new UDPVideoParams(hostName, port, platformName, sequenceNumber, tapeNumber, isHD);
        return CompletableFuture.supplyAsync(() -> this.openVideoArchive(toolBelt, videoParams));
    }

    public Tuple2<VideoArchive, VideoController<UDPState, UDPError>> openVideoArchive(ToolBelt toolBelt, UDPVideoParams videoParams) {
        VideoArchiveDAO dao = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        VideoArchive videoArchive = dao.findOrCreateByParameters(videoParams.getPlatformName(), videoParams.getSequenceNumber().intValue(), videoParams.getVideoArchiveName());
        dao.close();
        this.setUDPConnection(videoParams.getHostName(), videoParams.getPort());
        return new Tuple2((Object)videoArchive, this.getVideoController());
    }

    private void setUDPConnection(String hostname, Integer port) {
        if (this.videoIORef.get() != null) {
            VideoIO<UDPState, UDPError> io = this.videoIORef.get();
            io.close();
            this.videoIORef.set(null);
        }
        try {
            this.videoIORef.set(this.newVideoIO(hostname, port));
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
    }

    private VideoIO<UDPState, UDPError> newVideoIO(String hostname, Integer port) {
        SchedulerVideoIO io = null;
        try {
            UDPVideoIO rawIO = new UDPVideoIO(hostname, port.intValue());
            new VCRSyncDecorator((VideoIO)rawIO);
            io = new SchedulerVideoIO((VideoIO)rawIO, (Executor)Executors.newCachedThreadPool());
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
        return io;
    }

    private VideoController<UDPState, UDPError> getVideoController() {
        return new VideoController(this.imageCaptureService, this.videoIORef.get());
    }

    public VideoPlayerDialogUI<UDPState, UDPError> getConnectionDialog(ToolBelt toolBelt, RXEventBus eventBus) {
        if (this.dialogUI == null) {
            Frame window = GlobalStateLookup.getSelectedFrame();
            this.dialogUI = new UDPVideoPlayerDialogUI(window, toolBelt);
            this.dialogUI.onOkay(() -> {
                this.dialogUI.setVisible(false);
                VideoArchive videoArchive = this.dialogUI.openVideoArchive();
                Tuple2<String, Integer> params = this.dialogUI.getRemoteConnectionParams();
                this.setUDPConnection((String)params.getA(), (Integer)params.getB());
                eventBus.send((Object)new SetVideoArchiveMsg(videoArchive));
                eventBus.send((Object)new SetVideoControllerMsg(this.getVideoController()));
            });
        }
        return this.dialogUI;
    }

    public String getName() {
        return "Ship Network";
    }
}

