/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.rs422;

import gnu.io.CommPortIdentifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rxtx.RXTXUtilities;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.avplayer.OpenVideoArchiveDialog;
import vars.avplayer.OpenVideoArchivePanel;
import vars.avplayer.rs422.RS422VideoParams;

public class RS422VideoPlayerDialogUI
extends OpenVideoArchiveDialog<RS422State, RS422Error> {
    private JPanel topPanel;
    private JComboBox<String> serialPortComboBox;

    public RS422VideoPlayerDialogUI(Window parent, ToolBelt toolBelt) {
        super(parent, toolBelt);
        this.initialize();
        this.pack();
    }

    private void initialize() {
        this.getContentPane().add((Component)this.getTopPanel(), "North");
    }

    private JComboBox<String> getSerialPortComboBox() {
        if (this.serialPortComboBox == null) {
            String[] ports = (String[])RXTXUtilities.getAvailableSerialPorts().stream().map(CommPortIdentifier::getName).sorted().toArray(String[]::new);
            this.serialPortComboBox = new JComboBox<String>(ports);
        }
        return this.serialPortComboBox;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BorderLayout(0, 0));
            this.topPanel.setBorder(new TitledBorder(null, "Serial Port", 4, 2, null, null));
            this.topPanel.add(this.getSerialPortComboBox(), "Center");
        }
        return this.topPanel;
    }

    protected VideoArchive openVideoArchiveByParams() {
        VideoArchiveDAO dao = this.getToolBelt().getAnnotationDAOFactory().newVideoArchiveDAO();
        dao.startTransaction();
        OpenVideoArchivePanel p = this.getCenterPanel();
        int sequenceNumber = Integer.parseInt(p.getSequenceNumberTextField().getText());
        String platform = (String)p.getCameraPlatformComboBox().getSelectedItem();
        int tapeNumber = Integer.parseInt(p.getTapeNumberTextField().getText());
        RS422VideoParams videoParams = new RS422VideoParams(platform, sequenceNumber, tapeNumber, p.getHdCheckBox().isSelected());
        String videoArchiveName = videoParams.getVideoArchiveName();
        VideoArchive videoArchive = dao.findOrCreateByParameters(platform, sequenceNumber, videoArchiveName);
        dao.endTransaction();
        return videoArchive;
    }

    public String getSerialPortName() {
        return (String)this.getSerialPortComboBox().getSelectedItem();
    }
}

