/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.rs422;

import java.awt.Frame;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.bushe.swing.event.EventBus;
import org.mbari.util.Tuple2;
import org.mbari.vcr4j.SimpleVideoIO;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.decorators.SchedulerVideoIO;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.rs422.RS422Error;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.VCRVideoIO;
import org.mbari.vcr4j.rs422.decorators.RS422StatusDecorator;
import org.mbari.vcr4j.rs422.decorators.UserbitsAsTimeDecorator;
import org.mbari.vcr4j.rxtx.RXTX;
import org.mbari.vcr4j.rxtx.RXTXVideoIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ToolBelt;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.VideoController;
import vars.avplayer.VideoPlayer;
import vars.avplayer.VideoPlayerDialogUI;
import vars.avplayer.rs422.ImageCaptureServiceRef;
import vars.avplayer.rs422.RS422VideoParams;
import vars.avplayer.rs422.RS422VideoPlayerDialogUI;
import vars.avplayer.rx.SetVideoArchiveMsg;
import vars.avplayer.rx.SetVideoControllerMsg;
import vars.shared.rx.RXEventBus;
import vars.shared.ui.GlobalStateLookup;

public class RS422VideoPlayer
implements VideoPlayer<RS422State, RS422Error> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<VideoIO<RS422State, RS422Error>> videoIORef = new AtomicReference();
    private ImageCaptureService imageCaptureService = ImageCaptureServiceRef.getImageCaptureService();
    private RS422VideoPlayerDialogUI dialogUI;

    public RS422VideoPlayer() {
        try {
            RXTX.setup();
        }
        catch (UnsatisfiedLinkError e) {
            this.log.warn("Failed to setup RXTX native libraries", (Throwable)e);
        }
    }

    public boolean canPlay(String mimeType) {
        return false;
    }

    public CompletableFuture<Tuple2<VideoArchive, VideoController<RS422State, RS422Error>>> openVideoArchive(ToolBelt toolBelt, Object ... args) {
        String serialPort = (String)args[0];
        String platformName = (String)args[1];
        Integer sequenceNumber = (Integer)args[2];
        Integer tapeNumber = (Integer)args[3];
        Boolean isHD = (Boolean)args[4];
        RS422VideoParams videoParams = new RS422VideoParams(serialPort, platformName, sequenceNumber, tapeNumber, isHD);
        return CompletableFuture.supplyAsync(() -> this.openVideoArchive(toolBelt, videoParams));
    }

    public Tuple2<VideoArchive, VideoController<RS422State, RS422Error>> openVideoArchive(ToolBelt toolBelt, RS422VideoParams videoParams) {
        VideoArchiveDAO dao = toolBelt.getAnnotationDAOFactory().newVideoArchiveDAO();
        VideoArchive videoArchive = dao.findOrCreateByParameters(videoParams.getPlatformName(), videoParams.getSequenceNumber().intValue(), videoParams.getVideoArchiveName());
        dao.close();
        this.setSerialPort(videoParams.getSerialPortName());
        return new Tuple2((Object)videoArchive, this.getVideoController());
    }

    private void setSerialPort(String serialPortName) {
        VideoIO<RS422State, RS422Error> videoIO;
        String connectionID;
        if (this.videoIORef.get() != null && !(connectionID = (videoIO = this.videoIORef.get()).getConnectionID()).equalsIgnoreCase(serialPortName)) {
            videoIO.close();
            this.videoIORef.set(null);
        }
        if (this.videoIORef.get() == null) {
            this.videoIORef.set(this.newVideoIO(serialPortName));
        }
    }

    private VideoIO<RS422State, RS422Error> newVideoIO(String serialPortName) {
        SchedulerVideoIO io = null;
        try {
            RXTXVideoIO rawIO = RXTXVideoIO.open((String)serialPortName);
            new VCRSyncDecorator((VideoIO)rawIO);
            new RS422StatusDecorator((VCRVideoIO)rawIO);
            UserbitsAsTimeDecorator timeDecorator = new UserbitsAsTimeDecorator((VCRVideoIO)rawIO);
            SimpleVideoIO simpleIO = new SimpleVideoIO(rawIO.getConnectionID(), rawIO.getCommandSubject(), rawIO.getStateObservable(), rawIO.getErrorObservable(), timeDecorator.getIndexObservable());
            io = new SchedulerVideoIO((VideoIO)simpleIO, (Executor)Executors.newCachedThreadPool());
            io.send((VideoCommand)VideoCommands.REQUEST_INDEX);
            io.send((VideoCommand)VideoCommands.REQUEST_STATUS);
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
        return io;
    }

    private VideoController<RS422State, RS422Error> getVideoController() {
        return new VideoController(this.imageCaptureService, this.videoIORef.get());
    }

    public VideoPlayerDialogUI<RS422State, RS422Error> getConnectionDialog(ToolBelt toolBelt, RXEventBus eventBus) {
        if (this.dialogUI == null) {
            Frame window = GlobalStateLookup.getSelectedFrame();
            this.dialogUI = new RS422VideoPlayerDialogUI(window, toolBelt);
            this.dialogUI.onOkay(() -> {
                this.dialogUI.setVisible(false);
                VideoArchive videoArchive = this.dialogUI.openVideoArchive();
                this.setSerialPort(this.dialogUI.getSerialPortName());
                eventBus.send((Object)new SetVideoArchiveMsg(videoArchive));
                eventBus.send((Object)new SetVideoControllerMsg(this.getVideoController()));
            });
        }
        return this.dialogUI;
    }

    public String getName() {
        return "VCR via RS422";
    }
}

