/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.LPRPort;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.RXTXVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class RXTXCommDriver
implements CommDriver {
    private static final boolean DEBUG = false;
    private static final boolean DEVEL = false;
    private static final boolean NO_VERSION_OUTPUT;
    private String deviceDirectory;
    private String osName;

    private native boolean registerKnownPorts(int var1);

    private native boolean isPortPrefixValid(String var1);

    private native boolean testRead(String var1, int var2);

    private native String getDeviceDirectory();

    public static native String nativeGetVersion();

    private final String[] getValidPortPrefixes(String[] candidatePortPrefixes) {
        String[] validPortPrefixes = new String[256];
        if (candidatePortPrefixes == null) {
            // empty if block
        }
        int i = 0;
        for (int j = 0; j < candidatePortPrefixes.length; ++j) {
            if (!this.isPortPrefixValid(candidatePortPrefixes[j])) continue;
            validPortPrefixes[i++] = candidatePortPrefixes[j];
        }
        String[] returnArray = new String[i];
        System.arraycopy(validPortPrefixes, 0, returnArray, 0, i);
        if (validPortPrefixes[0] == null) {
            // empty if block
        }
        return returnArray;
    }

    private void checkSolaris(String PortName, int PortType) {
        String suffix;
        char p;
        for (p = 'a'; p <= 'z'; p = (char)(p + '\u0001')) {
            suffix = String.valueOf(p);
            if (!this.testRead(PortName.concat(suffix), PortType)) continue;
            CommPortIdentifier.addPortName(PortName.concat(suffix), PortType, this);
        }
        for (p = '0'; p <= '9'; p = (char)(p + '\u0001')) {
            suffix = String.valueOf(p);
            if (!this.testRead(PortName.concat(suffix), PortType)) continue;
            CommPortIdentifier.addPortName(PortName.concat(suffix), PortType, this);
        }
    }

    private void registerValidPorts(String[] candidateDeviceNames, String[] validPortPrefixes, int portType) {
        int i = 0;
        int p = 0;
        if (candidateDeviceNames != null && validPortPrefixes != null) {
            for (i = 0; i < candidateDeviceNames.length; ++i) {
                for (p = 0; p < validPortPrefixes.length; ++p) {
                    String v = validPortPrefixes[p];
                    int vl = v.length();
                    String c = candidateDeviceNames[i];
                    if (c.length() < vl) continue;
                    String cu = c.substring(vl).toUpperCase();
                    String cl = c.substring(vl).toLowerCase();
                    if (!c.regionMatches(0, v, 0, vl) || !cu.equals(cl)) continue;
                    String portName = this.osName.toLowerCase().indexOf("windows") == -1 ? this.deviceDirectory + c : c;
                    if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                        this.checkSolaris(portName, portType);
                        continue;
                    }
                    if (!this.testRead(portName, portType)) continue;
                    CommPortIdentifier.addPortName(portName, portType, this);
                }
            }
        }
    }

    public void initialize() {
        this.osName = System.getProperty("os.name");
        this.deviceDirectory = this.getDeviceDirectory();
        for (int portType = 1; portType <= 2; ++portType) {
            if (this.registerSpecifiedPorts(portType) || this.registerKnownPorts(portType)) continue;
            this.registerScannedPorts(portType);
        }
    }

    private void addSpecifiedPorts(String names, int portType) {
        String pathSep = System.getProperty("path.separator", ":");
        StringTokenizer tok = new StringTokenizer(names, pathSep);
        while (tok.hasMoreElements()) {
            String portName = tok.nextToken();
            if (!this.testRead(portName, portType)) continue;
            CommPortIdentifier.addPortName(portName, portType, this);
        }
    }

    private boolean registerSpecifiedPorts(int portType) {
        String val = null;
        switch (portType) {
            case 1: {
                val = this.getSpecifiedPorts("gnu.io.rxtx.SerialPorts", "gnu.io.SerialPorts");
                break;
            }
            case 2: {
                val = this.getSpecifiedPorts("gnu.io.rxtx.ParallelPorts", "gnu.io.ParallelPorts");
                break;
            }
        }
        if (val != null) {
            this.addSpecifiedPorts(val, portType);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadRxtxProperties() {
        Properties props = null;
        String fileLoc = null;
        String[] extDirs = System.getProperty("java.ext.dirs").split(":");
        String fs = System.getProperty("file.separator");
        for (int i = 0; i < extDirs.length; ++i) {
            String extFile = extDirs[i] + fs + "gnu.io.rxtx.properties";
            File file = new File(extFile);
            if (!file.exists()) continue;
            fileLoc = extFile;
            break;
        }
        if (fileLoc != null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(fileLoc);
                props = new Properties();
                props.load(in);
            }
            catch (Exception e) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (props == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Enumeration<URL> resources = loader.getResources("gnu.io.rxtx.properties");
                if (resources.hasMoreElements()) {
                    URL propertyURL = resources.nextElement();
                    props = new Properties();
                    props.load(propertyURL.openStream());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (props == null) {
            // empty if block
        }
        return props;
    }

    private String getSpecifiedPorts(String key1, String key2) {
        String val = System.getProperty(key1);
        if (val == null && key2 != null) {
            val = System.getProperty(key2);
        }
        if (val == null) {
            Properties props = this.loadRxtxProperties();
            if (props != null) {
                val = props.getProperty(key1);
                if (val != null) {
                    System.setProperty(key1, val);
                } else if (key2 != null) {
                    val = props.getProperty(key2);
                    if (val != null) {
                        System.setProperty(key2, val);
                    } else {
                        System.setProperty(key1, "");
                    }
                }
            }
        } else if (val.equals("")) {
            val = null;
        }
        return val;
    }

    private void registerScannedPorts(int portType) {
        String[] candidateDeviceNames;
        String[] temp;
        if (this.osName.equals("Windows CE")) {
            candidateDeviceNames = temp = new String[]{"COM1:", "COM2:", "COM3:", "COM4:", "COM5:", "COM6:", "COM7:", "COM8:"};
        } else if (this.osName.toLowerCase().indexOf("windows") != -1) {
            int i;
            temp = new String[259];
            for (i = 1; i <= 256; ++i) {
                temp[i - 1] = "COM" + i;
            }
            for (i = 1; i <= 3; ++i) {
                temp[i + 255] = "LPT" + i;
            }
            candidateDeviceNames = temp;
        } else if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
            String[] term = new String[2];
            int l = 0;
            File dev = null;
            dev = new File("/dev/term");
            if (dev.list().length > 0) {
                term[l++] = "term/";
            }
            String[] temp2 = new String[l];
            --l;
            while (l >= 0) {
                temp2[l] = term[l];
                --l;
            }
            candidateDeviceNames = temp2;
        } else {
            File dev = new File(this.deviceDirectory);
            String[] temp3 = dev.list();
            candidateDeviceNames = temp3;
        }
        if (candidateDeviceNames == null) {
            return;
        }
        String[] candidatePortPrefixes = new String[]{};
        switch (portType) {
            case 1: {
                if (this.osName.equals("Linux")) {
                    String[] temp4 = new String[]{"ttyS", "ttySA", "ttyUSB", "rfcomm", "ttyircomm"};
                    candidatePortPrefixes = temp4;
                    break;
                }
                if (this.osName.equals("Linux-all-ports")) {
                    String[] temp5 = new String[]{"comx", "holter", "modem", "rfcomm", "ttyircomm", "ttycosa0c", "ttycosa1c", "ttyACM", "ttyC", "ttyCH", "ttyD", "ttyE", "ttyF", "ttyH", "ttyI", "ttyL", "ttyM", "ttyMX", "ttyP", "ttyR", "ttyS", "ttySI", "ttySR", "ttyT", "ttyUSB", "ttyV", "ttyW", "ttyX"};
                    candidatePortPrefixes = temp5;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("qnx") != -1) {
                    String[] temp6 = new String[]{"ser"};
                    candidatePortPrefixes = temp6;
                    break;
                }
                if (this.osName.equals("Irix")) {
                    String[] temp7 = new String[]{"ttyc", "ttyd", "ttyf", "ttym", "ttyq", "tty4d", "tty4f", "midi", "us"};
                    candidatePortPrefixes = temp7;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] temp8 = new String[]{"ttyd", "cuaa", "ttyA", "cuaA", "ttyD", "cuaD", "ttyE", "cuaE", "ttyF", "cuaF", "ttyR", "cuaR", "stl"};
                    candidatePortPrefixes = temp8;
                    break;
                }
                if (this.osName.equals("NetBSD")) {
                    String[] temp9 = new String[]{"tty0"};
                    candidatePortPrefixes = temp9;
                    break;
                }
                if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                    String[] temp10 = new String[]{"term/", "cua/"};
                    candidatePortPrefixes = temp10;
                    break;
                }
                if (this.osName.equals("HP-UX")) {
                    String[] temp11 = new String[]{"tty0p", "tty1p"};
                    candidatePortPrefixes = temp11;
                    break;
                }
                if (this.osName.equals("UnixWare") || this.osName.equals("OpenUNIX")) {
                    String[] temp12 = new String[]{"tty00s", "tty01s", "tty02s", "tty03s"};
                    candidatePortPrefixes = temp12;
                    break;
                }
                if (this.osName.equals("OpenServer")) {
                    String[] temp13 = new String[]{"tty1A", "tty2A", "tty3A", "tty4A", "tty5A", "tty6A", "tty7A", "tty8A", "tty9A", "tty10A", "tty11A", "tty12A", "tty13A", "tty14A", "tty15A", "tty16A", "ttyu1A", "ttyu2A", "ttyu3A", "ttyu4A", "ttyu5A", "ttyu6A", "ttyu7A", "ttyu8A", "ttyu9A", "ttyu10A", "ttyu11A", "ttyu12A", "ttyu13A", "ttyu14A", "ttyu15A", "ttyu16A"};
                    candidatePortPrefixes = temp13;
                    break;
                }
                if (this.osName.equals("Compaq's Digital UNIX") || this.osName.equals("OSF1")) {
                    String[] temp14 = new String[]{"tty0"};
                    candidatePortPrefixes = temp14;
                    break;
                }
                if (this.osName.equals("BeOS")) {
                    String[] temp15 = new String[]{"serial"};
                    candidatePortPrefixes = temp15;
                    break;
                }
                if (this.osName.equals("Mac OS X")) {
                    String[] temp16 = new String[]{"cu.KeyUSA28X191.", "tty.KeyUSA28X191.", "cu.KeyUSA28X181.", "tty.KeyUSA28X181.", "cu.KeyUSA19181.", "tty.KeyUSA19181."};
                    candidatePortPrefixes = temp16;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") == -1) break;
                String[] temp17 = new String[]{"COM"};
                candidatePortPrefixes = temp17;
                break;
            }
            case 2: {
                if (this.osName.equals("Linux")) {
                    String[] temp18 = new String[]{"lp"};
                    candidatePortPrefixes = temp18;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] temp19 = new String[]{"lpt"};
                    candidatePortPrefixes = temp19;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") != -1) {
                    String[] temp20 = new String[]{"LPT"};
                    candidatePortPrefixes = temp20;
                    break;
                }
                String[] temp21 = new String[]{};
                candidatePortPrefixes = temp21;
                break;
            }
        }
        this.registerValidPorts(candidateDeviceNames, candidatePortPrefixes, portType);
    }

    public CommPort getCommPort(String PortName, int PortType) {
        try {
            switch (PortType) {
                case 1: {
                    if (this.osName.toLowerCase().indexOf("windows") == -1) {
                        return new RXTXPort(PortName);
                    }
                    return new RXTXPort(this.deviceDirectory + PortName);
                }
                case 2: {
                    return new LPRPort(PortName);
                }
            }
        }
        catch (PortInUseException portInUseException) {
            // empty catch block
        }
        return null;
    }

    public void Report(String arg) {
        System.out.println(arg);
    }

    static {
        String libVersion;
        NO_VERSION_OUTPUT = "true".equals(System.getProperty("gnu.io.rxtx.NoVersionOutput"));
        RXTXVersion.loadLibrary("rxtxSerial");
        String jarVersion = RXTXVersion.getVersion();
        try {
            libVersion = RXTXVersion.nativeGetVersion();
        }
        catch (Error unsatisfiedLinkError) {
            libVersion = RXTXCommDriver.nativeGetVersion();
        }
        if (!jarVersion.equals(libVersion)) {
            System.out.println("WARNING:  RXTX Version mismatch\n\tJar version = " + jarVersion + "\n\tnative lib Version = " + libVersion);
        }
    }
}

