/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortEnumerator;
import gnu.io.CommPortOwnershipListener;
import gnu.io.LibraryLoader;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class CommPortIdentifier {
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    public static final int PORT_I2C = 3;
    public static final int PORT_RS485 = 4;
    public static final int PORT_RAW = 5;
    private String portName;
    private boolean available = true;
    private String owner;
    private CommPort commPort;
    private CommDriver driver;
    static CommPortIdentifier CommPortIndex;
    CommPortIdentifier next;
    private int portType;
    private static final boolean debug = false;
    static Object Sync;
    Vector ownershipListener;
    private boolean HideOwnerEvents;

    CommPortIdentifier(String portName, CommPort commPort, int portType, CommDriver driver) {
        this.portName = portName;
        this.commPort = commPort;
        this.portType = portType;
        this.next = null;
        this.driver = driver;
    }

    public static void addPortName(String portName, int portType, CommDriver driver) {
        CommPortIdentifier.addIdentifierToList(new CommPortIdentifier(portName, null, portType, driver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addIdentifierToList(CommPortIdentifier identifier) {
        Object object = Sync;
        synchronized (object) {
            if (CommPortIndex == null) {
                CommPortIndex = identifier;
            } else {
                CommPortIdentifier index = CommPortIndex;
                while (index.next != null) {
                    index = index.next;
                }
                index.next = identifier;
            }
        }
    }

    public void addPortOwnershipListener(CommPortOwnershipListener c) {
        if (this.ownershipListener == null) {
            this.ownershipListener = new Vector();
        }
        if (!this.ownershipListener.contains(c)) {
            this.ownershipListener.addElement(c);
        }
    }

    public String getCurrentOwner() {
        return this.owner;
    }

    public String getName() {
        return this.portName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(String portName) throws NoSuchPortException {
        CommPortIdentifier index;
        Object object = Sync;
        synchronized (object) {
            index = CommPortIndex;
            while (index != null && !index.portName.equals(portName)) {
                index = index.next;
            }
            if (index == null) {
                CommPortIdentifier.getPortIdentifiers();
                index = CommPortIndex;
                while (index != null && !index.portName.equals(portName)) {
                    index = index.next;
                }
            }
        }
        if (index != null) {
            return index;
        }
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommPortIdentifier getPortIdentifier(CommPort port) throws NoSuchPortException {
        CommPortIdentifier c;
        Object object = Sync;
        synchronized (object) {
            c = CommPortIndex;
            while (c != null && c.commPort != port) {
                c = c.next;
            }
        }
        if (c != null) {
            return c;
        }
        throw new NoSuchPortException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration getPortIdentifiers() {
        Object object = Sync;
        synchronized (object) {
            HashMap<String, CommPortIdentifier> oldPorts = new HashMap<String, CommPortIdentifier>();
            CommPortIdentifier p = CommPortIndex;
            while (p != null) {
                oldPorts.put(p.portName, p);
                p = p.next;
            }
            CommPortIndex = null;
            try {
                CommDriver driver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
                driver.initialize();
                CommPortIdentifier curPort = CommPortIndex;
                CommPortIdentifier prevPort = null;
                while (curPort != null) {
                    CommPortIdentifier matchingOldPort = (CommPortIdentifier)oldPorts.get(curPort.portName);
                    if (matchingOldPort != null && matchingOldPort.portType == curPort.portType) {
                        matchingOldPort.driver = curPort.driver;
                        matchingOldPort.next = curPort.next;
                        if (prevPort == null) {
                            CommPortIndex = matchingOldPort;
                        } else {
                            prevPort.next = matchingOldPort;
                        }
                        prevPort = matchingOldPort;
                    } else {
                        prevPort = curPort;
                    }
                    curPort = curPort.next;
                }
            }
            catch (Throwable e) {
                System.err.println(e + " thrown while loading gnu.io.RXTXCommDriver");
                System.err.flush();
            }
        }
        return new CommPortEnumerator();
    }

    public int getPortType() {
        return this.portType;
    }

    public synchronized boolean isCurrentlyOwned() {
        return !this.available;
    }

    public synchronized CommPort open(FileDescriptor f) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    private native String native_psmisc_report_owner(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommPort open(String owner, int timeLimit) throws PortInUseException {
        boolean isAvailable;
        CommPortIdentifier commPortIdentifier = this;
        synchronized (commPortIdentifier) {
            isAvailable = this.available;
            if (isAvailable) {
                this.available = false;
                this.owner = owner;
            }
        }
        if (!isAvailable) {
            long waitTimeEnd = System.currentTimeMillis() + (long)timeLimit;
            this.fireOwnershipEvent(3);
            CommPortIdentifier commPortIdentifier2 = this;
            synchronized (commPortIdentifier2) {
                long waitTimeCurr;
                while (!this.available && (waitTimeCurr = System.currentTimeMillis()) < waitTimeEnd) {
                    try {
                        this.wait(waitTimeEnd - waitTimeCurr);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (isAvailable = this.available) {
                    this.available = false;
                    this.owner = owner;
                }
            }
        }
        if (!isAvailable) {
            throw new PortInUseException(this.getCurrentOwner());
        }
        try {
            String errMsg;
            if (this.commPort == null) {
                this.commPort = this.driver.getCommPort(this.portName, this.portType);
            }
            if (this.commPort != null) {
                this.fireOwnershipEvent(1);
                CommPort waitTimeEnd = this.commPort;
                return waitTimeEnd;
            }
            try {
                errMsg = this.native_psmisc_report_owner(this.portName);
            }
            catch (Throwable t) {
                errMsg = "Port " + this.portName + " already owned... unable to open.";
            }
            throw new PortInUseException(errMsg);
        }
        finally {
            if (this.commPort == null) {
                CommPortIdentifier commPortIdentifier3 = this;
                synchronized (commPortIdentifier3) {
                    this.available = true;
                    this.owner = null;
                }
            }
        }
    }

    public void removePortOwnershipListener(CommPortOwnershipListener c) {
        if (this.ownershipListener != null) {
            this.ownershipListener.removeElement(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalClosePort() {
        CommPortIdentifier commPortIdentifier = this;
        synchronized (commPortIdentifier) {
            this.owner = null;
            this.available = true;
            this.commPort = null;
            this.notifyAll();
        }
        this.fireOwnershipEvent(2);
    }

    void fireOwnershipEvent(int eventType) {
        if (this.ownershipListener != null) {
            Enumeration e = this.ownershipListener.elements();
            while (e.hasMoreElements()) {
                CommPortOwnershipListener c = (CommPortOwnershipListener)e.nextElement();
                c.ownershipChange(eventType);
            }
        }
    }

    static {
        Sync = new Object();
        try {
            CommDriver driver = (CommDriver)Class.forName("gnu.io.RXTXCommDriver").newInstance();
            driver.initialize();
        }
        catch (Throwable e) {
            System.err.println(e + " thrown while loading gnu.io.RXTXCommDriver");
        }
        String os = System.getProperty("os.name");
        if (os.toLowerCase().indexOf("linux") == -1) {
            // empty if block
        }
        if ("true".equals(System.getProperty("gnu.io.rxtx.LibraryLoader"))) {
            LibraryLoader.loadLibrary("rxtxSerial");
        } else {
            System.loadLibrary("rxtxSerial");
        }
    }
}

