/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rxtx;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mbari.vcr4j.rs422.RS422Exception;
import org.mbari.vcr4j.rs422.RS422ResponseParser;
import org.mbari.vcr4j.rs422.RS422State;
import org.mbari.vcr4j.rs422.RS422VideoIO;
import org.mbari.vcr4j.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RXTXVideoIO
extends RS422VideoIO {
    public static final long IO_DELAY = 10L;
    public static final long RECEIVE_TIMEOUT = 40L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private SerialPort serialPort;

    public RXTXVideoIO(SerialPort serialPort, InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream, 10L);
        Preconditions.checkArgument((serialPort != null ? 1 : 0) != 0, (String)"SerialPort can not be null");
        this.serialPort = serialPort;
    }

    public void close() {
        block3: {
            if (this.serialPort != null) {
                this.log.info("Closing serial port:" + this.serialPort.getName());
            }
            try {
                this.getCommandSubject().onCompleted();
                this.getOutputStream().close();
                this.getInputStream().close();
                this.serialPort.close();
                RS422ResponseParser responseParser = this.getResponseParser();
                responseParser.getStatusObservable().onNext((Object)RS422State.STOPPED);
                responseParser.getStatusObservable().onCompleted();
                responseParser.getTimecodeObservable().onCompleted();
                responseParser.getErrorObservable().onCompleted();
                responseParser.getUserbitsObservable().onCompleted();
                this.serialPort = null;
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled() || this.serialPort == null) break block3;
                this.log.error("Problem occured when closing serial port communications on " + this.serialPort.getName());
            }
        }
    }

    public static RXTXVideoIO open(String portName) {
        try {
            SerialPort serialPort = RXTXVideoIO.openSerialPort(portName);
            InputStream inputStream = serialPort.getInputStream();
            OutputStream outputStream = serialPort.getOutputStream();
            return new RXTXVideoIO(serialPort, inputStream, outputStream);
        }
        catch (Exception e) {
            throw new RS422Exception("Failed to open " + portName, (Throwable)e);
        }
    }

    public static SerialPort openSerialPort(String serialPortName) throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException {
        CommPortIdentifier portId = CommPortIdentifier.getPortIdentifier((String)serialPortName);
        SerialPort serialPort = (SerialPort)portId.open("VCR", 2000);
        serialPort.setSerialPortParams(38400, 8, 1, 1);
        serialPort.setFlowControlMode(1);
        serialPort.enableReceiveTimeout(40);
        return serialPort;
    }

    public String getConnectionID() {
        return this.serialPort.getName();
    }
}

