/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.rxtx;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.rxtx.RXTXVideoIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RXTXUtilities {
    private static final Logger log = LoggerFactory.getLogger(RXTXUtilities.class);

    private RXTXUtilities() {
    }

    public static HashSet<CommPortIdentifier> getAvailableSerialPorts() {
        HashSet<CommPortIdentifier> h = new HashSet<CommPortIdentifier>();
        Enumeration thePorts = CommPortIdentifier.getPortIdentifiers();
        block6: while (thePorts.hasMoreElements()) {
            CommPortIdentifier com = (CommPortIdentifier)thePorts.nextElement();
            switch (com.getPortType()) {
                case 1: {
                    try {
                        CommPort thePort = com.open(RXTXUtilities.class.getSimpleName(), 50);
                        thePort.close();
                        log.debug("Serial Port, " + com.getName() + ", is available");
                        h.add(com);
                        break;
                    }
                    catch (PortInUseException e) {
                        if (!log.isInfoEnabled()) continue block6;
                        log.debug("Serial port, " + com.getName() + ", is in use.");
                        break;
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break;
                        log.error("Failed to open serial port " + com.getName(), (Throwable)e);
                    }
                }
            }
        }
        return h;
    }

    public static HashSet<CommPortIdentifier> getParallelPorts() {
        HashSet<CommPortIdentifier> h = new HashSet<CommPortIdentifier>();
        Enumeration thePorts = CommPortIdentifier.getPortIdentifiers();
        while (thePorts.hasMoreElements()) {
            CommPortIdentifier com = (CommPortIdentifier)thePorts.nextElement();
            switch (com.getPortType()) {
                case 2: {
                    h.add(com);
                }
            }
        }
        return h;
    }

    public static HashSet<CommPortIdentifier> getSerialPorts() {
        HashSet<CommPortIdentifier> h = new HashSet<CommPortIdentifier>();
        Enumeration thePorts = CommPortIdentifier.getPortIdentifiers();
        while (thePorts.hasMoreElements()) {
            CommPortIdentifier com = (CommPortIdentifier)thePorts.nextElement();
            switch (com.getPortType()) {
                case 1: {
                    h.add(com);
                }
            }
        }
        return h;
    }

    public static Set<CommPortIdentifier> getVcrPort() {
        HashSet<CommPortIdentifier> serialPorts = RXTXUtilities.getAvailableSerialPorts();
        Iterator<CommPortIdentifier> i = serialPorts.iterator();
        String portName = "";
        HashMap vcrPorts = new HashMap();
        while (i.hasNext()) {
            try {
                CommPortIdentifier port = i.next();
                portName = port.getName();
                RXTXVideoIO io = RXTXVideoIO.open(port.getName());
                io.send((VideoCommand)VideoCommands.REQUEST_STATUS);
                io.getStateObservable().subscribe(state -> vcrPorts.put(port, state.isConnected()), e -> {}, io::close);
            }
            catch (NoSuchElementException e2) {
                log.warn("No response was returned by the VCR");
            }
            catch (Exception e3) {
                log.warn("Problem with accessing serial port: " + portName, (Throwable)e3);
            }
        }
        return vcrPorts.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

