/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui.db.sql;

import java.util.Collection;
import vars.query.ui.ConceptConstraints;
import vars.query.ui.ValuePanel;

public class SQLGenerator {
    public static String getSQL(Collection conceptConstraints, Collection valuePanels, boolean allInterpretations, boolean allAssociations) {
        String whereClause = SQLGenerator.getSQLWhere(conceptConstraints, valuePanels);
        StringBuffer sb = new StringBuffer(SQLGenerator.getSQLSelect(valuePanels));
        sb.append(" FROM Annotations");
        if (allInterpretations && allAssociations) {
            if (whereClause.length() > 0) {
                sb.append(" WHERE ObservationID_FK IN (SELECT ObservationID_FK FROM Annotations");
                sb.append(" WHERE VideoFrameID_FK IN (SELECT VideoFrameID_FK FROM Annotations");
                sb.append(" WHERE ").append(whereClause);
                sb.append(" ))");
            }
        } else if (allInterpretations) {
            if (whereClause.length() > 0) {
                sb.append(" WHERE VideoFrameID_FK IN (SELECT VideoFrameID_FK FROM Annotations");
                sb.append(" WHERE ").append(whereClause);
                sb.append(" )");
            }
        } else if (allAssociations) {
            if (whereClause.length() > 0) {
                sb.append(" WHERE ObservationID_FK IN (SELECT ObservationID_FK FROM Annotations");
                sb.append(" WHERE ").append(whereClause);
                sb.append(" )");
            }
        } else if (whereClause.length() > 0) {
            sb.append(" WHERE ").append(whereClause);
        }
        return sb.toString();
    }

    private static String getSQLSelect(Collection valuePanels) {
        StringBuffer sb = new StringBuffer("SELECT ObservationID_FK, ");
        for (ValuePanel vp : valuePanels) {
            if (!vp.isReturned()) continue;
            sb.append(" ").append(vp.getValueName()).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    private static String getSQLWhere(Collection conceptConstraints, Collection valuePanels) {
        String sql;
        StringBuffer sb = new StringBuffer();
        for (ConceptConstraints cc : conceptConstraints) {
            sql = cc.getSQL();
            if (sql.equals("")) continue;
            sb.append(sql).append(" OR ");
        }
        if (sb.length() > 8) {
            sb.insert(0, "(");
            sb.delete(sb.length() - 4, sb.length()).append(") AND ");
        }
        for (ValuePanel vp : valuePanels) {
            if (!vp.isConstrained() || (sql = vp.getSQL()).length() <= 0) continue;
            sb.append(" ").append(vp.getSQL()).append(" AND ");
        }
        if (sb.length() > 4) {
            sb.delete(sb.length() - 5, sb.length());
        }
        return sb.toString();
    }
}

