/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui.db.sql;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.util.ExceptionHandler;
import org.mbari.util.ExceptionHandlerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.QueryPersistenceService;
import vars.query.QueryResultsDecorator;
import vars.query.results.CoalescingDecorator;
import vars.query.results.QueryResults;
import vars.query.results.SQLQueryable;

public class QueryAction
extends ActionAdapter {
    private static final Logger log = LoggerFactory.getLogger(QueryAction.class);
    private PropertyChangeSupport changeSupport2 = new PropertyChangeSupport((Object)this);
    private ExceptionHandlerSupport exceptionSupport = new ExceptionHandlerSupport();
    private volatile boolean finished;
    private final String query;
    private volatile QueryResults queryResults;
    private final QueryResultsDecorator queryResultsDecorator;
    private final SQLQueryable queryable;
    private boolean showBasicPhylogeny;
    private boolean showFullPhylogeny;
    private boolean showHierarchy;
    private final String coalesceKey;
    private Thread thread;

    public QueryAction(String query, SQLQueryable queryable, QueryPersistenceService queryPersistenceService) {
        this(query, queryable, queryPersistenceService, false, false, false);
    }

    public QueryAction(String query, SQLQueryable queryable, QueryPersistenceService queryPersistenceService, boolean showHiearchy, boolean showBasicPhylogeny, boolean showFullPhylogeny) {
        this.query = query;
        this.queryable = queryable;
        this.queryResultsDecorator = new QueryResultsDecorator(queryPersistenceService);
        this.showHierarchy = showHiearchy;
        this.showBasicPhylogeny = showBasicPhylogeny;
        this.showFullPhylogeny = showFullPhylogeny;
        ResourceBundle bundle = ResourceBundle.getBundle("query-app", Locale.US);
        this.coalesceKey = bundle.getString("queryresults.coalesce.key");
    }

    public synchronized void addExceptionHandler(ExceptionHandler eh) {
        this.exceptionSupport.addExceptionHandler(eh);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport2.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport2.addPropertyChangeListener(propertyName, listener);
    }

    public void cancel() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            if (!SwingUtilities.isEventDispatchThread()) {
                Thread.currentThread().interrupt();
            }
            this.setFinished(true);
        }
    }

    public void doAction() {
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                QueryResults queryResults = null;
                try {
                    queryResults = QueryAction.this.queryable.executeQuery(QueryAction.this.query);
                    queryResults = CoalescingDecorator.coalesce(queryResults, QueryAction.this.coalesceKey);
                    if (QueryAction.this.showHierarchy) {
                        QueryAction.this.queryResultsDecorator.addHierarchy(queryResults);
                    }
                    if (QueryAction.this.showFullPhylogeny) {
                        QueryAction.this.queryResultsDecorator.addFullPhylogeny(queryResults);
                        QueryResultsDecorator.dropEmptyColumns(queryResults);
                    } else if (QueryAction.this.showBasicPhylogeny) {
                        QueryAction.this.queryResultsDecorator.addBasicPhylogeny(queryResults);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(queryResults.toString());
                    }
                }
                catch (Exception e) {
                    QueryAction.this.exceptionSupport.handle(e);
                }
                QueryAction.this.setQueryResults(queryResults);
                QueryAction.this.setFinished(true);
            }
        };
        this.thread = new Thread(worker, ((Object)((Object)this)).getClass().getName() + "-" + System.currentTimeMillis());
        this.thread.start();
    }

    public String getQuery() {
        return this.query;
    }

    public synchronized QueryResults getQueryResults() {
        return this.queryResults;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void removeExceptionHandler(ExceptionHandler eh) {
        this.exceptionSupport.removeExceptionHandler(eh);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport2.removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport2.removePropertyChangeListener(propertyName, listener);
    }

    synchronized void setFinished(boolean complete) {
        boolean oldValue = this.finished;
        boolean newValue = complete;
        this.finished = complete;
        this.changeSupport2.firePropertyChange("finished", oldValue, newValue);
    }

    synchronized void setQueryResults(QueryResults queryResults) {
        QueryResults oldValue = this.queryResults;
        QueryResults newValue = queryResults;
        this.queryResults = queryResults;
        this.changeSupport2.firePropertyChange("queryResults", oldValue, newValue);
    }
}

