/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui.db.preparedstatement;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.VARSException;
import vars.query.ui.ConceptConstraints;
import vars.query.ui.ValuePanel;
import vars.query.ui.db.preparedstatement.ConceptConstraintsWrapper;
import vars.query.ui.db.preparedstatement.ValuePanelWrapper;
import vars.query.ui.db.preparedstatement.ValuePanelWrapperFactory;

public class PreparedStatementGenerator {
    private final Collection<ConceptConstraintsWrapper> conceptConstraintsWrappers;
    private final Collection<ValuePanel> valuePanels;
    private final Collection<ValuePanelWrapper> valuePanelWrappers;
    private final boolean allInterpretations;
    private final boolean allAssociations;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public PreparedStatementGenerator(Collection<ConceptConstraints> conceptConstraints, Collection<ValuePanel> valuePanels, boolean allInterpretations, boolean allAssociations) {
        this.valuePanels = valuePanels;
        this.conceptConstraintsWrappers = Collections2.transform(conceptConstraints, (Function)new Function<ConceptConstraints, ConceptConstraintsWrapper>(){

            public ConceptConstraintsWrapper apply(ConceptConstraints from) {
                return new ConceptConstraintsWrapper(from);
            }
        });
        final ValuePanelWrapperFactory vpFactory = new ValuePanelWrapperFactory();
        this.valuePanelWrappers = Collections2.transform(valuePanels, (Function)new Function<ValuePanel, ValuePanelWrapper>(){

            public ValuePanelWrapper apply(ValuePanel from) {
                return vpFactory.wrap(from);
            }
        });
        this.allInterpretations = allInterpretations;
        this.allAssociations = allAssociations;
    }

    public String getStatementTemplate() {
        String whereClause = this.getSQLWhere(this.conceptConstraintsWrappers, this.valuePanelWrappers);
        StringBuffer sb = new StringBuffer(this.getSQLSelect(this.valuePanels));
        sb.append(" FROM Annotations");
        if (this.allInterpretations && this.allAssociations) {
            if (whereClause.length() > 0) {
                sb.append(" WHERE ObservationID_FK IN (SELECT ObservationID_FK FROM Annotations");
                sb.append(" WHERE VideoFrameID_FK IN (SELECT VideoFrameID_FK FROM Annotations");
                sb.append(" WHERE ").append(whereClause);
                sb.append(" ))");
            }
        } else if (this.allInterpretations) {
            if (whereClause.length() > 0) {
                sb.append(" WHERE VideoFrameID_FK IN (SELECT VideoFrameID_FK FROM Annotations");
                sb.append(" WHERE ").append(whereClause);
                sb.append(" )");
            }
        } else if (this.allAssociations) {
            if (whereClause.length() > 0) {
                sb.append(" WHERE ObservationID_FK IN (SELECT ObservationID_FK FROM Annotations");
                sb.append(" WHERE ").append(whereClause);
                sb.append(" )");
            }
        } else if (whereClause.length() > 0) {
            sb.append(" WHERE ").append(whereClause);
        }
        return sb.toString();
    }

    public void bind(PreparedStatement preparedStatement) {
        int idx = 1;
        try {
            for (ConceptConstraintsWrapper conceptConstraintsWrapper : this.conceptConstraintsWrappers) {
                idx = conceptConstraintsWrapper.bind(preparedStatement, idx);
            }
            for (ValuePanelWrapper valuePanelWrapper : this.valuePanelWrappers) {
                idx = valuePanelWrapper.bind(preparedStatement, idx);
            }
        }
        catch (SQLException e) {
            throw new VARSException("Failed to bind parameters to prepared statement", e);
        }
        this.log.debug("Bound " + (idx - 1) + " items to the preparedStatement");
    }

    private String getSQLSelect(Collection<ValuePanel> valuePanels) {
        StringBuffer sb = new StringBuffer("SELECT ObservationID_FK, ");
        for (ValuePanel vp : valuePanels) {
            if (!vp.isReturned()) continue;
            sb.append(" ").append(vp.getValueName()).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    private String getSQLWhere(Collection<ConceptConstraintsWrapper> conceptConstraintsWrappers, Collection<ValuePanelWrapper> valuePanelWrappers) {
        String sql;
        StringBuffer sb = new StringBuffer();
        for (ConceptConstraintsWrapper wrapper : conceptConstraintsWrappers) {
            sql = wrapper.toSQL();
            if (sql.equals("")) continue;
            sb.append(sql).append(" OR ");
        }
        if (sb.length() > 8) {
            sb.insert(0, "(");
            sb.delete(sb.length() - 4, sb.length()).append(") AND ");
        }
        for (ValuePanelWrapper vp : valuePanelWrappers) {
            sql = vp.toSQL();
            if (sql.length() <= 0) continue;
            sb.append(" ").append(sql).append(" AND ");
        }
        if (sb.length() > 4) {
            sb.delete(sb.length() - 5, sb.length());
        }
        return sb.toString();
    }
}

