/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui.db.preparedstatement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.mbari.sql.QueryableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.VARSException;
import vars.query.results.QueryResults;
import vars.query.ui.ConceptConstraints;
import vars.query.ui.ValuePanel;
import vars.query.ui.db.AbstractQueryExecutor;
import vars.query.ui.db.preparedstatement.PreparedStatementGenerator;

public class EscapedQueryExecutorImpl
extends AbstractQueryExecutor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final QueryableImpl queryable;
    private final PreparedStatementGenerator preparedStatementGenerator;

    public EscapedQueryExecutorImpl(Collection<ConceptConstraints> conceptConstraints, Collection<ValuePanel> valuePanels, boolean allInterpretations, boolean allAssociations, QueryableImpl queryable) {
        super(conceptConstraints, valuePanels, allInterpretations, allAssociations);
        this.queryable = queryable;
        this.preparedStatementGenerator = new PreparedStatementGenerator(conceptConstraints, valuePanels, allInterpretations, allAssociations);
    }

    @Override
    public QueryResults query() {
        try {
            Connection connection = this.queryable.getConnection();
            String template = this.preparedStatementGenerator.getStatementTemplate();
            this.log.debug("PreparedStatement Template = \n" + template);
            PreparedStatement preparedStatement = connection.prepareStatement(template);
            this.preparedStatementGenerator.bind(preparedStatement);
            QueryResults queryResults = QueryResults.fromResultSet(preparedStatement.executeQuery());
            connection.close();
            return queryResults;
        }
        catch (SQLException e) {
            throw new VARSException("Failed to execute prepared statement", e);
        }
    }
}

