/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui.db.preparedstatement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import vars.LinkBean;
import vars.query.ui.ConceptConstraints;

class ConceptConstraintsWrapper {
    protected boolean hasConcepts = false;
    protected boolean hasAssociations = false;
    protected boolean hasLinkName = false;
    protected boolean hasToConcept = false;
    protected boolean hasLinkValue = false;
    protected final ConceptConstraints conceptConstraints;

    public ConceptConstraintsWrapper(ConceptConstraints conceptConstraints) {
        LinkBean associationBean;
        this.conceptConstraints = conceptConstraints;
        Collection<String> conceptNamesAsStrings = conceptConstraints.getConceptNamesAsStrings();
        if (!(conceptNamesAsStrings == null || conceptNamesAsStrings.isEmpty() || conceptNamesAsStrings.contains("nil".toLowerCase()) || conceptNamesAsStrings.contains("nil".toLowerCase()))) {
            this.hasConcepts = true;
        }
        if ((associationBean = conceptConstraints.getAssociationBean()) != null) {
            if (!ConceptConstraints.isWildCard(associationBean.getLinkName())) {
                this.hasAssociations = true;
                this.hasLinkName = true;
            }
            if (!ConceptConstraints.isWildCard(associationBean.getToConcept()) && !associationBean.getToConcept().equalsIgnoreCase("self")) {
                this.hasAssociations = true;
                this.hasToConcept = true;
            }
            if (!ConceptConstraints.isWildCard(associationBean.getLinkValue())) {
                this.hasAssociations = true;
                this.hasLinkValue = true;
            }
        }
    }

    public int bind(PreparedStatement statement, int idx) throws SQLException {
        LinkBean associationBean = this.conceptConstraints.getAssociationBean();
        if (this.hasConcepts) {
            int i;
            ArrayList<String> conceptNamesAsStrings = new ArrayList<String>(this.conceptConstraints.getConceptNamesAsStrings());
            for (i = 0; i < conceptNamesAsStrings.size(); ++i) {
                statement.setString(idx, (String)conceptNamesAsStrings.get(i));
                ++idx;
            }
            if (!this.hasToConcept) {
                for (i = 0; i < conceptNamesAsStrings.size(); ++i) {
                    statement.setString(idx, (String)conceptNamesAsStrings.get(i));
                    ++idx;
                }
            }
            if (this.hasToConcept) {
                statement.setString(idx, associationBean.getToConcept());
                ++idx;
            }
        }
        if (this.hasLinkName) {
            statement.setString(idx, associationBean.getLinkName());
            ++idx;
        }
        if (this.hasLinkValue) {
            statement.setString(idx, associationBean.getLinkValue());
            ++idx;
        }
        if (!this.hasConcepts && this.hasToConcept) {
            statement.setString(idx, associationBean.getToConcept());
            ++idx;
        }
        return idx;
    }

    public String toSQL() {
        if (!this.hasConcepts && !this.hasAssociations) {
            return "";
        }
        StringBuffer sb = new StringBuffer("(");
        if (this.hasConcepts) {
            StringBuffer conceptNames = new StringBuffer();
            for (int i = 0; i < this.conceptConstraints.getConceptNamesAsStrings().size(); ++i) {
                conceptNames.append("?, ");
            }
            conceptNames.delete(conceptNames.length() - 2, conceptNames.length());
            sb.append(" ( ConceptName IN (").append(conceptNames).append(") ");
            if (!this.hasToConcept) {
                sb.append(" OR ToConcept IN (").append(conceptNames).append(") ");
            }
            if (this.hasToConcept) {
                sb.append(" AND ToConcept = ? ");
            }
            sb.append(")");
            if (this.hasAssociations) {
                sb.append(" AND ");
            }
        }
        if (this.hasLinkName) {
            sb.append(" LinkName = ?");
            if (!this.hasConcepts && this.hasToConcept || this.hasLinkValue) {
                sb.append(" AND ");
            }
        }
        if (this.hasLinkValue) {
            sb.append(" LinkValue = ?");
            if (!this.hasConcepts && this.hasToConcept) {
                sb.append(" AND ");
            }
        }
        if (!this.hasConcepts && this.hasToConcept) {
            sb.append(" ToConcept = ?");
        }
        sb.append(")");
        return sb.toString();
    }
}

