/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui.db.preparedstatement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import vars.query.ui.AdvancedStringValuePanel;
import vars.query.ui.db.preparedstatement.AbstractValuePanelWrapper;

public class AdvancedStringValuePanelWrapper
extends AbstractValuePanelWrapper {
    public AdvancedStringValuePanelWrapper(AdvancedStringValuePanel valuePanel) {
        super(valuePanel);
    }

    @Override
    public int bind(PreparedStatement statement, int idx) throws SQLException {
        String text;
        AdvancedStringValuePanel vp = (AdvancedStringValuePanel)this.getValuePanel();
        if (vp.getToggleButton().isSelected()) {
            Object[] obj = vp.getList().getSelectedValues();
            if (obj.length > 0) {
                for (int i = 0; i < obj.length; ++i) {
                    statement.setString(idx, obj[i].toString());
                    ++idx;
                }
            }
        } else if (vp.isConstrained() && (text = vp.getTextField().getText()).length() > 0) {
            statement.setString(idx, "%" + vp.getTextField().getText() + "%");
            ++idx;
        }
        return idx;
    }

    @Override
    public String toSQL() {
        String text;
        StringBuffer sb = new StringBuffer();
        AdvancedStringValuePanel vp = (AdvancedStringValuePanel)this.getValuePanel();
        if (vp.getToggleButton().isSelected()) {
            Object[] obj = vp.getList().getSelectedValues();
            if (obj.length > 0) {
                sb.append(" ").append(vp.getValueName()).append(" IN (");
                for (int i = 0; i < obj.length; ++i) {
                    sb.append("?");
                    if (obj.length <= 0 || i >= obj.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(")");
            }
        } else if (vp.isConstrained() && (text = vp.getTextField().getText()).length() > 0) {
            sb.append(" ").append(vp.getValueName()).append(" LIKE ? ");
        }
        return sb.toString();
    }
}

