/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui.db;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.bushe.swing.event.EventBus;
import org.mbari.util.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.results.QueryResults;
import vars.query.ui.QueryResultsFrame;
import vars.query.ui.StateLookup;
import vars.query.ui.db.QueryAction;

public class QueryActionUI {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final QueryAction queryAction;
    private final PropertyChangeListener queryResultsListener = new QueryResultsListener();
    private final ExceptionHandler queryExceptionHandler = new QueryExceptionHandler();
    private final QueryActionDialog queryActionDialog = new QueryActionDialog();
    private final String databaseUrl;

    public QueryActionUI(QueryAction queryAction, String databaseUrl) {
        this.queryAction = queryAction;
        this.databaseUrl = databaseUrl;
        this.initialize();
    }

    private void initialize() {
        this.queryAction.addPropertyChangeListener("queryResults", this.queryResultsListener);
        this.queryAction.addExceptionHandler(this.queryExceptionHandler);
        this.queryActionDialog.setVisible(true);
    }

    private class QueryResultsListener
    implements PropertyChangeListener {
        private QueryResultsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            QueryResults queryResults = (QueryResults)evt.getNewValue();
            if (queryResults != null) {
                QueryActionUI.this.log.info("Query has been completed");
                SwingUtilities.invokeLater(() -> {
                    QueryActionUI.this.queryActionDialog.dispose();
                    QueryResultsFrame f = new QueryResultsFrame(queryResults, QueryActionUI.this.queryAction.getSQL(), QueryActionUI.this.databaseUrl);
                    f.pack();
                    f.setVisible(true);
                });
            }
        }
    }

    private class QueryExceptionHandler
    extends ExceptionHandler {
        public QueryExceptionHandler() {
            super(Exception.class);
        }

        protected void doAction(final Exception e) {
            QueryActionUI.this.log.info("Unable to complete query.", (Throwable)e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryActionUI.this.queryActionDialog.dispose();
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                }
            });
            if (!SwingUtilities.isEventDispatchThread()) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class QueryActionDialog
    extends JDialog {
        private JPanel buttonPanel;
        private JButton cancelButton;
        private JPanel mainPanel;
        private final Date startDate;
        private final DateFormat dateFormat;
        private JLabel startLabel;
        private final Timer timer;
        private JLabel timerLabel;
        private JLabel topLabel;

        QueryActionDialog() {
            super(StateLookup.getApplication().getQueryFrame());
            this.startDate = new Date();
            this.dateFormat = new SimpleDateFormat("hh:mm:ss a z");
            this.timer = new Timer(950, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel label = QueryActionDialog.this.getTimerLabel();
                    long currentTime = System.currentTimeMillis();
                    long startTime = QueryActionDialog.this.startDate.getTime();
                    long elapsedTime = currentTime - startTime;
                    double minutes = (double)elapsedTime / 1000.0 / 60.0;
                    int min = (int)Math.floor(minutes);
                    int seconds = (int)Math.round((minutes - (double)min) * 60.0);
                    label.setText("    Elapsed time: " + min + " minutes " + seconds + " seconds");
                }
            });
            this.initialize();
            this.timer.start();
        }

        private JPanel getButtonPanel() {
            if (this.buttonPanel == null) {
                this.buttonPanel = new JPanel();
                this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
                this.buttonPanel.add(Box.createHorizontalGlue());
                this.buttonPanel.add(this.getCancelButton());
            }
            return this.buttonPanel;
        }

        private JButton getCancelButton() {
            if (this.cancelButton == null) {
                this.cancelButton = new JButton();
                this.cancelButton.setText("Cancel");
                this.cancelButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        QueryActionUI.this.queryAction.removePropertyChangeListener("queryResults", QueryActionUI.this.queryResultsListener);
                        QueryActionUI.this.queryAction.removeExceptionHandler(QueryActionUI.this.queryExceptionHandler);
                        QueryActionUI.this.queryAction.cancel();
                        QueryActionDialog.this.dispose();
                    }
                });
            }
            return this.cancelButton;
        }

        private JPanel getMainPanel() {
            if (this.mainPanel == null) {
                this.mainPanel = new JPanel();
                this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
                this.mainPanel.add(this.getTopLabel());
                this.mainPanel.add(this.getStartLabel());
                this.mainPanel.add(this.getTimerLabel());
                this.mainPanel.add(this.getButtonPanel());
            }
            return this.mainPanel;
        }

        private JLabel getStartLabel() {
            if (this.startLabel == null) {
                this.startLabel = new JLabel("    Started at " + this.dateFormat.format(this.startDate));
            }
            return this.startLabel;
        }

        private JLabel getTimerLabel() {
            if (this.timerLabel == null) {
                this.timerLabel = new JLabel();
                this.timerLabel.setText("    Elapsed time: 0 minutes  0 seconds");
            }
            return this.timerLabel;
        }

        private JLabel getTopLabel() {
            if (this.topLabel == null) {
                this.topLabel = new JLabel("Executing query");
            }
            return this.topLabel;
        }

        private void initialize() {
            this.getContentPane().add(this.getMainPanel());
            this.pack();
            this.setDefaultCloseOperation(0);
            this.setLocationRelativeTo(null);
        }
    }
}

