/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui.db;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.util.ExceptionHandler;
import org.mbari.util.ExceptionHandlerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.QueryPersistenceService;
import vars.query.QueryResultsDecorator;
import vars.query.results.AssociationColumnRemappingDecorator;
import vars.query.results.CoalescingDecorator;
import vars.query.results.QueryResults;
import vars.query.ui.db.QueryAction;
import vars.query.ui.db.QueryExecutor;

public class QueryActionImpl
extends ActionAdapter
implements QueryAction {
    private static final Logger log = LoggerFactory.getLogger(QueryAction.class);
    private PropertyChangeSupport changeSupport2 = new PropertyChangeSupport(this);
    private ExceptionHandlerSupport exceptionSupport = new ExceptionHandlerSupport();
    private volatile boolean finished;
    private final QueryExecutor queryExecutor;
    private volatile QueryResults queryResults;
    private final QueryResultsDecorator queryResultsDecorator;
    private boolean showBasicPhylogeny;
    private boolean showFullPhylogeny;
    private boolean showHierarchy;
    private boolean showAssociationPerColumn;
    private final String coalesceKey;
    private Thread thread;

    public QueryActionImpl(QueryExecutor queryExecutor, QueryPersistenceService queryPersistenceService) {
        this(queryExecutor, queryPersistenceService, false, false, false, false);
    }

    public QueryActionImpl(QueryExecutor queryExecutor, QueryPersistenceService queryPersistenceService, boolean showHiearchy, boolean showBasicPhylogeny, boolean showFullPhylogeny, boolean showAssociationPerColumn) {
        this.queryExecutor = queryExecutor;
        this.queryResultsDecorator = new QueryResultsDecorator(queryPersistenceService);
        this.showHierarchy = showHiearchy;
        this.showBasicPhylogeny = showBasicPhylogeny;
        this.showFullPhylogeny = showFullPhylogeny;
        this.showAssociationPerColumn = showAssociationPerColumn;
        ResourceBundle bundle = ResourceBundle.getBundle("query-app", Locale.US);
        this.coalesceKey = bundle.getString("queryresults.coalesce.key");
    }

    @Override
    public synchronized void addExceptionHandler(ExceptionHandler eh) {
        this.exceptionSupport.addExceptionHandler(eh);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport2.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport2.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void cancel() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            if (!SwingUtilities.isEventDispatchThread()) {
                Thread.currentThread().interrupt();
            }
            this.setFinished(true);
        }
    }

    public void doAction() {
        Runnable worker = new Runnable(){

            @Override
            public void run() {
                QueryResults queryResults = null;
                try {
                    queryResults = QueryActionImpl.this.queryExecutor.query();
                    if (QueryActionImpl.this.showAssociationPerColumn) {
                        queryResults = AssociationColumnRemappingDecorator.apply(queryResults);
                    }
                    queryResults = CoalescingDecorator.coalesce(queryResults, QueryActionImpl.this.coalesceKey);
                    if (QueryActionImpl.this.showHierarchy) {
                        queryResults = QueryActionImpl.this.queryResultsDecorator.addHierarchy(queryResults);
                    }
                    if (QueryActionImpl.this.showFullPhylogeny) {
                        queryResults = QueryActionImpl.this.queryResultsDecorator.addFullPhylogeny(queryResults);
                        queryResults = QueryResultsDecorator.dropEmptyColumns(queryResults);
                    } else if (QueryActionImpl.this.showBasicPhylogeny) {
                        queryResults = QueryActionImpl.this.queryResultsDecorator.addBasicPhylogeny(queryResults);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(queryResults.toString());
                    }
                }
                catch (Exception e) {
                    QueryActionImpl.this.exceptionSupport.handle(e);
                }
                QueryActionImpl.this.setQueryResults(queryResults);
                QueryActionImpl.this.setFinished(true);
            }
        };
        this.thread = new Thread(worker, this.getClass().getName() + "-" + System.currentTimeMillis());
        this.thread.start();
    }

    @Override
    public synchronized QueryResults getQueryResults() {
        return this.queryResults;
    }

    @Override
    public String getSQL() {
        return this.queryExecutor.getSQL();
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished;
    }

    @Override
    public synchronized void removeExceptionHandler(ExceptionHandler eh) {
        this.exceptionSupport.removeExceptionHandler(eh);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport2.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport2.removePropertyChangeListener(propertyName, listener);
    }

    synchronized void setFinished(boolean complete) {
        boolean oldValue = this.finished;
        boolean newValue = complete;
        this.finished = complete;
        this.changeSupport2.firePropertyChange("finished", oldValue, newValue);
    }

    synchronized void setQueryResults(QueryResults queryResults) {
        QueryResults oldValue = this.queryResults;
        QueryResults newValue = queryResults;
        this.queryResults = queryResults;
        this.changeSupport2.firePropertyChange("queryResults", oldValue, newValue);
    }
}

