/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui.db;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import vars.query.ui.ConceptConstraints;
import vars.query.ui.ValuePanel;
import vars.query.ui.db.QueryExecutor;
import vars.query.ui.db.sql.SQLGenerator;

public abstract class AbstractQueryExecutor
implements QueryExecutor {
    private final Collection<ConceptConstraints> conceptConstraints;
    private final Collection<ValuePanel> valuePanels;
    private final boolean allInterpretations;
    private final boolean allAssociations;

    public AbstractQueryExecutor(Collection<ConceptConstraints> conceptConstraints, Collection<ValuePanel> valuePanels, boolean allInterpretations, boolean allAssociations) {
        this.conceptConstraints = ImmutableList.copyOf(conceptConstraints);
        this.valuePanels = ImmutableList.copyOf(valuePanels);
        this.allInterpretations = allInterpretations;
        this.allAssociations = allAssociations;
    }

    public Collection<ConceptConstraints> getConceptConstraints() {
        return this.conceptConstraints;
    }

    public Collection<ValuePanel> getValuePanels() {
        return this.valuePanels;
    }

    public boolean isAllInterpretations() {
        return this.allInterpretations;
    }

    public boolean isAllAssociations() {
        return this.allAssociations;
    }

    @Override
    public String getSQL() {
        return SQLGenerator.getSQL(this.conceptConstraints, this.valuePanels, this.allInterpretations, this.allAssociations);
    }
}

