/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public abstract class ValuePanel
extends JPanel {
    private static final Pattern PATTERN = Pattern.compile("\\B[A-Z]+");
    private JCheckBox constrainCheckBox = null;
    private JCheckBox returnCheckBox = null;
    private final String valueName;

    public ValuePanel(String name) {
        this.valueName = name;
        this.initialize();
    }

    public boolean isReturned() {
        return this.getReturnCheckBox().isSelected();
    }

    public boolean isConstrained() {
        return this.getConstrainCheckBox().isSelected();
    }

    protected JCheckBox getConstrainCheckBox() {
        if (this.constrainCheckBox == null) {
            this.constrainCheckBox = new JCheckBox();
            this.constrainCheckBox.setToolTipText("Constrain");
        }
        return this.constrainCheckBox;
    }

    protected JCheckBox getReturnCheckBox() {
        if (this.returnCheckBox == null) {
            this.returnCheckBox = new JCheckBox();
            this.returnCheckBox.setToolTipText("Return");
        }
        return this.returnCheckBox;
    }

    public abstract String getSQL();

    public String getValueName() {
        return this.valueName;
    }

    private void initialize() {
        String title = this.valueName;
        if (!this.valueName.toUpperCase().equals(this.valueName)) {
            Matcher matcher = PATTERN.matcher(this.valueName);
            title = matcher.replaceAll(" $0");
        }
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createTitledBorder(null, title, 1, 2, null, null));
        this.add((Component)this.getReturnCheckBox(), null);
        this.add((Component)this.getConstrainCheckBox(), null);
    }
}

