/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mbari.swing.ListListModel;
import vars.query.ui.ValuePanel;

public class StringValuePanel
extends ValuePanel {
    private JList list = null;
    private JScrollPane scrollPane = null;
    private final List values;

    public StringValuePanel(String name, List values) {
        super(name);
        this.values = values;
        this.initialize();
    }

    public JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setVisibleRowCount(4);
            this.list.setModel(new ListListModel(this.values));
            this.list.setEnabled(false);
        }
        return this.list;
    }

    @Override
    public String getSQL() {
        Object[] obj;
        StringBuffer sb = new StringBuffer();
        if (this.getConstrainCheckBox().isSelected() && (obj = this.getList().getSelectedValues()).length > 0) {
            sb.append(" ").append(this.getValueName()).append(" IN (");
            for (int i = 0; i < obj.length; ++i) {
                sb.append("'").append(obj[i].toString()).append("'");
                if (obj.length <= 0 || i >= obj.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getList());
        }
        return this.scrollPane;
    }

    private void initialize() {
        Dimension d = new Dimension(120, 80);
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.add((Component)this.getScrollPane(), null);
        this.getConstrainCheckBox().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean enable = StringValuePanel.this.getConstrainCheckBox().isSelected();
                StringValuePanel.this.getList().setEnabled(enable);
            }
        });
    }
}

