/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import vars.query.ui.ValuePanel;

public class StringLikeValuePanel
extends ValuePanel {
    private JTextField textField;

    public StringLikeValuePanel(String name) {
        super(name);
        this.initialize();
    }

    @Override
    public String getSQL() {
        String text;
        StringBuffer sb = new StringBuffer();
        if (this.getConstrainCheckBox().isSelected() && (text = this.getTextField().getText()).length() > 0) {
            sb.append(" ").append(this.getValueName()).append(" LIKE '%").append(this.getTextField().getText());
            sb.append("%' ");
        }
        return sb.toString();
    }

    public JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.setToolTipText("Enter a value. The query will return items that contain this value.");
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                private void update() {
                    boolean enable = StringLikeValuePanel.this.textField.getText().length() > 0;
                    StringLikeValuePanel.this.getConstrainCheckBox().setSelected(enable);
                }
            });
        }
        return this.textField;
    }

    private void initialize() {
        this.add(this.getTextField());
    }
}

