/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import com.google.inject.Injector;
import foxtrot.Job;
import foxtrot.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.FancyComboBox;
import org.mbari.swing.ListListModel;
import org.mbari.swing.SpinningDialWaitIndicator;
import org.mbari.util.Dispatcher;
import org.mbari.util.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.query.QueryPersistenceService;
import vars.query.ui.App;
import vars.query.ui.AssociationSelectionPanel;
import vars.query.ui.ConceptConstraints;
import vars.query.ui.ConceptNameSelectionPanel;

public class SearchPanel
extends JPanel {
    private static final int RESPONSE_DELAY = 750;
    private JButton addButton = null;
    private JPanel allPanel = null;
    private AssociationSelectionPanel associationSelectionPanel = null;
    private JPanel bottomPanel = null;
    private JButton clearButton = null;
    private JList conceptConstraintsList = null;
    private ConceptNameSelectionPanel conceptNameSelectionPanel = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JPanel mainPanel = null;
    private JPanel middlePanel = null;
    private JButton removeButton = null;
    private JScrollPane scrollPane = null;
    private JPanel topPanel = null;
    private JCheckBox cbAllAssociations;
    private JCheckBox cbAllInterpretations;
    private JCheckBox cbFullPhylogeny;
    private JCheckBox cbHierarchy;
    private JCheckBox cbPhylogeny;
    private JCheckBox cbAssociationPerColumn;
    private ActionAdapter clearAction;
    private final Timer delayTimer;
    private final Injector injector;

    public SearchPanel(Injector injector) {
        this.injector = injector;
        ActionListener changeItemAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchPanel.this.updateAssociationSelectionPanel();
            }
        };
        this.delayTimer = new Timer(750, changeItemAction);
        this.delayTimer.setRepeats(false);
        this.initialize();
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/vars/query/add_conceptname.png"));
            this.addButton.setIcon(icon);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConceptConstraints conceptConstraints = new ConceptConstraints();
                    try {
                        conceptConstraints.setConceptNamesAsStrings(SearchPanel.this.getConceptNameSelectionPanel().getSelectedConceptNamesAsStrings());
                    }
                    catch (Exception e1) {
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e1);
                        SearchPanel.this.log.error("Problem accessing the database", (Throwable)e1);
                        return;
                    }
                    conceptConstraints.setAssociationBean(SearchPanel.this.getAssociationSelectionPanel().getAssociationBean());
                    ListListModel model = (ListListModel)SearchPanel.this.getConceptConstraintsList().getModel();
                    model.add((Object)conceptConstraints);
                }
            });
            this.getConceptConstraintsList().getModel().addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.update();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.update();
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    this.update();
                }

                private void update() {
                    boolean enableThrobber = SearchPanel.this.getConceptConstraintsList().getModel().getSize() < 1;
                }
            });
        }
        return this.addButton;
    }

    private JPanel getAllPanel() {
        if (this.allPanel == null) {
            this.allPanel = new JPanel();
            this.allPanel.setLayout(new BoxLayout(this.allPanel, 1));
            this.allPanel.add(this.getCbAllAssociations());
            this.allPanel.add(this.getCbAllInterpretations());
            this.allPanel.add(this.getCbHierarchy());
            this.allPanel.add(this.getCbPhylogeny());
            this.allPanel.add(this.getCbFullPhylogeny());
            this.allPanel.add(this.getCbAssociationPerColumn());
        }
        return this.allPanel;
    }

    private AssociationSelectionPanel getAssociationSelectionPanel() {
        if (this.associationSelectionPanel == null) {
            this.associationSelectionPanel = (AssociationSelectionPanel)this.injector.getInstance(AssociationSelectionPanel.class);
        }
        return this.associationSelectionPanel;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            this.bottomPanel.setLayout(new BorderLayout());
            this.bottomPanel.add((Component)this.getScrollPane(), "Center");
            this.bottomPanel.add((Component)this.getAllPanel(), "South");
        }
        return this.bottomPanel;
    }

    protected JCheckBox getCbAllAssociations() {
        if (this.cbAllAssociations == null) {
            this.cbAllAssociations = new JCheckBox();
            this.cbAllAssociations.setText("Return related associations");
            this.cbAllAssociations.setToolTipText("Return all associations for the returned annotations");
        }
        return this.cbAllAssociations;
    }

    protected JCheckBox getCbAllInterpretations() {
        if (this.cbAllInterpretations == null) {
            this.cbAllInterpretations = new JCheckBox();
            this.cbAllInterpretations.setText("Return concurrent observations");
            this.cbAllInterpretations.setToolTipText("Return all observations that occur in the same video-frames as the returned annotations");
        }
        return this.cbAllInterpretations;
    }

    protected JCheckBox getCbFullPhylogeny() {
        if (this.cbFullPhylogeny == null) {
            this.cbFullPhylogeny = new JCheckBox();
            this.cbFullPhylogeny.setText("Return detailed organism phylogeny");
            this.cbFullPhylogeny.setToolTipText("Return the detailed phylogeny of the organisms");
        }
        return this.cbFullPhylogeny;
    }

    protected JCheckBox getCbHierarchy() {
        if (this.cbHierarchy == null) {
            this.cbHierarchy = new JCheckBox();
            this.cbHierarchy.setText("Return concept hierarchy");
            this.cbHierarchy.setToolTipText("Return the hierarchy of the concepts");
        }
        return this.cbHierarchy;
    }

    protected JCheckBox getCbPhylogeny() {
        if (this.cbPhylogeny == null) {
            this.cbPhylogeny = new JCheckBox();
            this.cbPhylogeny.setText("Return basic organism phylogeny");
            this.cbPhylogeny.setToolTipText("Return the phylogeny of the organisms");
        }
        return this.cbPhylogeny;
    }

    protected JCheckBox getCbAssociationPerColumn() {
        if (this.cbAssociationPerColumn == null) {
            this.cbAssociationPerColumn = new JCheckBox();
            this.cbAssociationPerColumn.setText("Categorize Associations into columns");
            this.cbAssociationPerColumn.setToolTipText("Categorize associations by link-name into distinct columns");
        }
        return this.cbAssociationPerColumn;
    }

    private ActionAdapter getClearAction() {
        if (this.clearAction == null) {
            this.clearAction = new ActionAdapter(){
                private static final long serialVersionUID = 7394517305352726379L;

                public void doAction() {
                    ListListModel model = (ListListModel)SearchPanel.this.getConceptConstraintsList().getModel();
                    model.clear();
                }
            };
        }
        return this.clearAction;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setText("Clear");
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/vars/query/clear_conceptnames.png"));
            this.clearButton.setIcon(icon);
            this.clearButton.addActionListener((ActionListener)this.getClearAction());
            this.clearButton.setEnabled(false);
            this.getConceptConstraintsList().getModel().addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.update();
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.update();
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    this.update();
                }

                private void update() {
                    boolean enableClearButton = true;
                    if (SearchPanel.this.getConceptConstraintsList().getModel().getSize() < 1) {
                        enableClearButton = false;
                    }
                    SearchPanel.this.clearButton.setEnabled(enableClearButton);
                }
            });
        }
        return this.clearButton;
    }

    public Collection getConceptConstraints() {
        ListListModel model = (ListListModel)this.getConceptConstraintsList().getModel();
        return new ImmutableList(model.getList());
    }

    protected JList getConceptConstraintsList() {
        if (this.conceptConstraintsList == null) {
            this.conceptConstraintsList = new JList(new ListListModel(new ArrayList()));
        }
        return this.conceptConstraintsList;
    }

    private ConceptNameSelectionPanel getConceptNameSelectionPanel() {
        if (this.conceptNameSelectionPanel == null) {
            QueryPersistenceService queryDAO = (QueryPersistenceService)this.injector.getInstance(QueryPersistenceService.class);
            KnowledgebaseDAOFactory daoFactory = (KnowledgebaseDAOFactory)this.injector.getInstance(KnowledgebaseDAOFactory.class);
            this.conceptNameSelectionPanel = new ConceptNameSelectionPanel(queryDAO, daoFactory);
            FancyComboBox cbConceptName = (FancyComboBox)this.conceptNameSelectionPanel.getCbConceptName();
            cbConceptName.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        SearchPanel.this.delayTimer.restart();
                    }
                }
            });
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SearchPanel.this.delayTimer.restart();
                }
            };
            this.conceptNameSelectionPanel.getCParent().addChangeListener(changeListener);
            this.conceptNameSelectionPanel.getCSiblings().addChangeListener(changeListener);
            this.conceptNameSelectionPanel.getCChildren().addChangeListener(changeListener);
            this.conceptNameSelectionPanel.getCDescendant().addChangeListener(changeListener);
            cbConceptName.addEditorActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SearchPanel.this.updateAssociationSelectionPanel();
                }
            });
            cbConceptName.addEditorFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent event) {
                    SearchPanel.this.updateAssociationSelectionPanel();
                }
            });
        }
        return this.conceptNameSelectionPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            this.mainPanel.add((Component)this.getTopPanel(), null);
            this.mainPanel.add((Component)this.getMiddlePanel(), null);
        }
        return this.mainPanel;
    }

    private JPanel getMiddlePanel() {
        if (this.middlePanel == null) {
            this.middlePanel = new JPanel();
            this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 0));
            this.middlePanel.add((Component)this.getAddButton(), null);
            this.middlePanel.add((Component)this.getRemoveButton(), null);
            this.middlePanel.add((Component)this.getClearButton(), null);
        }
        return this.middlePanel;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("Remove");
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/vars/query/remove_conceptname.png"));
            this.removeButton.setIcon(icon);
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ListListModel model = (ListListModel)SearchPanel.this.getConceptConstraintsList().getModel();
                    int[] idx = SearchPanel.this.getConceptConstraintsList().getSelectedIndices();
                    for (int i = 0; i < idx.length; ++i) {
                        model.remove(idx[i]);
                    }
                }
            });
            this.removeButton.setEnabled(false);
            this.getConceptConstraintsList().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    boolean enableRemoveButton = false;
                    if (SearchPanel.this.getConceptConstraintsList().getSelectedIndex() > -1) {
                        enableRemoveButton = true;
                    }
                    SearchPanel.this.removeButton.setEnabled(enableRemoveButton);
                }
            });
        }
        return this.removeButton;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getConceptConstraintsList());
            this.scrollPane.setHorizontalScrollBarPolicy(32);
        }
        return this.scrollPane;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
            this.topPanel.add((Component)this.getConceptNameSelectionPanel(), null);
            this.topPanel.add((Component)this.getAssociationSelectionPanel(), null);
        }
        return this.topPanel;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(587, 357);
        this.add((Component)this.getMainPanel(), "North");
        this.add((Component)this.getBottomPanel(), "Center");
        this.updateAssociationSelectionPanel();
        ActionMap actionMap = this.getActionMap();
        Dispatcher dispatcher = Dispatcher.getDispatcher(App.class);
        App queryApp = (App)dispatcher.getValueObject();
        if (queryApp != null) {
            actionMap.setParent(queryApp.getActionMap());
        }
        actionMap.put("RESET_SearchPanel", (Action)new ActionAdapter(){
            private static final long serialVersionUID = -3079307381079657219L;

            public void doAction() {
                SearchPanel.this.reset();
            }
        });
    }

    public void reset() {
        this.getClearAction().doAction();
        this.getConceptNameSelectionPanel().getCbConceptName().setSelectedItem("nil");
    }

    private void updateAssociationSelectionPanel() {
        SpinningDialWaitIndicator waitIndicator = new SpinningDialWaitIndicator((JComponent)this);
        this.log.debug("Begin updating UI with information from the VARS database");
        Worker.post((Job)new Job(){

            public Object run() {
                Collection<String> names = null;
                try {
                    names = SearchPanel.this.getConceptNameSelectionPanel().getSelectedConceptNamesAsStrings();
                }
                catch (Exception e) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                    SearchPanel.this.log.error("Failed to retrieve concept names from the database.", (Throwable)e);
                }
                SearchPanel.this.getAssociationSelectionPanel().setConceptNames(names);
                return null;
            }
        });
        waitIndicator.dispose();
        this.log.debug("Completed updating UI with information from the VARS database");
    }
}

