/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.results.QueryResults;

public class SaveQueryResultsAsKMLAction
extends ActionAdapter {
    private static final String KEY_CONCEPTNAME = "conceptname";
    private static final String KEY_LATITUDE = "latitude";
    private static final String KEY_LONGITUDE = "longitude";
    private static final String KEY_RECORDEDDATE = "recordeddate";
    private static final String KEY_DEPTH = "depth";
    private static final Logger log = LoggerFactory.getLogger(SaveQueryResultsAsKMLAction.class);
    private final String databaseUrl;
    private final File file;
    private final String query;
    private final QueryResults queryResults;
    final DateFormat dateFormatISO = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };

    public SaveQueryResultsAsKMLAction(File file, QueryResults queryResults) {
        this(file, queryResults, null, null);
    }

    public SaveQueryResultsAsKMLAction(File file, QueryResults queryResults, String query, String databaseUrl) {
        this.file = file;
        this.queryResults = queryResults;
        this.query = query;
        this.databaseUrl = databaseUrl == null ? "unknown" : databaseUrl;
    }

    public void doAction() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write("<!-- " + new Date() + " -->");
            out.write("<!-- DATABASE: " + this.databaseUrl + " -->");
            out.write("<!-- QUERY: " + this.query + " -->");
            out.write("<kml xmlns=\"http://earth.google.com/kml/2.1\">\n");
            out.write("  <Document>\n");
            out.write("    <Style id=\"highlightPlacemark\"><IconStyle><Icon>\n");
            out.write("      <href>http://maps.google.com/mapfiles/kml/paddle/purple-blank.png</href>\n");
            out.write("    </Icon></IconStyle></Style>\n");
            out.write("    <Style id=\"normalPlacemark\"><IconStyle><Icon>\n");
            out.write("      <href>http://maps.google.com/mapfiles/kml/paddle/blu-blank.png</href>\n");
            out.write("    </Icon></IconStyle></Style>\n");
            out.write("    <StyleMap id=\"varsStyleMap\">\n");
            out.write("      <Pair><key>normal</key><styleUrl>#normalPlacemark</styleUrl></Pair>\n");
            out.write("      <Pair><key>highlight</key><styleUrl>#highlightPlacemark</styleUrl></Pair>\n");
            out.write("    </StyleMap>\n");
            out.write("    <Style id=\"highlightPhotoPlacemark\"><IconStyle><Icon>\n");
            out.write("      <href>http://maps.google.com/mapfiles/kml/paddle/purple-square.png</href>\n");
            out.write("    </Icon></IconStyle></Style>\n");
            out.write("    <Style id=\"normalPhotoPlacemark\"><IconStyle><Icon>\n");
            out.write("      <href>http://maps.google.com/mapfiles/kml/paddle/blu-square.png</href>\n");
            out.write("    </Icon></IconStyle></Style>\n");
            out.write("    <StyleMap id=\"varsPhotoStyleMap\">\n");
            out.write("      <Pair><key>normal</key><styleUrl>#normalPhotoPlacemark</styleUrl></Pair>\n");
            out.write("      <Pair><key>highlight</key><styleUrl>#highlightPhotoPlacemark</styleUrl></Pair>\n");
            out.write("    </StyleMap>\n");
            this.queryResultsToPlacemarks(out);
            out.write("  </Document>\n");
            out.write("</kml>\n");
            out.close();
        }
        catch (IOException e) {
            log.error("Unable to save to " + this.file.getAbsolutePath(), (Throwable)e);
        }
    }

    private void queryResultsToPlacemarks(Writer out) throws IOException {
        StringBuilder sb = new StringBuilder();
        Map<String, List<Object>> resultsMap = this.queryResults.copyData();
        TreeSet<String> keys = new TreeSet<String>(resultsMap.keySet());
        TreeMap<String, String> lowerCaseKeys = new TreeMap<String, String>();
        for (String key : keys) {
            lowerCaseKeys.put(key.toLowerCase(), key);
        }
        if (lowerCaseKeys.containsKey(KEY_LATITUDE) && lowerCaseKeys.containsKey(KEY_LONGITUDE) && lowerCaseKeys.containsKey(KEY_CONCEPTNAME)) {
            List<Object> conceptNames = resultsMap.get(lowerCaseKeys.get(KEY_CONCEPTNAME));
            List<Object> latitudes = resultsMap.get(lowerCaseKeys.get(KEY_LATITUDE));
            List<Object> longitudes = resultsMap.get(lowerCaseKeys.get(KEY_LONGITUDE));
            List<Object> recordedDates = resultsMap.get(lowerCaseKeys.get(KEY_RECORDEDDATE));
            List<Object> depths = resultsMap.get(lowerCaseKeys.get(KEY_DEPTH));
            lowerCaseKeys.remove(KEY_CONCEPTNAME);
            lowerCaseKeys.remove(KEY_LATITUDE);
            lowerCaseKeys.remove(KEY_LONGITUDE);
            for (int i = 0; i < conceptNames.size(); ++i) {
                String styleUrl = "#varsStyleMap";
                String conceptName = (String)conceptNames.get(i);
                sb.append("    <Placemark>\n");
                sb.append("      <name>").append(conceptName).append("</name>\n");
                sb.append("      <description><![CDATA[\n");
                for (String key : lowerCaseKeys.keySet()) {
                    Object value = resultsMap.get(lowerCaseKeys.get(key)).get(i);
                    if (value == null || key.endsWith("id_fk")) continue;
                    String valueString = value instanceof Date ? this.dateFormatISO.format(value) : value.toString();
                    sb.append("        <div>");
                    if (valueString.toLowerCase().startsWith("http://")) {
                        sb.append("<img src=\"").append(valueString).append("\" />");
                        styleUrl = "#varsPhotoStyleMap";
                    } else {
                        sb.append((String)lowerCaseKeys.get(key)).append(": ").append(valueString);
                    }
                    sb.append("</div>\n");
                }
                sb.append("      ]]></description>\n");
                sb.append("      <styleUrl>").append(styleUrl).append("</styleUrl>\n");
                try {
                    Number latitude = (Number)latitudes.get(i);
                    Number longitude = (Number)longitudes.get(i);
                    Float depth = Float.valueOf(depths == null || depths.get(i) == null ? 0.0f : -((Number)depths.get(i)).floatValue());
                    if (latitude != null && longitude != null) {
                        sb.append("      <Point><altitudeMode>absolute</altitudeMode><coordinates>").append(longitude).append(",");
                        sb.append(latitude).append(",").append(depth).append("</coordinates></Point>\n");
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to extract position from ResultSet", (Throwable)e);
                }
                try {
                    Date recordedDate = (Date)recordedDates.get(i);
                    if (recordedDate != null) {
                        sb.append("      <TimeStamp>");
                        sb.append("<when>").append(this.dateFormatISO.format(recordedDate)).append("</when>");
                        sb.append("</TimeStamp>\n");
                    }
                }
                catch (Exception e) {
                    log.warn("Failed to extract recorded date from ResultSet", (Throwable)e);
                }
                sb.append("    </Placemark>\n");
                out.write(sb.toString());
                sb.delete(0, sb.length());
            }
        }
    }
}

