/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.util.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.results.QueryResults;

public class SaveQueryResultsAction
extends ActionAdapter {
    private final Logger log = LoggerFactory.getLogger(SaveQueryResultsAction.class);
    private final File file;
    private final String query;
    private final QueryResults queryResults;
    private final String databaseUrl;

    public SaveQueryResultsAction(File file, QueryResults queryResults) {
        this(file, queryResults, null, null);
    }

    public SaveQueryResultsAction(File file, QueryResults queryResults, String query, String databaseUrl) {
        this.file = file;
        this.queryResults = queryResults;
        this.query = query;
        this.databaseUrl = databaseUrl == null ? "unknown" : databaseUrl;
    }

    public void doAction() {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
            out.write(this.header());
            Tuple2<List<String>, List<String[]>> content = this.queryResults.toRowOrientedData();
            List columnNames = (List)content.getA();
            List rows = (List)content.getB();
            String columns = columnNames.stream().collect(Collectors.joining("\t"));
            out.write(columns);
            out.write("\n");
            for (String[] r : rows) {
                String rs = Arrays.stream(r).collect(Collectors.joining("\t"));
                out.write(rs);
                out.write("\n");
            }
            out.close();
        }
        catch (IOException e) {
            this.log.error("Unable to save to " + this.file.getAbsolutePath(), (Throwable)e);
        }
    }

    private String header() {
        StringBuffer sb = new StringBuffer();
        sb.append("# ").append(new Date()).append("\n");
        sb.append("#\n");
        sb.append("# DATABASE\n# ").append(this.databaseUrl).append("\n");
        sb.append("#\n");
        sb.append("# QUERY\n# ").append(this.query).append("\n");
        sb.append("#\n");
        sb.append("# TOTAL RECORDS: ").append(this.queryResults.getRows()).append("\n");
        return sb.toString();
    }
}

