/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.ProgressMonitor;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.awt.event.ActionRunnable;
import org.mbari.awt.event.IAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.ui.QueryResultsFrame;
import vars.query.ui.actions.SaveFramegrabsAction;

public class SaveImagesFromQueryResultsAction
extends ActionAdapter {
    private static final Logger log = LoggerFactory.getLogger(SaveImagesFromQueryResultsAction.class);
    private final SaveFramegrabsAction action = new SaveFramegrabsAction();
    private JFileChooser chooser;
    private QueryResultsFrame queryResultsFrame;

    public void doAction() {
        int option = this.getChooser().showOpenDialog(this.queryResultsFrame);
        if (option == 0) {
            this.action.setSaveLocation(this.getChooser().getSelectedFile());
            URL[] urls = this.getImageURLs();
            this.action.setUrls(urls);
            this.action.setProgressMonitor(new ProgressMonitor(this.queryResultsFrame, "Downloading images", "", 0, urls.length));
            ActionRunnable ar = new ActionRunnable((IAction)this.action);
            ar.start();
        }
    }

    private JFileChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setFileSelectionMode(1);
        }
        return this.chooser;
    }

    private URL[] getImageURLs() {
        String[][] data = this.queryResultsFrame.getQueryResults().toRowOrientedArray();
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (int row = 0; row < data.length; ++row) {
            String[] dataRow = data[row];
            for (int col = 0; col < dataRow.length; ++col) {
                String s;
                String sUpper;
                String obj = data[row][col];
                if (obj == null || !(sUpper = (s = obj.toString()).toUpperCase()).startsWith("HTTP") && !sUpper.startsWith("FILE") || !sUpper.endsWith(".PNG") && !sUpper.endsWith(".JPG") && !sUpper.endsWith(".JPEG") && !sUpper.endsWith(".TIF") && !sUpper.endsWith(".TIFF") && !sUpper.endsWith(".GIF")) continue;
                try {
                    URL url = new URL(s);
                    urlList.add(url);
                    continue;
                }
                catch (MalformedURLException e) {
                    log.info("The value, " + s + ", is not a valid URL");
                }
            }
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public void setQueryResultsFrame(QueryResultsFrame queryResultsFrame) {
        this.queryResultsFrame = queryResultsFrame;
    }
}

