/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.text.IgnoreCaseToStringComparator;
import org.mbari.util.Dispatcher;
import org.mbari.util.ImmutableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.QueryPersistenceService;
import vars.query.ui.AdvancedStringValuePanel;
import vars.query.ui.App;
import vars.query.ui.BooleanValuePanel;
import vars.query.ui.JXDateValuePanel;
import vars.query.ui.NumberValuePanel;
import vars.query.ui.ValuePanel;

public class RefineSearchPanel
extends JPanel {
    private static final Comparator<Object> COMPARATOR = new IgnoreCaseToStringComparator();
    private static final Set<String> DEFAULT_RETURNS = new TreeSet<Object>(COMPARATOR);
    private static final Map<String, Set<String>> COLUMN_GROUPS = new TreeMap<Object, Set<String>>(COMPARATOR);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String[] stringConstraints = new String[]{"Observer", "ShipName", "PlatformName", "ChiefScientist", "Direction"};
    private Collection constraintNames = Arrays.asList(this.stringConstraints);
    private Map metadata;
    private JPanel panel;
    private final QueryPersistenceService queryDAO;
    private JScrollPane scrollPane;
    private Collection valuePanels;

    @Inject
    public RefineSearchPanel(QueryPersistenceService queryDAO) {
        this.queryDAO = queryDAO;
        this.initialize();
    }

    private void addGroupPanels() {
        TreeMap<Object, ValuePanel> panelMap = new TreeMap<Object, ValuePanel>(COMPARATOR);
        Collection panels = this.getValuePanels();
        for (ValuePanel vp : panels) {
            panelMap.put(vp.getValueName(), vp);
        }
        Border border = BorderFactory.createLineBorder(Color.BLACK, 3);
        Font font = new Font("Dialog", 1, 12);
        ArrayList<String> columnsFound = new ArrayList<String>();
        Set<String> groups = COLUMN_GROUPS.keySet();
        Iterator<String> i = groups.iterator();
        while (i.hasNext()) {
            Container groupPanel = null;
            String groupName = i.next();
            Collection columnNames = COLUMN_GROUPS.get(groupName);
            for (String columnName : columnNames) {
                ValuePanel valuePanel = (ValuePanel)panelMap.get(columnName);
                if (valuePanel == null) continue;
                if (groupPanel == null) {
                    groupPanel = new JPanel();
                    groupPanel.setLayout(new BoxLayout(groupPanel, 1));
                    ((JComponent)groupPanel).setBorder(BorderFactory.createTitledBorder(border, groupName, 1, 2, font, Color.BLACK));
                    this.getPanel().add(groupPanel);
                    groupPanel.add(this.makeLabelPanel());
                }
                groupPanel.add(valuePanel);
                columnsFound.add(columnName);
            }
        }
        for (String columnName : columnsFound) {
            panelMap.remove(columnName);
        }
        if (panelMap.size() > 0) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.setBorder(BorderFactory.createTitledBorder(border, "Miscellaneous", 1, 2, font, Color.BLACK));
            this.getPanel().add(p);
            p.add(this.makeLabelPanel());
            ArrayList columnNames = new ArrayList(panelMap.keySet());
            Collections.sort(columnNames);
            for (String columName : columnNames) {
                ValuePanel valuePanel = (ValuePanel)panelMap.get(columName);
                p.add(valuePanel);
            }
        }
    }

    private Map getMetadata() {
        if (this.metadata == null) {
            try {
                this.metadata = this.queryDAO.getMetaData();
            }
            catch (Exception e) {
                this.log.error("Failed to lookup metadata from database", (Throwable)e);
                this.metadata = new HashMap();
            }
        }
        return this.metadata;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.addGroupPanels();
        }
        return this.panel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getPanel());
        }
        return this.scrollPane;
    }

    private ValuePanel getValuePanel(String name, String type) {
        ValuePanel valuePanel;
        block7: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Creating a ValuePanel for " + name + " [" + type + "]");
            }
            valuePanel = null;
            if (type.equals("java.lang.String")) {
                try {
                    if (this.constraintNames.contains(name)) {
                        valuePanel = new AdvancedStringValuePanel(name, this.queryDAO);
                        break block7;
                    }
                    valuePanel = new AdvancedStringValuePanel(name, this.queryDAO);
                }
                catch (Exception e) {
                    this.log.error("Failed to create ValuePanel for " + name, (Throwable)e);
                }
            } else {
                valuePanel = type.equals("java.sql.Timestamp") ? new JXDateValuePanel(name, this.queryDAO) : (type.equals("java.lang.Boolean") ? new BooleanValuePanel(name) : new NumberValuePanel(name, this.queryDAO));
            }
        }
        if (DEFAULT_RETURNS.contains(name)) {
            valuePanel.getReturnCheckBox().setSelected(true);
        }
        return valuePanel;
    }

    public Collection getValuePanels() {
        if (this.valuePanels == null) {
            this.valuePanels = new ArrayList();
            Map metaData = this.getMetadata();
            if (metaData != null) {
                Set keySet = metaData.keySet();
                for (String columnName : keySet) {
                    if (columnName.toUpperCase().indexOf("ID_FK") >= 0) continue;
                    ValuePanel valuePanel = null;
                    try {
                        valuePanel = this.getValuePanel(columnName, (String)metaData.get(columnName));
                    }
                    catch (RuntimeException e) {
                        this.log.warn("Failed to create a ValuePanel for " + columnName, (Throwable)e);
                    }
                    if (valuePanel == null) continue;
                    this.valuePanels.add(valuePanel);
                }
            }
        }
        return new ImmutableCollection(this.valuePanels);
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getScrollPane(), "Center");
        ActionMap actionMap = this.getActionMap();
        Dispatcher dispatcher = Dispatcher.getDispatcher(App.class);
        App queryApp = (App)dispatcher.getValueObject();
        if (queryApp != null) {
            actionMap.setParent(queryApp.getActionMap());
        }
        actionMap.put("RESET_RefineSearchPanel", (Action)new ActionAdapter(){
            private static final long serialVersionUID = -1644037821540418694L;

            public void doAction() {
                RefineSearchPanel.this.reset();
            }
        });
    }

    private JPanel makeLabelPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalStrut(5));
        JLabel m1 = new JLabel();
        m1.setText("return");
        m1.setFont(new Font("Dialog", 0, 9));
        p.add(m1);
        p.add(Box.createHorizontalStrut(5));
        JLabel m2 = new JLabel();
        m2.setText("constrain");
        m2.setFont(new Font("Dialog", 0, 9));
        p.add(m2);
        p.add(Box.createHorizontalGlue());
        return p;
    }

    public void reset() {
        JPanel myPanel = this.getPanel();
        Component[] c = myPanel.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof ValuePanel)) continue;
            ValuePanel valuePanel = (ValuePanel)c[i];
            valuePanel.getConstrainCheckBox().setSelected(false);
            String name = valuePanel.getName();
            boolean selected = false;
            if (DEFAULT_RETURNS.contains(name)) {
                selected = true;
            }
            valuePanel.getReturnCheckBox().setSelected(selected);
        }
    }

    static {
        DEFAULT_RETURNS.add("Associations");
        DEFAULT_RETURNS.add("ConceptName");
        DEFAULT_RETURNS.add("Depth");
        DEFAULT_RETURNS.add("Latitude");
        DEFAULT_RETURNS.add("Longitude");
        DEFAULT_RETURNS.add("RecordedDate");
        DEFAULT_RETURNS.add("Image");
        DEFAULT_RETURNS.add("Observer");
        DEFAULT_RETURNS.add("TapeTimeCode");
        DEFAULT_RETURNS.add("VideoArchiveName");
        DEFAULT_RETURNS.add("RovName");
        DEFAULT_RETURNS.add("DiveNumber");
        TreeSet<String> set = new TreeSet<String>();
        COLUMN_GROUPS.put("Dive", set);
        set.add("ChiefScientist");
        set.add("DiveNumber");
        set.add("DiveStartDate");
        set.add("DiveEndDate");
        set.add("RovName");
        set.add("ShipName");
        set = new TreeSet();
        COLUMN_GROUPS.put("Observation", set);
        set.add("ConceptName");
        set.add("HDTimeCode");
        set.add("InSequence");
        set.add("ObservationDate");
        set.add("Observer");
        set.add("RecordedDate");
        set.add("TapeTimeCode");
        set.add("Notes");
        set = new TreeSet();
        COLUMN_GROUPS.put("Association", set);
        set.add("Associations");
        set.add("LinkName");
        set.add("LinkValue");
        set.add("ToConcept");
        set = new TreeSet();
        COLUMN_GROUPS.put("Camera Data", set);
        set.add("CameraDirection");
        set.add("CameraName");
        set.add("FieldWidth");
        set.add("Focus");
        set.add("Iris");
        set.add("Zoom");
        set = new TreeSet();
        COLUMN_GROUPS.put("Physical Data", set);
        set.add("Depth");
        set.add("Longitude");
        set.add("Latitude");
        set.add("Light");
        set.add("Oxygen");
        set.add("Salinity");
        set.add("Temperature");
    }
}

