/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.mbari.swing.JImageUrlFrame;
import org.mbari.swing.table.TableSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.results.QueryResults;

public class QueryResultsTable
extends JTable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MouseListener urlMouseListener;

    public QueryResultsTable(QueryResults queryResults) {
        this.setAutoCreateColumnsFromModel(true);
        this.setAutoResizeMode(0);
        TableSorter tableSorter = new TableSorter((TableModel)new QueryResultsTableModel(queryResults));
        this.setModel((TableModel)tableSorter);
        tableSorter.setTableHeader(this.getTableHeader());
        this.setColumnWidths();
        this.addMouseListener(this.getUrlMouseListener());
    }

    private MouseListener getUrlMouseListener() {
        if (this.urlMouseListener == null) {
            this.urlMouseListener = new MouseAdapter(){
                JImageUrlFrame imageFrame;

                @Override
                public void mouseClicked(MouseEvent e) {
                    String stringValue;
                    if (e.getClickCount() < 2) {
                        return;
                    }
                    Point clickPoint = e.getPoint();
                    int col = QueryResultsTable.this.columnAtPoint(clickPoint);
                    int row = QueryResultsTable.this.rowAtPoint(clickPoint);
                    Object value = QueryResultsTable.this.getValueAt(row, col);
                    if (value != null && ((stringValue = value.toString()).toLowerCase().startsWith("http") || stringValue.toLowerCase().startsWith("file"))) {
                        URL url = null;
                        try {
                            url = new URL(stringValue);
                            JImageUrlFrame f = this.getImageFrame();
                            f.setTitle(url.toExternalForm());
                            f.setImageUrl(url);
                            f.setVisible(true);
                        }
                        catch (MalformedURLException e1) {
                            QueryResultsTable.this.log.warn("The URL, " + url + ", is not valid. Unable to display it");
                        }
                    }
                }

                JImageUrlFrame getImageFrame() {
                    if (this.imageFrame == null) {
                        this.imageFrame = new JImageUrlFrame();
                        this.imageFrame.setDefaultCloseOperation(1);
                    }
                    return this.imageFrame;
                }
            };
        }
        return this.urlMouseListener;
    }

    private void setColumnWidths() {
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        for (int col = 0; col < columnCount; ++col) {
            int width = this.getColumnName(col).length();
            for (int row = 0; row < rowCount; ++row) {
                Object value = this.getValueAt(row, col);
                if (value == null) continue;
                width = Math.max(width, value.toString().length());
            }
            width = Math.min(width * 7, 400);
            TableColumn tableColumn = this.getColumnModel().getColumn(col);
            tableColumn.setMinWidth(width);
            tableColumn.setPreferredWidth(width);
        }
    }

    class QueryResultsTableModel
    extends DefaultTableModel {
        QueryResultsTableModel(QueryResults queryResults) {
            super(queryResults.toRowOrientedArray(), queryResults.getColumnNames().toArray(new String[queryResults.getColumnNames().size()]));
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

