/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.results.QueryResults;
import vars.query.ui.QueryResultsTable;
import vars.query.ui.SaveImagesFromQueryResultsAction;
import vars.query.ui.SaveQueryResultsAction;
import vars.query.ui.SaveQueryResultsAsKMLAction;

public class QueryResultsFrame
extends JFrame {
    private JPanel jContentPane = null;
    private JMenuItem helpMenuItem = null;
    private JMenu helpMenu = null;
    private JMenu fileMenu = null;
    private JMenuItem closeMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuBar aMenuBar = null;
    private final String query;
    private final QueryResults queryResults;
    private JMenuItem saveMenuItem = null;
    private JMenuItem saveImagesMenuItem = null;
    private JToolBar toolBar = null;
    private JTabbedPane tabbedPane = null;
    private JButton saveImagesButton = null;
    private ActionAdapter saveImagesAction = null;
    private JButton saveButton = null;
    private ActionAdapter saveAction = null;
    private JButton saveAsKMLButton = null;
    private ActionAdapter saveAsKMLAction = null;
    private JPanel queryPanel = null;
    private JLabel queryLabel = null;
    private JTable dataTable = null;
    private JScrollPane dataScrollPane = null;
    private JPanel dataPanel = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String databaseUrl;

    public QueryResultsFrame(QueryResults queryResults) {
        this(queryResults, null, null);
    }

    public QueryResultsFrame(QueryResults queryResults, String query, String databaseUrl) {
        this.queryResults = queryResults;
        this.query = query;
        this.databaseUrl = databaseUrl == null ? "unknown" : databaseUrl;
        this.initialize();
    }

    private JMenuBar getAMenuBar() {
        if (this.aMenuBar == null) {
            this.aMenuBar = new JMenuBar();
            this.aMenuBar.add(this.getFileMenu());
            this.aMenuBar.add(this.getHelpMenu());
        }
        return this.aMenuBar;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
        }
        return this.aboutMenuItem;
    }

    private JMenuItem getCloseMenuItem() {
        if (this.closeMenuItem == null) {
            this.closeMenuItem = new JMenuItem();
            this.closeMenuItem.setText("Close");
            this.closeMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryResultsFrame.this.dispose();
                }
            });
        }
        return this.closeMenuItem;
    }

    private JPanel getDataPanel() {
        if (this.dataPanel == null) {
            this.dataPanel = new JPanel();
            this.dataPanel.setLayout(new BorderLayout());
            this.dataPanel.add((Component)this.getDataScrollPane(), "Center");
        }
        return this.dataPanel;
    }

    private JScrollPane getDataScrollPane() {
        if (this.dataScrollPane == null) {
            this.dataScrollPane = new JScrollPane();
            this.dataScrollPane.setHorizontalScrollBarPolicy(30);
            this.dataScrollPane.setVerticalScrollBarPolicy(20);
            this.dataScrollPane.setViewportView(this.getDataTable());
        }
        return this.dataScrollPane;
    }

    private JTable getDataTable() {
        if (this.dataTable == null) {
            this.dataTable = new QueryResultsTable(this.queryResults);
        }
        return this.dataTable;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getSaveMenuItem());
            this.fileMenu.add(this.getCloseMenuItem());
            this.fileMenu.add(this.getSaveImagesMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
            this.helpMenu.add(this.getHelpMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getHelpMenuItem() {
        if (this.helpMenuItem == null) {
            this.helpMenuItem = new JMenuItem();
        }
        return this.helpMenuItem;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getToolBar(), "North");
            this.jContentPane.add((Component)this.getTabbedPane(), "Center");
        }
        return this.jContentPane;
    }

    public String getQuery() {
        return this.query;
    }

    private JLabel getQueryLabel() {
        if (this.queryLabel == null) {
            this.queryLabel = new JLabel();
            StringBuffer queryText = new StringBuffer();
            queryText.append("<html><head></head><body>");
            queryText.append("<p>").append(new Date()).append("</p><br>");
            queryText.append("<p>DATABASE<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp<strong>");
            queryText.append(this.databaseUrl).append("</strong></p><br>");
            String temp = this.query;
            temp = temp.replaceAll("<=", "&lt;=");
            temp = temp.replaceAll(">=", "&gt;=");
            queryText.append("<p>QUERY<br>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp<strong>");
            queryText.append(temp).append("</strong></p><br>");
            queryText.append("<p>TOTAL RECORDS: ").append(this.queryResults.getRows()).append("</p><br>");
            queryText.append("</body></html>");
            this.queryLabel.setText(queryText.toString());
            this.queryLabel.setVerticalAlignment(1);
            this.queryLabel.setPreferredSize(new Dimension(200, 200));
        }
        return this.queryLabel;
    }

    private JPanel getQueryPanel() {
        if (this.queryPanel == null) {
            this.queryPanel = new JPanel();
            this.queryPanel.setLayout(new BorderLayout());
            this.queryPanel.add((Component)this.getQueryLabel(), "Center");
        }
        return this.queryPanel;
    }

    public QueryResults getQueryResults() {
        return this.queryResults;
    }

    private ActionAdapter getSaveAction() {
        if (this.saveAction == null) {
            this.saveAction = new ActionAdapter(){
                private static final long serialVersionUID = 1L;
                private final JFileChooser chooser = new JFileChooser();

                public void doAction() {
                    int option = this.chooser.showSaveDialog(QueryResultsFrame.this);
                    if (option == 0) {
                        SaveQueryResultsAction action = new SaveQueryResultsAction(this.chooser.getSelectedFile(), QueryResultsFrame.this.queryResults, QueryResultsFrame.this.query, QueryResultsFrame.this.databaseUrl);
                        action.doAction();
                    }
                }
            };
        }
        return this.saveAction;
    }

    private ActionAdapter getSaveAsKmlAction() {
        if (this.saveAsKMLAction == null) {
            this.saveAsKMLAction = new ActionAdapter(){
                private final JFileChooser chooser = new JFileChooser();

                public void doAction() {
                    int option = this.chooser.showSaveDialog(QueryResultsFrame.this);
                    if (option == 0) {
                        SaveQueryResultsAsKMLAction action = new SaveQueryResultsAsKMLAction(this.chooser.getSelectedFile(), QueryResultsFrame.this.queryResults, QueryResultsFrame.this.query, QueryResultsFrame.this.databaseUrl);
                        action.doAction();
                    }
                }
            };
        }
        return this.saveAsKMLAction;
    }

    private JButton getSaveAsKMLButton() {
        if (this.saveAsKMLButton == null) {
            this.saveAsKMLButton = new JButton();
            this.saveAsKMLButton.setText("Save as KML");
            this.saveAsKMLButton.addActionListener((ActionListener)this.getSaveAsKmlAction());
        }
        return this.saveAsKMLButton;
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText("Save");
            this.saveButton.addActionListener((ActionListener)this.getSaveAction());
        }
        return this.saveButton;
    }

    private ActionAdapter getSaveImagesAction() {
        if (this.saveImagesAction == null) {
            this.saveImagesAction = new SaveImagesFromQueryResultsAction();
            ((SaveImagesFromQueryResultsAction)this.saveImagesAction).setQueryResultsFrame(this);
        }
        return this.saveImagesAction;
    }

    private JButton getSaveImagesButton() {
        if (this.saveImagesButton == null) {
            this.saveImagesButton = new JButton();
            this.saveImagesButton.setText("Save Images");
            this.saveImagesButton.addActionListener((ActionListener)this.getSaveImagesAction());
        }
        return this.saveImagesButton;
    }

    private JMenuItem getSaveImagesMenuItem() {
        if (this.saveImagesMenuItem == null) {
            this.saveImagesMenuItem = new JMenuItem();
        }
        return this.saveImagesMenuItem;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.addActionListener((ActionListener)this.getSaveAction());
        }
        return this.saveMenuItem;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Data", this.getDataPanel());
            if (this.query != null) {
                this.tabbedPane.addTab("Query", this.getQueryPanel());
            }
        }
        return this.tabbedPane;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.add(this.getSaveButton());
            this.toolBar.add(this.getSaveAsKMLButton());
            this.toolBar.add(this.getSaveImagesButton());
        }
        return this.toolBar;
    }

    private void initialize() {
        this.setJMenuBar(this.getAMenuBar());
        this.setSize(300, 200);
        this.setContentPane(this.getJContentPane());
        this.setTitle("VARS Query Results (" + this.queryResults.getRows() + " rows)");
    }
}

