/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.query.QueryPersistenceService;
import vars.query.ui.App;
import vars.query.ui.RefineSearchPanel;
import vars.query.ui.SearchPanel;
import vars.query.ui.StateLookup;
import vars.query.ui.db.QueryActionImpl;
import vars.query.ui.db.QueryActionUI;
import vars.query.ui.db.preparedstatement.EscapedQueryExecutorImpl;

public class QueryFrame
extends JFrame {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JMenuItem aboutMenuItem = null;
    private JMenu fileMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem helpMenuItem = null;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JToolBar jToolBar = null;
    private RefineSearchPanel refineSearchPanel = null;
    private ActionAdapter resetAction = null;
    private JButton resetButton = null;
    private ActionAdapter searchAction = null;
    private JButton searchButton = null;
    private JMenuItem searchMenuItem = null;
    private SearchPanel searchPanel = null;
    private JTabbedPane tabbedPane = null;
    private ActionMap actionMap = new ActionMap();
    private final QueryPersistenceService queryPersistenceService;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;

    @Inject
    public QueryFrame(KnowledgebaseDAOFactory knowledgebaseDAOFactory, QueryPersistenceService queryPersistenceService) throws HeadlessException {
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        this.queryPersistenceService = queryPersistenceService;
        this.initialize();
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
        }
        return this.aboutMenuItem;
    }

    private ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
            App queryApp = StateLookup.getApplication();
            if (queryApp != null) {
                this.actionMap.setParent(queryApp.getActionMap());
            }
        }
        return this.actionMap;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getSearchMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getHelpMenuItem());
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getHelpMenuItem() {
        if (this.helpMenuItem == null) {
            this.helpMenuItem = new JMenuItem();
            this.helpMenuItem.setText("Help");
        }
        return this.helpMenuItem;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTabbedPane(), "Center");
            this.jContentPane.add((Component)this.getJToolBar(), "South");
        }
        return this.jContentPane;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setLayout(new BoxLayout(this.jToolBar, 0));
            this.jToolBar.add(Box.createHorizontalGlue());
            this.jToolBar.add((Component)this.getSearchButton(), "Center");
            this.jToolBar.add(Box.createHorizontalGlue());
        }
        return this.jToolBar;
    }

    private RefineSearchPanel getRefineSearchPanel() {
        if (this.refineSearchPanel == null) {
            this.refineSearchPanel = new RefineSearchPanel(this.queryPersistenceService);
        }
        return this.refineSearchPanel;
    }

    private ActionAdapter getResetAction() {
        if (this.resetAction == null) {
            this.resetAction = new ActionAdapter(){

                public void doAction() {
                    ActionMap actionMap = QueryFrame.this.getActionMap();
                    Object[] keys = actionMap.allKeys();
                    for (int i = 0; i < keys.length; ++i) {
                        Object key = keys[i];
                        System.out.println("Found Action with Key of " + key);
                        if (!key.toString().startsWith("RESET")) continue;
                        actionMap.get(key).actionPerformed(null);
                    }
                }
            };
        }
        return this.resetAction;
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton();
            this.resetButton.setAction((Action)this.getResetAction());
            this.resetButton.setText("Reset");
        }
        return this.resetButton;
    }

    private ActionAdapter getSearchAction() {
        if (this.searchAction == null) {
            this.searchAction = new ActionAdapter(){

                public void doAction() {
                    EscapedQueryExecutorImpl queryExecutor = new EscapedQueryExecutorImpl(QueryFrame.this.getSearchPanel().getConceptConstraints(), QueryFrame.this.getRefineSearchPanel().getValuePanels(), QueryFrame.this.getSearchPanel().getCbAllInterpretations().isSelected(), QueryFrame.this.getSearchPanel().getCbAllAssociations().isSelected(), QueryFrame.this.queryPersistenceService.getAnnotationQueryable());
                    QueryActionImpl queryAction = new QueryActionImpl(queryExecutor, QueryFrame.this.queryPersistenceService, QueryFrame.this.getSearchPanel().getCbHierarchy().isSelected(), QueryFrame.this.getSearchPanel().getCbPhylogeny().isSelected(), QueryFrame.this.getSearchPanel().getCbFullPhylogeny().isSelected(), QueryFrame.this.getSearchPanel().getCbAssociationPerColumn().isSelected());
                    new QueryActionUI(queryAction, QueryFrame.this.queryPersistenceService.getURL());
                    QueryFrame.this.log.info("Starting query");
                    queryAction.doAction();
                }
            };
        }
        return this.searchAction;
    }

    private JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new JButton();
            this.searchButton.setAction((Action)this.getSearchAction());
            this.searchButton.setText("Search");
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/vars/query/execute_query.png"));
            this.searchButton.setIcon(icon);
            this.searchButton.setEnabled(false);
            this.searchButton.setToolTipText("Search");
            this.getActionMap().put("Search", (Action)this.getSearchAction());
        }
        return this.searchButton;
    }

    private JMenuItem getSearchMenuItem() {
        if (this.searchMenuItem == null) {
            this.searchMenuItem = new JMenuItem();
            this.searchMenuItem.setText("Search");
        }
        return this.searchMenuItem;
    }

    private SearchPanel getSearchPanel() {
        if (this.searchPanel == null) {
            Injector injector = StateLookup.GUICE_INJECTOR;
            this.searchPanel = new SearchPanel(injector);
            final ListModel listModel = this.searchPanel.getConceptConstraintsList().getModel();
            listModel.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    this.contentsChanged(e);
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    this.contentsChanged(e);
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                    QueryFrame.this.getSearchButton().setEnabled(listModel.getSize() > 0);
                }
            });
        }
        return this.searchPanel;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Basic", this.getSearchPanel());
            this.tabbedPane.addTab("Advanced", this.getRefineSearchPanel());
        }
        return this.tabbedPane;
    }

    private void initialize() {
        this.setJMenuBar(this.getJJMenuBar());
        this.setSize(300, 200);
        this.setContentPane(this.getJContentPane());
        ResourceBundle bundle = ResourceBundle.getBundle("query-app", Locale.US);
        String title = bundle.getString("frame.title");
        this.setTitle(title);
        this.setDefaultCloseOperation(3);
    }
}

