/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.mbari.sql.QueryResults;
import org.mbari.swing.JSimpleButton;
import org.mbari.swing.SpinningDial;
import org.mbari.swingworker.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.QueryPersistenceService;
import vars.query.ui.ValuePanel;

public class NumberValuePanel
extends ValuePanel {
    private JLabel minLabel = null;
    private JTextField minTextField = null;
    private JTextField maxTextField = null;
    private JLabel maxLabel = null;
    private JButton scanButton = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final QueryPersistenceService queryDAO;

    @Inject
    public NumberValuePanel(String name, QueryPersistenceService queryDAO) {
        super(name);
        this.queryDAO = queryDAO;
        this.initialize();
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        if (this.getConstrainCheckBox().isSelected()) {
            if (!this.getMinTextField().getText().equals("")) {
                sb.append(" ").append(this.getValueName()).append(" >= ").append(this.getMinTextField().getText());
            }
            if (!this.getMinTextField().getText().equals("") && !this.getMaxTextField().getText().equals("")) {
                sb.append(" AND ");
            }
            if (!this.getMaxTextField().getText().equals("")) {
                sb.append("  ").append(this.getValueName()).append(" <= ").append(this.getMaxTextField().getText());
            }
        }
        return sb.toString();
    }

    private JTextField getMaxTextField() {
        if (this.maxTextField == null) {
            this.maxTextField = new JTextField();
            this.maxTextField.setPreferredSize(new Dimension(120, 20));
            this.maxTextField.setText("");
            this.maxTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                private void update() {
                    boolean enable = NumberValuePanel.this.getMaxTextField().getText().length() > 0 || NumberValuePanel.this.getMinTextField().getText().length() > 0;
                    NumberValuePanel.this.getConstrainCheckBox().setSelected(enable);
                }
            });
            this.maxTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char key = e.getKeyChar();
                    if (Character.isLetter(key)) {
                        e.consume();
                    }
                }
            });
        }
        return this.maxTextField;
    }

    private JTextField getMinTextField() {
        if (this.minTextField == null) {
            this.minTextField = new JTextField();
            this.minTextField.setPreferredSize(new Dimension(120, 20));
            this.minTextField.setText("");
            this.minTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                private void update() {
                    boolean enable = NumberValuePanel.this.getMaxTextField().getText().length() > 0 || NumberValuePanel.this.getMinTextField().getText().length() > 0;
                    NumberValuePanel.this.getConstrainCheckBox().setSelected(enable);
                }
            });
            this.minTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char key = e.getKeyChar();
                    if (Character.isLetter(key)) {
                        e.consume();
                    }
                }
            });
        }
        return this.minTextField;
    }

    private JButton getScanButton() {
        if (this.scanButton == null) {
            final ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/vars/query/16px/refresh.png"));
            this.scanButton = new JSimpleButton((Icon)icon);
            this.scanButton.setToolTipText("Retrieve minimum and maximum " + this.getValueName() + " values from database");
            this.scanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final String sql = "SELECT MIN(" + NumberValuePanel.this.getValueName() + ") AS minValue, MAX(" + NumberValuePanel.this.getValueName() + ") AS maxValue FROM Annotations WHERE " + NumberValuePanel.this.getValueName() + " IS NOT NULL";
                    NumberValuePanel.this.scanButton.setIcon((Icon)new SpinningDial(16, 16));
                    NumberValuePanel.this.getMinTextField().setEnabled(false);
                    NumberValuePanel.this.getMaxTextField().setEnabled(false);
                    NumberValuePanel.this.scanButton.setEnabled(false);
                    SwingWorker swingWorker = new SwingWorker(){
                        QueryResults queryResults = null;

                        protected Object doInBackground() throws Exception {
                            try {
                                this.queryResults = NumberValuePanel.this.queryDAO.executeQuery(sql);
                            }
                            catch (Exception e1) {
                                NumberValuePanel.this.log.error("An error occurred while executing the SQL statement: '" + sql + "'", (Throwable)e1);
                            }
                            return this.queryResults;
                        }

                        protected void done() {
                            String min = "";
                            String max = "";
                            if (this.queryResults != null && this.queryResults.rowCount() == 1) {
                                List values = this.queryResults.getResults("minValue");
                                min = values.get(0).toString();
                                values = this.queryResults.getResults("maxValue");
                                max = values.get(0).toString();
                            }
                            NumberValuePanel.this.getMinTextField().setText(min);
                            NumberValuePanel.this.getMaxTextField().setText(max);
                            NumberValuePanel.this.scanButton.setIcon(icon);
                            NumberValuePanel.this.getMinTextField().setEnabled(true);
                            NumberValuePanel.this.getMaxTextField().setEnabled(true);
                            NumberValuePanel.this.scanButton.setEnabled(true);
                        }
                    };
                    swingWorker.execute();
                }
            });
        }
        return this.scanButton;
    }

    private void initialize() {
        this.minLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.minLabel.setText(" Min ");
        this.maxLabel.setText(" Max ");
        this.add((Component)this.minLabel, null);
        this.add((Component)this.getMinTextField(), null);
        this.add((Component)this.maxLabel, null);
        this.add((Component)this.getMaxTextField(), null);
        this.add(this.getScanButton());
    }
}

