/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import foxtrot.Job;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.mbari.swing.SearchableComboBoxModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.LinkBean;
import vars.annotation.AnnotationPersistenceService;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.LinkTemplateDAO;
import vars.knowledgebase.SimpleConceptBean;
import vars.knowledgebase.SimpleConceptNameBean;
import vars.shared.ui.HierachicalConceptNameComboBox;

public class LinkTemplateSelectionPanel
extends JPanel {
    private static final Concept selfConcept = new SimpleConceptBean(new SimpleConceptNameBean("self", ConceptNameTypes.PRIMARY.toString()));
    private static final ILink nilLinkTemplate = new LinkBean("nil", "nil", "nil");
    private static final Concept nilConcept = new SimpleConceptBean(new SimpleConceptNameBean("nil", ConceptNameTypes.PRIMARY.toString()));
    private JPanel bottomPanel = null;
    private JComboBox cbLinkTemplates = null;
    private HierachicalConceptNameComboBox cbToConcept = null;
    private JLabel lblLinkName = null;
    private JLabel lblLinkValue = null;
    private JLabel lblSearch = null;
    private JLabel lblToConcept = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JPanel middlePanel = null;
    private JTextField tfLinkName = null;
    private JTextField tfLinkValue = null;
    private JTextField tfSearch = null;
    private JPanel topPanel = null;
    private final AnnotationPersistenceService annotationPersistenceService;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;

    public LinkTemplateSelectionPanel(AnnotationPersistenceService annotationPersistenceService, KnowledgebaseDAOFactory knowledgebaseDAOFactory) {
        this.annotationPersistenceService = annotationPersistenceService;
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        this.initialize();
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            this.lblLinkValue = new JLabel();
            this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
            this.lblToConcept = new JLabel();
            this.lblLinkName = new JLabel();
            this.lblLinkName.setText("link");
            this.lblToConcept.setText("to");
            this.lblLinkValue.setText("value");
            this.bottomPanel.add((Component)this.lblLinkName, null);
            this.bottomPanel.add((Component)this.getTfLinkName(), null);
            this.bottomPanel.add((Component)this.lblToConcept, null);
            this.bottomPanel.add((Component)this.getCbToConcept(), null);
            this.bottomPanel.add((Component)this.lblLinkValue, null);
            this.bottomPanel.add((Component)this.getTfLinkValue(), null);
        }
        return this.bottomPanel;
    }

    private JComboBox getCbLinkTemplates() {
        if (this.cbLinkTemplates == null) {
            this.cbLinkTemplates = new JComboBox();
            this.cbLinkTemplates.setModel(new SearchableComboBoxModel());
            this.cbLinkTemplates.setToolTipText("Links in Knowledgebase");
            this.cbLinkTemplates.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LinkTemplateSelectionPanel.this.setLinkTemplate((ILink)e.getItem());
                    }
                }
            });
        }
        return this.cbLinkTemplates;
    }

    private HierachicalConceptNameComboBox getCbToConcept() {
        if (this.cbToConcept == null) {
            this.cbToConcept = new HierachicalConceptNameComboBox(this.annotationPersistenceService);
        }
        return this.cbToConcept;
    }

    private JPanel getMiddlePanel() {
        if (this.middlePanel == null) {
            this.middlePanel = new JPanel();
            this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 0));
            this.middlePanel.add((Component)this.getCbLinkTemplates(), null);
        }
        return this.middlePanel;
    }

    private JTextField getTfLinkName() {
        if (this.tfLinkName == null) {
            this.tfLinkName = new JTextField();
            this.tfLinkName.setEditable(false);
        }
        return this.tfLinkName;
    }

    private JTextField getTfLinkValue() {
        if (this.tfLinkValue == null) {
            this.tfLinkValue = new JTextField();
        }
        return this.tfLinkValue;
    }

    private JTextField getTfSearch() {
        if (this.tfSearch == null) {
            this.tfSearch = new JTextField();
            this.tfSearch.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent fe) {
                    LinkTemplateSelectionPanel.this.tfSearch.setSelectionStart(0);
                    LinkTemplateSelectionPanel.this.tfSearch.setSelectionEnd(LinkTemplateSelectionPanel.this.tfSearch.getText().length());
                }
            });
            this.tfSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox cb = LinkTemplateSelectionPanel.this.getCbLinkTemplates();
                    int startIndex = cb.getSelectedIndex() + 1;
                    SearchableComboBoxModel linksModel = (SearchableComboBoxModel)cb.getModel();
                    int index = linksModel.searchForItemContaining(LinkTemplateSelectionPanel.this.tfSearch.getText(), startIndex);
                    if (index > -1) {
                        cb.setSelectedIndex(index);
                        cb.hidePopup();
                    } else if (startIndex > 0 && (index = linksModel.searchForItemContaining(LinkTemplateSelectionPanel.this.tfSearch.getText())) > -1) {
                        cb.setSelectedIndex(index);
                        cb.hidePopup();
                    }
                }
            });
        }
        return this.tfSearch;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.lblSearch = new JLabel();
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
            this.lblSearch.setText("Search:");
            this.topPanel.add((Component)this.lblSearch, null);
            this.topPanel.add((Component)this.getTfSearch(), null);
        }
        return this.topPanel;
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(384, 110);
        this.add((Component)this.getTopPanel(), null);
        this.add((Component)this.getMiddlePanel(), null);
        this.add((Component)this.getBottomPanel(), null);
    }

    public void setConcept(Concept concept) {
        this.log.info("Retrieveing LinkTemplates from " + concept);
        if (concept == null) {
            try {
                concept = this.knowledgebaseDAOFactory.newConceptDAO().findRoot();
            }
            catch (Exception e) {
                this.log.error("Failed to lookup root concept", (Throwable)e);
            }
        }
        final Concept fConcept = concept;
        ArrayList<ILink> linkTemplates = (ArrayList<ILink>)Worker.post((Job)new Job(){

            public Object run() {
                LinkTemplateDAO linkTemplateDAO = LinkTemplateSelectionPanel.this.knowledgebaseDAOFactory.newLinkTemplateDAO();
                linkTemplateDAO.startTransaction();
                Concept daoConcept = linkTemplateDAO.find(fConcept);
                Collection<LinkTemplate> links = linkTemplateDAO.findAllApplicableToConcept(daoConcept);
                linkTemplateDAO.endTransaction();
                return new Vector<LinkTemplate>(links);
            }
        });
        linkTemplates = new ArrayList<ILink>(linkTemplates);
        linkTemplates.add(nilLinkTemplate);
        SearchableComboBoxModel model = (SearchableComboBoxModel)this.getCbLinkTemplates().getModel();
        model.clear();
        model.addAll(linkTemplates);
        model.setSelectedItem((Object)nilLinkTemplate);
    }

    public void setLinkTemplate(ILink linkTemplate) {
        if (linkTemplate == null) {
            linkTemplate = nilLinkTemplate;
        }
        this.getTfLinkName().setText(linkTemplate.getLinkName());
        Concept toConcept = null;
        if (linkTemplate.getToConcept().equalsIgnoreCase("self")) {
            toConcept = selfConcept;
        } else if (linkTemplate.getToConcept().equalsIgnoreCase("nil")) {
            toConcept = nilConcept;
        } else {
            try {
                ConceptDAO conceptDAO = this.knowledgebaseDAOFactory.newConceptDAO();
                toConcept = conceptDAO.findByName(linkTemplate.getToConcept());
                if (toConcept == null) {
                    toConcept = conceptDAO.findRoot();
                }
            }
            catch (Exception e) {
                this.log.error("Failed to lookup " + linkTemplate.getToConcept(), (Throwable)e);
                toConcept = new SimpleConceptBean();
                SimpleConceptNameBean conceptName = new SimpleConceptNameBean("nil", ConceptNameTypes.PRIMARY.toString());
                conceptName.setName("nil");
                conceptName.setNameType(ConceptNameTypes.PRIMARY.toString());
                toConcept.addConceptName(conceptName);
            }
        }
        final Concept fToConcept = toConcept;
        Worker.post((Job)new Job(){

            public Object run() {
                LinkTemplateSelectionPanel.this.getCbToConcept().setConcept(fToConcept);
                return null;
            }
        });
        this.getCbToConcept().setSelectedItem((Object)toConcept.getPrimaryConceptName().getName());
        this.getCbToConcept().addItem(nilConcept.getPrimaryConceptName());
        this.getCbToConcept().addItem(selfConcept.getPrimaryConceptName());
        this.getTfLinkValue().setText(linkTemplate.getLinkValue());
    }
}

