/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.bushe.swing.event.EventBus;
import org.jdesktop.swingx.JXDatePicker;
import org.mbari.sql.QueryResults;
import org.mbari.swing.JSimpleButton;
import org.mbari.swing.SpinningDial;
import org.mbari.swingworker.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.QueryPersistenceService;
import vars.query.ui.App;
import vars.query.ui.ValuePanel;

public class JXDateValuePanel
extends ValuePanel {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JLabel maxLabel = null;
    private JLabel minLabel = null;
    private JXDatePicker maxEntryField;
    private JXDatePicker minEntryField;
    private final QueryPersistenceService queryPersistenceService;
    private JButton scanButton;
    private ActionListener constrainActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("datePickerCommit".equals(e.getActionCommand())) {
                JXDateValuePanel.this.getConstrainCheckBox().setSelected(true);
            }
        }
    };
    private PropertyChangeListener constrainPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("date".equals(evt.getPropertyName())) {
                JXDateValuePanel.this.getConstrainCheckBox().setSelected(true);
            }
        }
    };

    public JXDateValuePanel(String name, QueryPersistenceService queryDAO) {
        super(name);
        this.queryPersistenceService = queryDAO;
        this.initialize();
    }

    JXDatePicker getMaxDateField() {
        if (this.maxEntryField == null) {
            this.maxEntryField = new JXDatePicker(new Date());
            this.maxEntryField.setFormats(new DateFormat[]{dateFormat});
            this.maxEntryField.addActionListener(this.constrainActionListener);
            this.maxEntryField.addPropertyChangeListener(this.constrainPropertyListener);
        }
        return this.maxEntryField;
    }

    JXDatePicker getMinDateField() {
        if (this.minEntryField == null) {
            this.minEntryField = new JXDatePicker(App.MIN_RECORDED_DATE);
            this.minEntryField.setFormats(new DateFormat[]{dateFormat});
            this.minEntryField.addActionListener(this.constrainActionListener);
            this.minEntryField.addPropertyChangeListener(this.constrainPropertyListener);
        }
        return this.minEntryField;
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        try {
            if (this.getConstrainCheckBox().isSelected()) {
                String minDate = dateFormat.format(this.getMinDateField().getDate());
                String maxDate = dateFormat.format(this.getMaxDateField().getDate());
                sb.append(" ").append(this.getValueName()).append(" BETWEEN '");
                sb.append(minDate).append("' AND '").append(maxDate).append("'");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private JButton getScanButton() {
        if (this.scanButton == null) {
            final ImageIcon icon = new ImageIcon(this.getClass().getResource("/images/vars/query/16px/refresh.png"));
            this.scanButton = new JSimpleButton((Icon)icon);
            this.scanButton.setToolTipText("Retrieve minimum and maximum " + this.getValueName() + " values from database");
            this.scanButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final String sql = "SELECT MIN(" + JXDateValuePanel.this.getValueName() + ") AS minValue, MAX(" + JXDateValuePanel.this.getValueName() + ") AS maxValue FROM Annotations WHERE " + JXDateValuePanel.this.getValueName() + " IS NOT NULL";
                    JXDateValuePanel.this.scanButton.setIcon((Icon)new SpinningDial(16, 16));
                    JXDateValuePanel.this.getMinDateField().setEnabled(false);
                    JXDateValuePanel.this.getMaxDateField().setEnabled(false);
                    JXDateValuePanel.this.scanButton.setEnabled(false);
                    SwingWorker swingWorker = new SwingWorker(){
                        QueryResults queryResults = null;

                        protected Object doInBackground() throws Exception {
                            try {
                                this.queryResults = JXDateValuePanel.this.queryPersistenceService.executeQuery(sql);
                            }
                            catch (Exception e1) {
                                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)("An error occurred while executing the SQL statement: '" + sql + "'"));
                                JXDateValuePanel.this.log.error("An error occurred while executing the SQL statement: '" + sql + "'", (Throwable)e1);
                            }
                            return this.queryResults;
                        }

                        protected void done() {
                            Date min = null;
                            Date max = null;
                            if (this.queryResults != null && this.queryResults.rowCount() == 1) {
                                List values = this.queryResults.getResults("minValue");
                                min = (Date)values.get(0);
                                values = this.queryResults.getResults("maxValue");
                                max = (Date)values.get(0);
                            }
                            JXDateValuePanel.this.getMinDateField().setDate(min);
                            JXDateValuePanel.this.getMaxDateField().setDate(max);
                            JXDateValuePanel.this.scanButton.setIcon(icon);
                            JXDateValuePanel.this.getMinDateField().setEnabled(true);
                            JXDateValuePanel.this.getMaxDateField().setEnabled(true);
                            JXDateValuePanel.this.scanButton.setEnabled(true);
                        }
                    };
                    swingWorker.execute();
                }
            });
        }
        return this.scanButton;
    }

    private void initialize() {
        this.minLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.minLabel.setText(" Min ");
        this.maxLabel.setText(" Max ");
        this.add((Component)this.minLabel, null);
        this.add((Component)this.getMinDateField());
        this.add((Component)this.maxLabel, null);
        this.add((Component)this.getMaxDateField());
        this.add(Box.createHorizontalGlue());
        this.add(this.getScanButton());
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

