/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.query.QueryPersistenceService;
import vars.shared.ui.ConceptNameComboBox;

public class ConceptNameSelectionPanel
extends JPanel {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JCheckBox cChildren = null;
    private JCheckBox cDescendant = null;
    private JCheckBox cParent = null;
    private JCheckBox cSiblings = null;
    private JComboBox cbConceptName = null;
    private JLabel jLabel = null;
    private JPanel pCheckBoxes = null;
    private final QueryPersistenceService queryDAO;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;

    @Inject
    public ConceptNameSelectionPanel(QueryPersistenceService queryDAO, KnowledgebaseDAOFactory knowledgebaseDAOFactory) {
        this.queryDAO = queryDAO;
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        this.initialize();
    }

    private void addConceptNames(Collection storage, Concept concept) {
        Set<ConceptName> conceptNames = concept.getConceptNames();
        for (ConceptName conceptName : conceptNames) {
            storage.add(conceptName.getName());
        }
    }

    private void addDescendants(Collection storage, Concept concept) {
        this.addConceptNames(storage, concept);
        List<Concept> childConcepts = concept.getChildConcepts();
        for (Concept child : childConcepts) {
            this.addDescendants(storage, child);
        }
    }

    protected JCheckBox getCChildren() {
        if (this.cChildren == null) {
            this.cChildren = new JCheckBox();
            this.cChildren.setText("Children");
        }
        return this.cChildren;
    }

    protected JCheckBox getCDescendant() {
        if (this.cDescendant == null) {
            this.cDescendant = new JCheckBox();
            this.cDescendant.setText("Descendants");
        }
        return this.cDescendant;
    }

    protected JCheckBox getCParent() {
        if (this.cParent == null) {
            this.cParent = new JCheckBox();
            this.cParent.setText("Parent");
        }
        return this.cParent;
    }

    protected JCheckBox getCSiblings() {
        if (this.cSiblings == null) {
            this.cSiblings = new JCheckBox();
            this.cSiblings.setText("Siblings");
        }
        return this.cSiblings;
    }

    protected JComboBox getCbConceptName() {
        if (this.cbConceptName == null) {
            Collection<String> conceptNames;
            try {
                conceptNames = this.queryDAO.findAllNamesUsedInAnnotations();
            }
            catch (Exception e) {
                this.log.error("Failed to lookup conceptnames", (Throwable)e);
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                conceptNames = new ArrayList<String>();
            }
            if (!conceptNames.contains("nil")) {
                conceptNames.add("nil");
            }
            this.cbConceptName = new ConceptNameComboBox(conceptNames.toArray(new String[conceptNames.size()]));
            this.cbConceptName.setSelectedItem("nil");
        }
        return this.cbConceptName;
    }

    private JPanel getPCheckBoxes() {
        if (this.pCheckBoxes == null) {
            this.jLabel = new JLabel();
            this.pCheckBoxes = new JPanel();
            this.pCheckBoxes.setLayout(new BoxLayout(this.pCheckBoxes, 0));
            this.jLabel.setText("Extend to ");
            this.pCheckBoxes.add((Component)this.jLabel, null);
            this.pCheckBoxes.add((Component)this.getCParent(), null);
            this.pCheckBoxes.add((Component)this.getCSiblings(), null);
            this.pCheckBoxes.add((Component)this.getCChildren(), null);
            this.pCheckBoxes.add((Component)this.getCDescendant(), null);
        }
        return this.pCheckBoxes;
    }

    public Collection<String> getSelectedConceptNamesAsStrings() {
        HashSet<String> nameStorage = new HashSet<String>();
        String name = (String)this.getCbConceptName().getSelectedItem();
        Concept concept = this.knowledgebaseDAOFactory.newConceptDAO().findByName(name);
        if (concept == null) {
            nameStorage.add(name);
        } else {
            Concept parent;
            this.addConceptNames(nameStorage, concept);
            if (this.getCParent().isSelected()) {
                parent = concept.getParentConcept();
                this.addConceptNames(nameStorage, parent);
            }
            if (this.getCSiblings().isSelected()) {
                parent = concept.getParentConcept();
                List<Concept> siblings = parent.getChildConcepts();
                for (Concept sibling : siblings) {
                    this.addConceptNames(nameStorage, sibling);
                }
            }
            if (this.getCDescendant().isSelected()) {
                this.addDescendants(nameStorage, concept);
            } else if (this.getCChildren().isSelected()) {
                List<Concept> siblings = concept.getChildConcepts();
                for (Concept sibling : siblings) {
                    this.addConceptNames(nameStorage, sibling);
                }
            }
        }
        return nameStorage;
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(397, 47);
        this.setBorder(BorderFactory.createTitledBorder(null, "Search for", 1, 2, new Font("Dialog", 1, 12), Color.RED));
        this.add((Component)this.getCbConceptName(), null);
        this.add((Component)this.getPCheckBoxes(), null);
    }

    public void setSelectedConceptName(String conceptName) {
        this.getCbConceptName().setSelectedItem(conceptName);
    }
}

