/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import java.util.Collection;
import java.util.Iterator;
import vars.LinkBean;

public class ConceptConstraints {
    public static final String WILD_CARD_STRING = "nil";
    public static final String EMPTY_SQL = "";
    private LinkBean associationBean;
    private Collection<String> conceptNamesAsStrings;

    public LinkBean getAssociationBean() {
        return this.associationBean;
    }

    public Collection<String> getConceptNamesAsStrings() {
        return this.conceptNamesAsStrings;
    }

    public String getSQL() {
        boolean hasConcepts = false;
        boolean hasAssociations = false;
        boolean hasLinkName = false;
        boolean hasToConcept = false;
        boolean hasLinkValue = false;
        if (!(this.conceptNamesAsStrings == null || this.conceptNamesAsStrings.isEmpty() || this.conceptNamesAsStrings.contains(WILD_CARD_STRING.toLowerCase()) || this.conceptNamesAsStrings.contains(WILD_CARD_STRING.toLowerCase()))) {
            hasConcepts = true;
        }
        if (this.associationBean != null) {
            if (!ConceptConstraints.isWildCard(this.associationBean.getLinkName())) {
                hasAssociations = true;
                hasLinkName = true;
            }
            if (!ConceptConstraints.isWildCard(this.associationBean.getToConcept()) && !this.associationBean.getToConcept().equalsIgnoreCase("self")) {
                hasAssociations = true;
                hasToConcept = true;
            }
            if (!ConceptConstraints.isWildCard(this.associationBean.getLinkValue())) {
                hasAssociations = true;
                hasLinkValue = true;
            }
        }
        if (!hasConcepts && !hasAssociations) {
            return EMPTY_SQL;
        }
        StringBuffer sb = new StringBuffer("(");
        if (hasConcepts) {
            StringBuffer conceptNames = new StringBuffer();
            for (String conceptName : this.conceptNamesAsStrings) {
                conceptNames.append("'").append(conceptName).append("', ");
            }
            conceptNames.delete(conceptNames.length() - 2, conceptNames.length());
            sb.append(" ( ConceptName IN (").append(conceptNames).append(") ");
            if (!hasToConcept) {
                sb.append(" OR ToConcept IN (").append(conceptNames).append(") ");
            }
            if (hasToConcept) {
                sb.append(" AND ToConcept = '").append(this.associationBean.getToConcept()).append("' ");
            }
            sb.append(")");
            if (hasAssociations) {
                sb.append(" AND ");
            }
        }
        if (hasLinkName) {
            sb.append(" LinkName = '").append(this.associationBean.getLinkName()).append("' ");
            if (!hasConcepts && hasToConcept || hasLinkValue) {
                sb.append(" AND ");
            }
        }
        if (hasLinkValue) {
            sb.append(" LinkValue = '").append(this.associationBean.getLinkValue()).append("' ");
            if (!hasConcepts && hasToConcept) {
                sb.append(" AND ");
            }
        }
        if (!hasConcepts && hasToConcept) {
            sb.append(" ToConcept = '").append(this.associationBean.getToConcept()).append("' ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static boolean isWildCard(String value) {
        boolean wildCard = false;
        if (WILD_CARD_STRING.equalsIgnoreCase(value)) {
            wildCard = true;
        }
        return wildCard;
    }

    public void setAssociationBean(LinkBean associationBean) {
        this.associationBean = associationBean;
    }

    public void setConceptNamesAsStrings(Collection conceptNamesAsStrings) {
        this.conceptNamesAsStrings = conceptNamesAsStrings;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.conceptNamesAsStrings == null || this.conceptNamesAsStrings.contains(WILD_CARD_STRING.toLowerCase()) || this.conceptNamesAsStrings.contains(WILD_CARD_STRING.toUpperCase())) {
            sb.append(WILD_CARD_STRING);
        } else {
            Iterator<String> i = this.conceptNamesAsStrings.iterator();
            while (i.hasNext()) {
                sb.append((Object)i.next());
                sb.append(", ");
            }
            sb.delete(sb.length() - 2, sb.length());
        }
        if (this.associationBean != null) {
            sb.append(": ");
            sb.append(this.associationBean.toString());
        }
        return sb.toString();
    }
}

