/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.SearchableComboBoxModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.LinkBean;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.SimpleConceptNameBean;
import vars.query.QueryPersistenceService;
import vars.shared.ui.AllConceptNamesComboBox;

public class AssociationSelectionPanel
extends JPanel {
    private JPanel bottomPanel = null;
    private JComboBox cbAssociations = null;
    private AllConceptNamesComboBox cbToConcept = null;
    private JLabel lblLinkName = null;
    private JLabel lblLinkValue = null;
    private JLabel lblSearch = null;
    private JLabel lblToConcept = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JPanel middlePanel = null;
    private final LinkBean nilAssociationBean = new LinkBean("nil", "nil", "nil");
    private final ConceptName nilConceptName = new SimpleConceptNameBean("nil".toUpperCase(), ConceptNameTypes.PRIMARY.getName());
    private final ConceptName selfConceptName = new SimpleConceptNameBean("self", ConceptNameTypes.PRIMARY.getName());
    private JTextField tfLinkName = null;
    private JTextField tfLinkValue = null;
    private JTextField tfSearch = null;
    private JPanel topPanel = null;
    private Collection conceptNames = new ArrayList();
    private final QueryPersistenceService queryPersistenceService;

    @Inject
    public AssociationSelectionPanel(QueryPersistenceService queryPersistenceService) {
        this.queryPersistenceService = queryPersistenceService;
        this.initialize();
    }

    public LinkBean getAssociationBean() {
        LinkBean bean = new LinkBean();
        bean.setLinkName(this.getTfLinkName().getText());
        bean.setToConcept((String)this.getCbToConcept().getSelectedItem());
        bean.setLinkValue(this.getTfLinkValue().getText());
        return bean;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            this.lblLinkValue = new JLabel();
            this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
            this.lblToConcept = new JLabel();
            this.lblLinkName = new JLabel();
            this.lblLinkName.setText("link");
            this.lblToConcept.setText("to");
            this.lblLinkValue.setText("value");
            this.bottomPanel.add((Component)this.lblLinkName, null);
            this.bottomPanel.add(Box.createHorizontalStrut(5));
            this.bottomPanel.add((Component)this.getTfLinkName(), null);
            this.bottomPanel.add(Box.createHorizontalStrut(10));
            this.bottomPanel.add((Component)this.lblToConcept, null);
            this.bottomPanel.add(Box.createHorizontalStrut(5));
            this.bottomPanel.add((Component)this.getCbToConcept(), null);
            this.bottomPanel.add(Box.createHorizontalStrut(10));
            this.bottomPanel.add((Component)this.lblLinkValue, null);
            this.bottomPanel.add(Box.createHorizontalStrut(5));
            this.bottomPanel.add((Component)this.getTfLinkValue(), null);
        }
        return this.bottomPanel;
    }

    private JComboBox getCbAssociations() {
        if (this.cbAssociations == null) {
            this.cbAssociations = new JComboBox();
            this.cbAssociations.setModel(new SearchableComboBoxModel());
            this.cbAssociations.setToolTipText("Links in Knowledgebase");
            this.cbAssociations.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AssociationSelectionPanel.this.setAssociationBean((LinkBean)e.getItem());
                    }
                }
            });
        }
        return this.cbAssociations;
    }

    private AllConceptNamesComboBox getCbToConcept() {
        if (this.cbToConcept == null) {
            this.cbToConcept = new AllConceptNamesComboBox(this.queryPersistenceService);
            this.cbToConcept.addItem(this.nilConceptName);
            this.cbToConcept.addItem(this.selfConceptName);
        }
        return this.cbToConcept;
    }

    private JPanel getMiddlePanel() {
        if (this.middlePanel == null) {
            this.middlePanel = new JPanel();
            this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 0));
            this.middlePanel.add((Component)this.getCbAssociations(), null);
        }
        return this.middlePanel;
    }

    private JTextField getTfLinkName() {
        if (this.tfLinkName == null) {
            this.tfLinkName = new JTextField();
            this.tfLinkName.setEditable(false);
            this.tfLinkName.setPreferredSize(new Dimension(120, 20));
        }
        return this.tfLinkName;
    }

    private JTextField getTfLinkValue() {
        if (this.tfLinkValue == null) {
            this.tfLinkValue = new JTextField();
            this.tfLinkValue.setPreferredSize(new Dimension(120, 20));
        }
        return this.tfLinkValue;
    }

    private JTextField getTfSearch() {
        if (this.tfSearch == null) {
            this.tfSearch = new JTextField();
            this.tfSearch.setPreferredSize(new Dimension(120, 20));
            this.tfSearch.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent fe) {
                    AssociationSelectionPanel.this.tfSearch.setSelectionStart(0);
                    AssociationSelectionPanel.this.tfSearch.setSelectionEnd(AssociationSelectionPanel.this.tfSearch.getText().length());
                }
            });
            this.tfSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index;
                    JComboBox cb = AssociationSelectionPanel.this.getCbAssociations();
                    SearchableComboBoxModel linksModel = (SearchableComboBoxModel)cb.getModel();
                    int startIndex = cb.getSelectedIndex() + 1;
                    if (startIndex > linksModel.getSize() - 1) {
                        startIndex = 0;
                    }
                    if ((index = linksModel.searchForItemContaining(AssociationSelectionPanel.this.tfSearch.getText(), startIndex)) > -1) {
                        cb.setSelectedIndex(index);
                        cb.hidePopup();
                    } else if (startIndex > 0 && (index = linksModel.searchForItemContaining(AssociationSelectionPanel.this.tfSearch.getText())) > -1) {
                        cb.setSelectedIndex(index);
                        cb.hidePopup();
                    }
                }
            });
        }
        return this.tfSearch;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.lblSearch = new JLabel();
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BoxLayout(this.topPanel, 0));
            this.lblSearch.setText("Search:");
            this.topPanel.add((Component)this.lblSearch, null);
            this.topPanel.add((Component)this.getTfSearch(), null);
        }
        return this.topPanel;
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 1));
        this.setSize(384, 110);
        this.setBorder(BorderFactory.createTitledBorder(null, "with association", 1, 2, new Font("Dialog", 1, 12), Color.RED));
        this.add((Component)this.getTopPanel(), null);
        this.add((Component)this.getMiddlePanel(), null);
        this.add((Component)this.getBottomPanel(), null);
    }

    public void setAssociationBean(LinkBean associationBean) {
        if (associationBean == null) {
            associationBean = this.nilAssociationBean;
        }
        this.getTfLinkName().setText(associationBean.getLinkName());
        this.getCbToConcept().setSelectedItem((Object)associationBean.getToConcept());
        this.getTfLinkValue().setText(associationBean.getLinkValue());
    }

    public void setConceptNames(Collection conceptNames_) {
        if (this.conceptNames.equals(conceptNames_)) {
            return;
        }
        this.conceptNames = conceptNames_;
        if (this.log.isInfoEnabled()) {
            this.log.info("Using the following concept-names: " + this.conceptNames);
        }
        if (this.conceptNames == null) {
            this.conceptNames = new ArrayList();
        }
        if (this.conceptNames.isEmpty()) {
            this.conceptNames.add("object");
        }
        Collection<ILink> associationBeans = null;
        try {
            associationBeans = this.conceptNames.contains("nil".toLowerCase()) || this.conceptNames.contains("nil".toUpperCase()) ? this.queryPersistenceService.findAllLinkTemplates() : this.queryPersistenceService.findLinksByConceptNames(this.conceptNames);
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            this.log.error("Failed to look up associations", (Throwable)e);
        }
        if (associationBeans == null) {
            associationBeans = new ArrayList<ILink>();
        }
        if (!associationBeans.contains(this.nilAssociationBean)) {
            associationBeans.add(this.nilAssociationBean);
        }
        final SearchableComboBoxModel model = (SearchableComboBoxModel)this.getCbAssociations().getModel();
        final Collection<ILink> aBeans = associationBeans;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                model.clear();
                model.addAll(aBeans);
                model.setSelectedItem((Object)AssociationSelectionPanel.this.nilAssociationBean);
            }
        });
    }
}

