/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import com.google.inject.Inject;
import com.google.inject.Injector;
import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventTopicSubscriber;
import org.mbari.swing.SplashFrame;
import org.mbari.util.SystemUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.query.ui.QueryFrame;
import vars.query.ui.StateLookup;
import vars.shared.ui.event.FatalExceptionSubscriber;
import vars.shared.ui.event.NonFatalErrorSubscriber;
import vars.shared.ui.event.WarningSubscriber;

public class App {
    public static final Date MIN_RECORDED_DATE = new Date(378720000000L);
    private static Logger log;
    private ActionMap actionMap;
    private InputMap inputMap;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    private QueryFrame queryFrame;
    private static final List<EventTopicSubscriber> GC_PREVENTION;

    @Inject
    public App(KnowledgebaseDAOFactory knowledgebaseDAOFactory) {
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        StateLookup.setApplication(this);
        this.initialize();
        FatalExceptionSubscriber fatalErrorSubscriber = new FatalExceptionSubscriber((Frame)this.getQueryFrame());
        NonFatalErrorSubscriber nonFatalErrorSubscriber = new NonFatalErrorSubscriber((Frame)this.getQueryFrame());
        WarningSubscriber warningSubscriber = new WarningSubscriber((Frame)this.getQueryFrame());
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (EventTopicSubscriber)fatalErrorSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (EventTopicSubscriber)nonFatalErrorSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicWarning", (EventTopicSubscriber)warningSubscriber);
        GC_PREVENTION.add((EventTopicSubscriber)fatalErrorSubscriber);
        GC_PREVENTION.add((EventTopicSubscriber)nonFatalErrorSubscriber);
        GC_PREVENTION.add((EventTopicSubscriber)warningSubscriber);
    }

    public ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public InputMap getInputMap() {
        if (this.inputMap == null) {
            this.inputMap = new InputMap();
        }
        return this.inputMap;
    }

    private static Logger getLog() {
        if (log == null) {
            log = LoggerFactory.getLogger(App.class);
        }
        return log;
    }

    public QueryFrame getQueryFrame() {
        if (this.queryFrame == null) {
            Injector injector = StateLookup.GUICE_INJECTOR;
            this.queryFrame = (QueryFrame)injector.getInstance(QueryFrame.class);
            this.queryFrame.setSize(300, 200);
            StateLookup.setApplicationFrame(this.queryFrame);
        }
        return this.queryFrame;
    }

    private void initialize() {
        ImageIcon mbariLogo = new ImageIcon(this.getClass().getResource("/images/vars/query/query-splash.png"));
        SplashFrame splashFrame = new SplashFrame(mbariLogo);
        splashFrame.setMessage(" Loading configuration...");
        splashFrame.setVisible(true);
        splashFrame.repaint();
        splashFrame.setMessage(" Loading knowledgebase...");
        splashFrame.repaint();
        try {
            Worker.post((Task)new Task(){

                public Object run() throws Exception {
                    try {
                        App.this.knowledgebaseDAOFactory.newConceptDAO().findRoot();
                    }
                    catch (Exception e) {
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (Object)e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            App.getLog().error("Failed to load the knowledgebase", (Throwable)e);
            splashFrame.setMessage(" Error: Failed to load the knowledgebase");
            splashFrame.repaint();
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(-1);
        }
        splashFrame.setMessage(" Initializing the GUI...");
        splashFrame.repaint();
        this.getQueryFrame().pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getQueryFrame().getSize();
        double newHeight = screenSize.getHeight() - 150.0;
        frameSize.setSize(650, (int)newHeight);
        this.getQueryFrame().setSize(frameSize);
        this.getQueryFrame().setVisible(true);
        this.getQueryFrame().setIconImage(mbariLogo.getImage());
        splashFrame.dispose();
    }

    public static void main(String[] args) {
        System.setProperty("user.timezone", "UTC");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        StateLookup.getSettingsDirectory();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable e) {
                Logger log = LoggerFactory.getLogger(thread.getClass());
                log.error("Exception in thread [" + thread.getName() + "]", e);
            }
        });
        Logger mainLog = App.getLog();
        if (mainLog.isInfoEnabled()) {
            Date date = new Date();
            mainLog.info("This application was launched at " + date.toString());
        }
        if (SystemUtilities.isMacOS()) {
            SystemUtilities.configureMacOSApplication((String)"VARS Query");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            mainLog.info("Unable to set look and feel", (Throwable)e);
        }
        Injector injector = StateLookup.GUICE_INJECTOR;
        SwingUtilities.invokeLater(() -> {
            try {
                App app = (App)injector.getInstance(App.class);
            }
            catch (Exception e) {
                FatalExceptionSubscriber subscriber = new FatalExceptionSubscriber(null);
                subscriber.onEvent("vars.shared.ui.GlobalLookup-TopicFatalError", e);
            }
        });
    }

    static {
        GC_PREVENTION = new Vector<EventTopicSubscriber>();
    }
}

