/*
 * Decompiled with CFR 0.152.
 */
package vars.query.ui;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mbari.swing.ListListModel;
import org.mbari.swing.SpinningDial;
import org.mbari.swingworker.SwingWorker;
import org.mbari.text.IgnoreCaseToStringComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.VARSException;
import vars.query.QueryPersistenceService;
import vars.query.ui.ValuePanel;

public class AdvancedStringValuePanel
extends ValuePanel {
    private static final int VISIBLE_ROW_COUNT = 14;
    private static final Logger log = LoggerFactory.getLogger(AdvancedStringValuePanel.class);
    private volatile transient boolean scanFlag = false;
    private JList list;
    private final Icon listIcon;
    private ListListModel listModel;
    private final QueryPersistenceService queryDAO;
    private JScrollPane scrollPane;
    private JTextField textField;
    private final Icon textFieldIcon;
    private JToggleButton toggleButton;

    @Inject
    public AdvancedStringValuePanel(String name, QueryPersistenceService queryDAO) {
        super(name);
        this.queryDAO = queryDAO;
        this.listIcon = new ImageIcon(this.getClass().getResource("/images/vars/query/16px/table_view.png"));
        this.textFieldIcon = new ImageIcon(this.getClass().getResource("/images/vars/query/16px/pencil2.png"));
        this.initialize();
    }

    public JList getList() {
        if (this.list == null) {
            this.list = new JList();
            this.list.setVisibleRowCount(3);
            this.list.setModel(this.getListModel());
            this.list.setSelectionMode(2);
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int i = AdvancedStringValuePanel.this.list.getSelectedIndex();
                    AdvancedStringValuePanel.this.getConstrainCheckBox().setSelected(i > -1);
                }
            });
        }
        return this.list;
    }

    private ListListModel getListModel(JList list) {
        if (this.listModel == null) {
            // empty if block
        }
        return this.listModel;
    }

    private ListListModel getListModel() {
        if (this.listModel == null) {
            this.scanFlag = true;
            this.listModel = new ListListModel(Collections.synchronizedList(new ArrayList()));
            SwingWorker worker = new SwingWorker(){
                final List results = new ArrayList();

                protected Object doInBackground() throws Exception {
                    try {
                        this.results.addAll(AdvancedStringValuePanel.this.queryDAO.getUniqueValuesByColumn(AdvancedStringValuePanel.this.getValueName()));
                    }
                    catch (VARSException e1) {
                        log.error("An error occurred while finding unique values for " + AdvancedStringValuePanel.this.getValueName(), (Throwable)e1);
                    }
                    Collections.sort(this.results, new IgnoreCaseToStringComparator());
                    return this.results;
                }

                protected void done() {
                    super.done();
                    if (this.results.size() > 14) {
                        String prototype = " ";
                        Iterator it = this.results.iterator();
                        while (it.hasNext()) {
                            String s;
                            int length;
                            int maxLength = 0;
                            Object object = it.next();
                            if (object == null || (length = (s = object.toString()).length()) <= maxLength) continue;
                            maxLength = length;
                            prototype = s;
                        }
                        AdvancedStringValuePanel.this.getList().setPrototypeCellValue(prototype);
                    }
                    AdvancedStringValuePanel.this.listModel.addAll((Collection)this.results);
                    Icon currentIcon = AdvancedStringValuePanel.this.getToggleButton().isSelected() ? AdvancedStringValuePanel.this.textFieldIcon : AdvancedStringValuePanel.this.listIcon;
                    AdvancedStringValuePanel.this.getToggleButton().setIcon(currentIcon);
                    AdvancedStringValuePanel.this.scanFlag = false;
                    AdvancedStringValuePanel.this.update();
                }
            };
            worker.execute();
        }
        return this.listModel;
    }

    @Override
    public String getSQL() {
        String text;
        StringBuffer sb = new StringBuffer();
        if (this.getToggleButton().isSelected()) {
            Object[] obj = this.getList().getSelectedValues();
            if (obj.length > 0) {
                sb.append(" ").append(this.getValueName()).append(" IN (");
                for (int i = 0; i < obj.length; ++i) {
                    sb.append("'").append(obj[i].toString()).append("'");
                    if (obj.length <= 0 || i >= obj.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(")");
            }
        } else if (this.getConstrainCheckBox().isSelected() && (text = this.getTextField().getText()).length() > 0) {
            sb.append(" ").append(this.getValueName()).append(" LIKE '%").append(this.getTextField().getText());
            sb.append("%' ");
        }
        return sb.toString();
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getList());
            this.scrollPane.setMinimumSize(new Dimension(200, 100));
        }
        return this.scrollPane;
    }

    public JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.setToolTipText("Enter a value. The query will return items that contain this value.");
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                private void update() {
                    boolean enable = AdvancedStringValuePanel.this.textField.getText().length() > 0;
                    AdvancedStringValuePanel.this.getConstrainCheckBox().setSelected(enable);
                }
            });
        }
        return this.textField;
    }

    public JToggleButton getToggleButton() {
        if (this.toggleButton == null) {
            this.toggleButton = new JToggleButton(this.listIcon);
            this.toggleButton.setSelected(false);
            this.toggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdvancedStringValuePanel.this.update();
                }
            });
        }
        return this.toggleButton;
    }

    private void initialize() {
        this.add(this.getTextField());
        this.add(this.getToggleButton());
    }

    private void update() {
        Component[] components = this.getComponents();
        int i = 0;
        JTextField tf = this.getTextField();
        JScrollPane sp = this.getScrollPane();
        for (Component c : components) {
            if (c == sp || c == tf) break;
            ++i;
        }
        this.remove(i);
        if (this.scanFlag) {
            this.setEnabled(false);
        }
        Object icon = null;
        JToggleButton button = this.getToggleButton();
        icon = this.scanFlag ? new SpinningDial(16, 16) : (button.isSelected() ? this.textFieldIcon : this.listIcon);
        button.setIcon((Icon)icon);
        if (this.toggleButton.isSelected()) {
            this.add((Component)this.getScrollPane(), i);
            int size = this.getListModel().getSize();
            int visibleRowCount = 7;
            visibleRowCount = size > 20 ? 14 : (size > 0 ? size : 3);
            log.debug("Setting visible row count in '" + this.getValueName() + "' list to " + visibleRowCount + " (" + size + " items in list )");
            this.getList().setVisibleRowCount(visibleRowCount);
            this.toggleButton.setToolTipText("Press to open text editor");
            int idx = this.getList().getSelectedIndex();
            this.getConstrainCheckBox().setSelected(idx > -1);
        } else {
            this.add((Component)this.getTextField(), i);
            this.toggleButton.setToolTipText("Press to open a selectable list of values");
            String text = this.getTextField().getText();
            this.getConstrainCheckBox().setSelected(text.length() > 0);
        }
        if (!this.scanFlag) {
            this.setEnabled(true);
        }
        this.revalidate();
    }
}

