/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.sharktopoda;

import java.awt.Frame;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.mbari.util.Tuple2;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.decorators.SchedulerVideoIO;
import org.mbari.vcr4j.decorators.StatusDecorator;
import org.mbari.vcr4j.decorators.VCRSyncDecorator;
import org.mbari.vcr4j.sharktopoda.SharktopodaError;
import org.mbari.vcr4j.sharktopoda.SharktopodaState;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.OpenCmd;
import org.mbari.vcr4j.sharktopoda.commands.SharkCommands;
import org.mbari.vcr4j.sharktopoda.decorators.FauxTimecodeDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ToolBelt;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.avplayer.ImageCaptureService;
import vars.avplayer.VideoController;
import vars.avplayer.VideoPlayer;
import vars.avplayer.VideoPlayerDialogUI;
import vars.avplayer.rx.SetVideoArchiveMsg;
import vars.avplayer.rx.SetVideoControllerMsg;
import vars.avplayer.sharktopoda.SharktopodaDialogUI;
import vars.avplayer.sharktopoda.SharktopodaImageCaptureService;
import vars.avplayer.sharktopoda.VideoParams;
import vars.shared.rx.RXEventBus;
import vars.shared.ui.GlobalStateLookup;

public class SharktopodaVideoPlayer
implements VideoPlayer<SharktopodaState, SharktopodaError> {
    private SharktopodaDialogUI dialogUI;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<VideoController<SharktopodaState, SharktopodaError>> currentVideoController = new AtomicReference();

    protected CompletableFuture<VideoController<SharktopodaState, SharktopodaError>> createVideoController(String movieLocation, int sharktopodaPort, int framecapturePort) {
        CompletableFuture<VideoController<SharktopodaState, SharktopodaError>> cf = new CompletableFuture<VideoController<SharktopodaState, SharktopodaError>>();
        try {
            SharktopodaVideoIO videoIO = new SharktopodaVideoIO(UUID.randomUUID(), "localhost", sharktopodaPort);
            videoIO.send((VideoCommand)new OpenCmd(new URL(movieLocation)));
            new StatusDecorator((VideoIO)videoIO);
            new VCRSyncDecorator((VideoIO)videoIO, 1000L, 100L, 3000000L);
            new FauxTimecodeDecorator(videoIO);
            SchedulerVideoIO io = new SchedulerVideoIO((VideoIO)videoIO, (Executor)Executors.newCachedThreadPool());
            VideoController<SharktopodaState, SharktopodaError> oldVc = this.currentVideoController.get();
            if (oldVc != null) {
                oldVc.getVideoIO().send((VideoCommand)SharkCommands.CLOSE);
                oldVc.getImageCaptureService().dispose();
            }
            VideoController newVc = new VideoController((ImageCaptureService)new SharktopodaImageCaptureService(videoIO, framecapturePort), (VideoIO)io);
            this.currentVideoController.set((VideoController<SharktopodaState, SharktopodaError>)newVc);
            cf.complete((VideoController<SharktopodaState, SharktopodaError>)newVc);
            io.send((VideoCommand)SharkCommands.SHOW);
        }
        catch (Exception e) {
            this.log.error("Failed to create SharktopodaVideoIO", (Throwable)e);
            cf.completeExceptionally(e);
        }
        return cf;
    }

    public CompletableFuture<Tuple2<VideoArchive, VideoController<SharktopodaState, SharktopodaError>>> openVideoArchive(ToolBelt toolBelt, Object ... args) {
        String movieLocation = (String)args[0];
        String platformName = (String)args[1];
        Integer sequenceNumber = (Integer)args[2];
        return this.openVideoArchive(toolBelt, movieLocation, platformName, sequenceNumber);
    }

    public CompletableFuture<Tuple2<VideoArchive, VideoController<SharktopodaState, SharktopodaError>>> openVideoArchive(ToolBelt toolBelt, String movieLocation, String platformName, Integer sequenceNumber, int sharktopodaPort, int framecapturePort) {
        return this.openVideoArchive(toolBelt, new VideoParams(movieLocation, platformName, sequenceNumber, sharktopodaPort, framecapturePort));
    }

    public VideoPlayerDialogUI<SharktopodaState, SharktopodaError> getConnectionDialog(ToolBelt toolBelt, RXEventBus eventBus) {
        if (this.dialogUI == null) {
            Frame window = GlobalStateLookup.getSelectedFrame();
            this.dialogUI = new SharktopodaDialogUI(window, toolBelt, this);
            this.dialogUI.onOkay(() -> {
                this.dialogUI.setVisible(false);
                Tuple2<VideoArchive, VideoController<SharktopodaState, SharktopodaError>> data = this.dialogUI.openVideoArchive();
                VideoArchive videoArchive = (VideoArchive)data.getA();
                VideoController videoController = (VideoController)data.getB();
                eventBus.send((Object)new SetVideoArchiveMsg(videoArchive));
                eventBus.send((Object)new SetVideoControllerMsg(videoController));
            });
        }
        return this.dialogUI;
    }

    protected CompletableFuture<Tuple2<VideoArchive, VideoController<SharktopodaState, SharktopodaError>>> openVideoArchive(ToolBelt toolBelt, VideoParams videoParams) {
        VideoArchive videoArchive = this.getOrCreateVideoArchive(videoParams, toolBelt.getAnnotationDAOFactory());
        return this.createVideoController(videoArchive.getName(), videoParams.getSharktopodaPort(), videoParams.getFramecapturePort()).thenCompose(c -> CompletableFuture.supplyAsync(() -> new Tuple2((Object)videoArchive, c)));
    }

    public boolean canPlay(String mimeType) {
        return false;
    }

    public String getName() {
        return "Sharktopoda";
    }

    public Optional<VideoArchive> findByLocation(String location, AnnotationDAOFactory daoFactory) {
        VideoArchiveDAO dao = daoFactory.newVideoArchiveDAO();
        dao.startTransaction();
        VideoArchive videoArchive = dao.findByName(location);
        dao.endTransaction();
        return Optional.ofNullable(videoArchive);
    }

    private VideoArchive createVideoArchive(VideoParams videoParams, AnnotationDAOFactory daoFactory) {
        VideoArchive videoArchive = null;
        if (videoParams.getPlatformName().isPresent() && videoParams.getSequenceNumber().isPresent()) {
            String location = videoParams.getMovieLocation();
            int sequenceNumber = videoParams.getSequenceNumber().get();
            String platform = videoParams.getPlatformName().get();
            VideoArchiveDAO dao = daoFactory.newVideoArchiveDAO();
            dao.startTransaction();
            videoArchive = dao.findOrCreateByParameters(platform, sequenceNumber, location);
            dao.endTransaction();
        }
        return videoArchive;
    }

    protected VideoArchive getOrCreateVideoArchive(VideoParams videoParams, AnnotationDAOFactory daoFactory) {
        return this.findByLocation(videoParams.getMovieLocation(), daoFactory).orElseGet(() -> this.createVideoArchive(videoParams, daoFactory));
    }
}

