/*
 * Decompiled with CFR 0.152.
 */
package vars.avplayer.sharktopoda;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;
import org.bushe.swing.event.EventBus;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.FramecaptureCmd;
import org.mbari.vcr4j.sharktopoda.decorators.FramecaptureDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.avplayer.ImageCaptureException;
import vars.avplayer.ImageCaptureService;

public class SharktopodaImageCaptureService
implements ImageCaptureService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SharktopodaVideoIO io;
    private final FramecaptureDecorator decorator;

    public SharktopodaImageCaptureService(SharktopodaVideoIO io, int port) {
        this.io = io;
        this.decorator = new FramecaptureDecorator(io, port);
    }

    public Optional<Image> capture(File file) throws ImageCaptureException {
        Optional image;
        CompletableFuture future = new CompletableFuture();
        this.decorator.getFramecaptureObservable().first().forEach(r -> {
            BufferedImage image = null;
            try {
                image = ImageIO.read(r.getImageLocation());
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)e);
            }
            future.complete(Optional.ofNullable(image));
        });
        this.io.send((VideoCommand)new FramecaptureCmd(UUID.randomUUID(), file));
        try {
            image = (Optional)future.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            image = Optional.empty();
        }
        return image;
    }

    public void dispose() {
        this.decorator.unsubscribe();
    }

    public void showSettingsDialog() {
    }
}

