/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda.decorators;

import java.io.File;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.decorators.Decorator;
import org.mbari.vcr4j.sharktopoda.Constants;
import org.mbari.vcr4j.sharktopoda.SharktopodaVideoIO;
import org.mbari.vcr4j.sharktopoda.commands.ConnectCmd;
import org.mbari.vcr4j.sharktopoda.commands.FramecaptureCmd;
import org.mbari.vcr4j.sharktopoda.model.request.Connect;
import org.mbari.vcr4j.sharktopoda.model.request.Framecapture;
import org.mbari.vcr4j.sharktopoda.model.response.FramecaptureResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class FramecaptureDecorator
implements Decorator {
    private final SharktopodaVideoIO io;
    private final int port;
    private DatagramSocket server;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Subject<FramecaptureResponse, FramecaptureResponse> framecaptureSubject = new SerializedSubject((Subject)PublishSubject.create());
    private volatile boolean ok = true;
    private final Subscriber<FramecaptureCmd> subscriber;
    private final Thread receiverThread = new Thread(() -> {
        byte[] buffer = new byte[4096];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        while (this.ok) {
            try {
                this.getServer().receive(packet);
                String msg = new String(packet.getData(), 0, packet.getLength());
                this.log.debug("GOT MSG: " + msg);
                FramecaptureResponse r = (FramecaptureResponse)Constants.GSON.fromJson(msg, FramecaptureResponse.class);
                this.framecaptureSubject.onNext((Object)r);
            }
            catch (Exception e) {
                this.log.info("Error while reading UDP datagram", (Throwable)e);
                if (this.server == null) continue;
                this.server.close();
                this.server = null;
            }
        }
        if (this.server != null) {
            this.server.close();
        }
        this.log.info("Shutting down UDP server that listens to Sharktopoda for framegrabs");
    });

    public FramecaptureDecorator(SharktopodaVideoIO io, int port) {
        this.io = io;
        this.port = port;
        this.receiverThread.setDaemon(true);
        this.receiverThread.start();
        this.subscriber = new Subscriber<FramecaptureCmd>(){

            public void onCompleted() {
                FramecaptureDecorator.this.ok = false;
            }

            public void onError(Throwable throwable) {
                FramecaptureDecorator.this.ok = false;
            }

            public void onNext(FramecaptureCmd cmd) {
                FramecaptureDecorator.this.doFrameCapture(cmd);
            }
        };
        io.getCommandSubject().ofType(FramecaptureCmd.class).subscribe(this.subscriber);
        io.getCommandSubject().ofType(ConnectCmd.class).forEach(this::doConnect);
        io.send(new ConnectCmd(port));
    }

    public Observable<FramecaptureResponse> getFramecaptureObservable() {
        return this.framecaptureSubject;
    }

    private DatagramSocket getServer() throws SocketException {
        if (this.server == null || this.server.isClosed()) {
            this.server = new DatagramSocket(this.port);
        }
        return this.server;
    }

    private void doFrameCapture(FramecaptureCmd cmd) {
        FramecaptureCmd.Params params = (FramecaptureCmd.Params)cmd.getValue();
        try {
            URL url = new File(params.getImageLocation()).toURI().toURL();
            Framecapture obj = new Framecapture(this.io.getUUID(), params.getImageReferenceUuid(), url.toExternalForm());
            DatagramPacket packet = this.io.asPacket(obj);
            this.io.sendCommand(packet, (VideoCommand)cmd);
        }
        catch (MalformedURLException e) {
            this.log.info("Unable to convert file path to URL", (Throwable)e);
        }
    }

    private void doConnect(ConnectCmd cmd) {
        ConnectCmd.Params params = cmd.getValue();
        Connect obj = new Connect(params.getPort(), params.getHost());
        DatagramPacket packet = this.io.asPacket(obj);
        this.io.sendCommand(packet, cmd);
    }

    public void unsubscribe() {
        this.ok = false;
        this.subscriber.unsubscribe();
    }
}

