/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.commands.SeekElapsedTimeCmd;
import org.mbari.vcr4j.commands.ShuttleCmd;
import org.mbari.vcr4j.commands.VideoCommands;
import org.mbari.vcr4j.sharktopoda.Constants;
import org.mbari.vcr4j.sharktopoda.SharktopodaError;
import org.mbari.vcr4j.sharktopoda.SharktopodaResponseParser;
import org.mbari.vcr4j.sharktopoda.SharktopodaState;
import org.mbari.vcr4j.sharktopoda.commands.OpenCmd;
import org.mbari.vcr4j.sharktopoda.commands.SharkCommands;
import org.mbari.vcr4j.sharktopoda.model.VideoInformation;
import org.mbari.vcr4j.sharktopoda.model.request.Close;
import org.mbari.vcr4j.sharktopoda.model.request.FrameAdvance;
import org.mbari.vcr4j.sharktopoda.model.request.Open;
import org.mbari.vcr4j.sharktopoda.model.request.Pause;
import org.mbari.vcr4j.sharktopoda.model.request.Play;
import org.mbari.vcr4j.sharktopoda.model.request.RequestAllVideoInfos;
import org.mbari.vcr4j.sharktopoda.model.request.RequestElapsedTime;
import org.mbari.vcr4j.sharktopoda.model.request.RequestStatus;
import org.mbari.vcr4j.sharktopoda.model.request.RequestVideoInfo;
import org.mbari.vcr4j.sharktopoda.model.request.SeekElapsedTime;
import org.mbari.vcr4j.sharktopoda.model.request.Show;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class SharktopodaVideoIO
implements VideoIO<SharktopodaState, SharktopodaError> {
    public static final double MAX_SHUTTLE_RATE = 8.0;
    public static final double DEFAULT_SHUTTLE_RATE = 3.0;
    private final int port;
    private final InetAddress inetAddress;
    private final UUID uuid;
    private DatagramSocket socket;
    private final Subject<VideoInformation, VideoInformation> videoInfoSubject = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<SharktopodaState, SharktopodaState> stateSubject = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<SharktopodaError, SharktopodaError> errorSubject = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<VideoIndex, VideoIndex> indexSubject = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<VideoCommand, VideoCommand> commandSubject = new SerializedSubject((Subject)PublishSubject.create());
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SharktopodaResponseParser responseParser;

    public SharktopodaVideoIO(UUID uuid, String host, int port) throws UnknownHostException, SocketException {
        this.uuid = uuid;
        this.port = port;
        this.inetAddress = InetAddress.getByName(host);
        this.responseParser = new SharktopodaResponseParser(uuid, this.stateSubject, this.errorSubject, this.indexSubject, this.videoInfoSubject);
        this.commandSubject.ofType(OpenCmd.class).forEach(this::doOpen);
        this.commandSubject.filter(cmd -> cmd.equals((Object)SharkCommands.SHOW)).forEach(cmd -> this.doShow());
        this.commandSubject.filter(cmd -> cmd.equals((Object)SharkCommands.CLOSE)).forEach(cmd -> this.doClose());
        this.commandSubject.filter(cmd -> cmd.equals((Object)SharkCommands.REQUEST_ALL_VIDEO_INFOS)).forEach(cmd -> this.doRequestAllVideoInfos());
        this.commandSubject.filter(cmd -> cmd.equals((Object)SharkCommands.REQUEST_VIDEO_INFO)).forEach(cmd -> this.doRequestVideoInfo());
        this.commandSubject.filter(cmd -> cmd.equals(VideoCommands.PLAY)).forEach(cmd -> this.doPlay());
        this.commandSubject.filter(cmd -> cmd.equals(VideoCommands.PAUSE) || cmd.equals(VideoCommands.STOP)).forEach(cmd -> this.doPause());
        this.commandSubject.filter(cmd -> cmd.equals(VideoCommands.REQUEST_STATUS)).forEach(cmd -> this.doRequestStatus());
        this.commandSubject.filter(cmd -> cmd.equals(VideoCommands.FAST_FORWARD)).forEach(cmd -> this.doShuttle(3.0, (VideoCommand)cmd));
        this.commandSubject.filter(cmd -> cmd.equals(VideoCommands.REWIND)).forEach(cmd -> this.doShuttle(-3.0, (VideoCommand)cmd));
        this.commandSubject.ofType(ShuttleCmd.class).forEach(cmd -> this.doShuttle((Double)cmd.getValue() * 8.0, (VideoCommand)cmd));
        this.commandSubject.filter(cmd -> cmd.equals(VideoCommands.REQUEST_ELAPSED_TIME) || cmd.equals(VideoCommands.REQUEST_INDEX)).forEach(this::doRequestIndex);
        this.commandSubject.filter(cmd -> cmd.equals((Object)SharkCommands.REQUEST_VIDEO_INFO)).forEach(cmd -> this.doRequestVideoInfo());
        this.commandSubject.ofType(SeekElapsedTimeCmd.class).forEach(this::doSeekElapsedTime);
        this.commandSubject.filter(cmd -> cmd.equals((Object)SharkCommands.FRAMEADVANCE)).forEach(cmd -> this.doFrameAdvance());
    }

    private DatagramSocket getSocket() throws SocketException {
        if (this.socket == null || this.socket.isClosed() || !this.socket.isConnected()) {
            this.socket = new DatagramSocket(0);
            this.socket.connect(this.inetAddress, this.port);
            this.socket.setSoTimeout(8000);
        }
        return this.socket;
    }

    public synchronized void sendCommandAndListenForResponse(DatagramPacket packet, int sizeBytes, VideoCommand command) {
        block3: {
            try {
                int timeout = command instanceof OpenCmd ? 20000 : 1000;
                byte[] msg = new byte[sizeBytes];
                DatagramPacket incomingPacket = new DatagramPacket(msg, msg.length);
                DatagramSocket s = this.getSocket();
                s.setSoTimeout(timeout);
                s.send(packet);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(command.toString() + " -> " + new String(packet.getData()));
                }
                s.receive(incomingPacket);
                int numBytes = incomingPacket.getLength();
                byte[] response = new byte[numBytes];
                System.arraycopy(incomingPacket.getData(), 0, response, 0, numBytes);
                this.responseParser.parse(command, response);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error("UDP connection failed.", (Throwable)e);
                this.errorSubject.onNext((Object)new SharktopodaError(true, false, false, Optional.of(command)));
            }
        }
    }

    public synchronized void sendCommand(DatagramPacket packet, VideoCommand command) {
        block3: {
            try {
                DatagramSocket s = this.getSocket();
                s.send(packet);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(command.toString() + " -> " + new String(packet.getData()));
                }
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block3;
                this.log.error("UDP connection failed.", (Throwable)e);
                this.errorSubject.onNext((Object)new SharktopodaError(true, false, false, Optional.of(command)));
            }
        }
    }

    public <A extends VideoCommand> void send(A videoCommand) {
        this.commandSubject.onNext(videoCommand);
    }

    public Subject<VideoCommand, VideoCommand> getCommandSubject() {
        return this.commandSubject;
    }

    public String getConnectionID() {
        return this.uuid.toString() + "@" + this.inetAddress.getCanonicalHostName() + ":" + this.port;
    }

    public void close() {
    }

    public Observable<SharktopodaError> getErrorObservable() {
        return this.errorSubject;
    }

    public Observable<SharktopodaState> getStateObservable() {
        return this.stateSubject;
    }

    public Observable<VideoIndex> getIndexObservable() {
        return this.indexSubject;
    }

    public Subject<VideoIndex, VideoIndex> getIndexSubject() {
        return this.indexSubject;
    }

    public Observable<VideoInformation> getVideoInfoSubject() {
        return this.videoInfoSubject;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public DatagramPacket asPacket(Object cmd) {
        byte[] b = Constants.GSON.toJson(cmd).getBytes();
        return new DatagramPacket(b, b.length, this.inetAddress, this.port);
    }

    private void doOpen(OpenCmd cmd) {
        Open obj = new Open((URL)cmd.getValue(), this.uuid);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommandAndListenForResponse(packet, 1024, (VideoCommand)cmd);
    }

    private void doShow() {
        Show obj = new Show(this.uuid);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommand(packet, SharkCommands.SHOW);
    }

    private void doClose() {
        Close obj = new Close(this.uuid);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommand(packet, SharkCommands.CLOSE);
    }

    private void doPlay() {
        Play obj = new Play(this.uuid, 1.0);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommandAndListenForResponse(packet, 1024, (VideoCommand)VideoCommands.PLAY);
    }

    private void doPause() {
        Pause obj = new Pause(this.uuid);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommandAndListenForResponse(packet, 1024, (VideoCommand)VideoCommands.PAUSE);
    }

    private void doRequestStatus() {
        RequestStatus obj = new RequestStatus(this.uuid);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommandAndListenForResponse(packet, 1024, (VideoCommand)VideoCommands.REQUEST_STATUS);
    }

    private void doShuttle(double rate, VideoCommand command) {
        Play obj = new Play(this.uuid, rate);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommandAndListenForResponse(packet, 1024, command);
    }

    private void doRequestIndex(VideoCommand command) {
        RequestElapsedTime obj = new RequestElapsedTime(this.uuid);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommandAndListenForResponse(packet, 1024, command);
    }

    private void doRequestVideoInfo() {
        RequestVideoInfo obj = new RequestVideoInfo(this.uuid);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommandAndListenForResponse(packet, 2048, SharkCommands.REQUEST_VIDEO_INFO);
    }

    private void doRequestAllVideoInfos() {
        RequestAllVideoInfos obj = new RequestAllVideoInfos();
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommandAndListenForResponse(packet, 4096, SharkCommands.REQUEST_ALL_VIDEO_INFOS);
    }

    private void doSeekElapsedTime(SeekElapsedTimeCmd command) {
        SeekElapsedTime obj = new SeekElapsedTime(this.uuid, ((Duration)command.getValue()).toMillis());
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommand(packet, (VideoCommand)command);
    }

    private void doFrameAdvance() {
        FrameAdvance obj = new FrameAdvance(this.uuid);
        DatagramPacket packet = this.asPacket(obj);
        this.sendCommand(packet, SharkCommands.FRAMEADVANCE);
    }
}

