/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.sharktopoda;

import java.util.Arrays;
import org.mbari.vcr4j.VideoState;

public class SharktopodaState
implements VideoState {
    private final State state;

    public SharktopodaState(State state) {
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public boolean isConnected() {
        return !this.state.equals((Object)State.NOT_FOUND);
    }

    public boolean isCueingUp() {
        return false;
    }

    public boolean isFastForwarding() {
        return this.state.equals((Object)State.SHUTTLE_FORWARD);
    }

    public boolean isPlaying() {
        return this.state.equals((Object)State.PLAYING);
    }

    public boolean isReverseDirection() {
        return this.state.equals((Object)State.SHUTTLE_REVERSE);
    }

    public boolean isRewinding() {
        return this.isReverseDirection();
    }

    public boolean isShuttling() {
        return this.state.equals((Object)State.SHUTTLE_FORWARD) || this.state.equals((Object)State.SHUTTLE_REVERSE);
    }

    public boolean isStopped() {
        return this.state.equals((Object)State.PAUSED);
    }

    public static SharktopodaState parse(String name) {
        State state = Arrays.stream(State.values()).filter(s -> s.getName().equalsIgnoreCase(name)).findFirst().orElse(State.NOT_FOUND);
        return new SharktopodaState(state);
    }

    public static enum State {
        PAUSED("paused"),
        PLAYING("playing"),
        SHUTTLE_FORWARD("shuttling forward"),
        SHUTTLE_REVERSE("shuttling reverse"),
        NOT_FOUND("not found"),
        UNKNOWN_ERROR("error");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

