/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.SimpleConceptBean;
import vars.knowledgebase.SimpleConceptNameBean;
import vars.knowledgebase.ui.ToolBelt;
import vars.shared.ui.HierachicalConceptNameComboBox;
import vars.shared.ui.ILockableEditor;
import vars.shared.ui.OkCancelButtonPanel;

public class LinkEditorDialog
extends JDialog
implements ILockableEditor {
    private static final Concept SELF_CONCEPT = new SimpleConceptBean(new SimpleConceptNameBean("self", ConceptNameTypes.PRIMARY.toString()));
    private static final Concept NIL_CONCEPT = new SimpleConceptBean(new SimpleConceptNameBean("nil", ConceptNameTypes.PRIMARY.toString()));
    private static final Logger log = LoggerFactory.getLogger(LinkEditorDialog.class);
    private static final long serialVersionUID = 1L;
    private OkCancelButtonPanel buttonPanel = null;
    private JPanel editorPanel = null;
    private JPanel jContentPane = null;
    private JLabel linkNameLabel = null;
    private JTextField linkNameTextField = null;
    private JLabel linkValueLabel = null;
    private JTextArea linkValueTextArea = null;
    private JScrollPane scrollPane = null;
    private HierachicalConceptNameComboBox toConceptComboBox = null;
    private JLabel toConceptLabel = null;
    private ILink EMPTY_LINK = new ILink(){

        @Override
        public String getFromConcept() {
            return null;
        }

        @Override
        public String getLinkName() {
            return "nil";
        }

        @Override
        public String getLinkValue() {
            return "nil";
        }

        @Override
        public String getToConcept() {
            return "nil";
        }

        @Override
        public void setLinkName(String linkName_) {
        }

        @Override
        public void setLinkValue(String linkValue_) {
        }

        @Override
        public void setToConcept(String toConcept_) {
        }

        @Override
        public String stringValue() {
            return "nil | " + this.getLinkName() + " | " + this.getToConcept() + " | " + this.getLinkValue();
        }
    };
    private final ToolBelt toolBelt;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    private ILink link;

    public LinkEditorDialog(ToolBelt toolBelt) throws HeadlessException {
        this.toolBelt = toolBelt;
        this.knowledgebaseDAOFactory = toolBelt.getKnowledgebaseDAOFactory();
        this.setModal(true);
        this.initialize();
    }

    public LinkEditorDialog(Frame owner, ToolBelt toolBelt) throws HeadlessException {
        super(owner);
        this.toolBelt = toolBelt;
        this.knowledgebaseDAOFactory = toolBelt.getKnowledgebaseDAOFactory();
        this.setModal(true);
        this.initialize();
    }

    private OkCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OkCancelButtonPanel();
            JButton okButton = this.buttonPanel.getOkayButton();
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkEditorDialog.this.link.setLinkName(LinkEditorDialog.this.getLinkNameTextField().getText());
                    LinkEditorDialog.this.link.setLinkValue(LinkEditorDialog.this.getLinkValueTextArea().getText());
                    LinkEditorDialog.this.link.setToConcept((String)LinkEditorDialog.this.getToConceptComboBox().getSelectedItem());
                    LinkEditorDialog.this.onOkClick();
                    LinkEditorDialog.this.setLink(null);
                    LinkEditorDialog.this.setVisible(false);
                }
            });
            JButton cancelButton = this.buttonPanel.getCancelButton();
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkEditorDialog.this.onCancelClick();
                    LinkEditorDialog.this.setLink(null);
                    LinkEditorDialog.this.setVisible(false);
                }
            });
        }
        return this.buttonPanel;
    }

    private JPanel getEditorPanel() {
        if (this.editorPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.insets = new Insets(0, 0, 5, 20);
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(0, 0, 5, 20);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(5, 0, 5, 20);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.insets = new Insets(0, 20, 5, 0);
            gridBagConstraints2.gridy = 2;
            this.linkValueLabel = new JLabel();
            this.linkValueLabel.setText("Link Value:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.insets = new Insets(0, 20, 5, 0);
            gridBagConstraints1.gridy = 1;
            this.toConceptLabel = new JLabel();
            this.toConceptLabel.setText("To Concept:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 20, 5, 0);
            gridBagConstraints.gridy = 0;
            this.linkNameLabel = new JLabel();
            this.linkNameLabel.setText("Link Name:");
            this.editorPanel = new JPanel();
            this.editorPanel.setLayout(new GridBagLayout());
            this.editorPanel.add((Component)this.linkNameLabel, gridBagConstraints);
            this.editorPanel.add((Component)this.toConceptLabel, gridBagConstraints1);
            this.editorPanel.add((Component)this.linkValueLabel, gridBagConstraints2);
            this.editorPanel.add((Component)this.getLinkNameTextField(), gridBagConstraints3);
            this.editorPanel.add((Component)this.getToConceptComboBox(), gridBagConstraints4);
            this.editorPanel.add((Component)this.getScrollPane(), gridBagConstraints5);
        }
        return this.editorPanel;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getEditorPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    public ILink getLink() {
        return this.link;
    }

    private JTextField getLinkNameTextField() {
        if (this.linkNameTextField == null) {
            this.linkNameTextField = new JTextField();
        }
        return this.linkNameTextField;
    }

    private JTextArea getLinkValueTextArea() {
        if (this.linkValueTextArea == null) {
            this.linkValueTextArea = new JTextArea();
        }
        return this.linkValueTextArea;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getLinkValueTextArea());
        }
        return this.scrollPane;
    }

    public HierachicalConceptNameComboBox getToConceptComboBox() {
        if (this.toConceptComboBox == null) {
            this.toConceptComboBox = new HierachicalConceptNameComboBox(this.toolBelt.getAnnotationPersistenceService());
        }
        return this.toConceptComboBox;
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setContentPane(this.getJContentPane());
    }

    public boolean isLocked() {
        return false;
    }

    public void onCancelClick() {
    }

    public void onOkClick() {
    }

    public void setLink(ILink link) {
        this.link = link;
        if (link == null) {
            this.getLinkNameTextField().setText("");
            this.getLinkValueTextArea().setText("");
            this.getToConceptComboBox().setConcept(SELF_CONCEPT);
            return;
        }
        Collection<LinkTemplate> matchingLinkTemplates = null;
        try {
            matchingLinkTemplates = this.knowledgebaseDAOFactory.newLinkTemplateDAO().findAllByLinkName(link.getLinkName());
        }
        catch (Exception e) {
            log.error("Failed to lookup LinkTemplates with linkName = " + link.getLinkName(), (Throwable)e);
            matchingLinkTemplates = new HashSet<LinkTemplate>();
        }
        String toConceptAsString = null;
        if (matchingLinkTemplates.isEmpty()) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("Unable to find a LinkTemplate that matches '" + link + "'"));
            toConceptAsString = link.getToConcept();
        } else {
            ILink matchingLink = matchingLinkTemplates.iterator().next();
            toConceptAsString = matchingLink.getToConcept();
        }
        Concept concept = null;
        Concept selectedConcept = null;
        HierachicalConceptNameComboBox cb = this.getToConceptComboBox();
        cb.removeAllItems();
        if (toConceptAsString.equalsIgnoreCase("self")) {
            concept = SELF_CONCEPT;
            selectedConcept = SELF_CONCEPT;
            cb.addItem(SELF_CONCEPT.getPrimaryConceptName());
        } else if (toConceptAsString.equalsIgnoreCase("nil")) {
            concept = NIL_CONCEPT;
            selectedConcept = NIL_CONCEPT;
            cb.addItem(NIL_CONCEPT.getPrimaryConceptName());
        } else {
            try {
                ConceptDAO conceptDAO = this.knowledgebaseDAOFactory.newConceptDAO();
                concept = conceptDAO.findByName(toConceptAsString);
                selectedConcept = conceptDAO.findByName(link.getToConcept());
                cb.setConcept(concept);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"A database error occurred. Try refreshing the knowledgebase");
                concept = NIL_CONCEPT;
                selectedConcept = NIL_CONCEPT;
                cb.addItem(NIL_CONCEPT.getPrimaryConceptName());
            }
        }
        cb.setSelectedItem((Object)selectedConcept);
        this.getLinkNameTextField().setText(link.getLinkName());
        this.getLinkValueTextArea().setText(link.getLinkValue());
    }

    public void setLocked(boolean locked) {
    }
}

