/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.dialogs;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.History;
import vars.knowledgebase.HistoryFactory;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.Media;
import vars.knowledgebase.MediaTypes;
import vars.knowledgebase.ui.MediaViewPanel;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.shared.ui.OkCancelButtonPanel;

public class AddMediaDialog
extends JDialog {
    private OkCancelButtonPanel buttonPanel = null;
    private JPanel jContentPane = null;
    private MediaViewPanel mediaViewPanel = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Concept concept;
    private final HistoryFactory historyFactory;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    private final KnowledgebaseFactory knowledgebaseFactory;

    public AddMediaDialog(Frame owner, ToolBelt toolBelt) {
        super(owner);
        this.knowledgebaseDAOFactory = toolBelt.getKnowledgebaseDAOFactory();
        this.knowledgebaseFactory = toolBelt.getKnowledgebaseFactory();
        this.historyFactory = toolBelt.getHistoryFactory();
        this.initialize();
    }

    private OkCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OkCancelButtonPanel();
            this.buttonPanel.getOkayButton().addActionListener(new OkActionListener());
            this.buttonPanel.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddMediaDialog.this.setConcept(null);
                    AddMediaDialog.this.setVisible(false);
                }
            });
        }
        return this.buttonPanel;
    }

    public Concept getConcept() {
        return this.concept;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getMediaViewPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private MediaViewPanel getMediaViewPanel() {
        if (this.mediaViewPanel == null) {
            this.mediaViewPanel = new MediaViewPanel();
            this.mediaViewPanel.getUrlField().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                void update() {
                    String text = AddMediaDialog.this.mediaViewPanel.getUrlField().getText();
                    AddMediaDialog.this.getButtonPanel().getOkayButton().setEnabled(AddMediaDialog.this.getConcept() != null && text != null && text.length() > 5);
                }
            });
            this.mediaViewPanel.setPreferredSize(new Dimension(500, 300));
        }
        return this.mediaViewPanel;
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    public void setConcept(Concept concept) {
        MediaViewPanel p = this.getMediaViewPanel();
        p.getCaptionArea().setText(null);
        p.getCreditArea().setText(null);
        p.setMedia(null);
        p.getUrlField().setText(null);
        boolean locked = concept == null;
        p.setLocked(locked);
        this.getButtonPanel().getOkayButton().setEnabled(concept != null);
        this.concept = concept;
    }

    private class OkActionListener
    implements ActionListener {
        private OkActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddMediaDialog.this.setVisible(false);
            DAO dao = AddMediaDialog.this.knowledgebaseDAOFactory.newDAO();
            dao.startTransaction();
            Concept concept = dao.find(AddMediaDialog.this.getConcept());
            ProgressDialog progressDialog = StateLookup.getProgressDialog();
            progressDialog.setTitle("VARS - Adding Media");
            JProgressBar progressBar = progressDialog.getProgressBar();
            progressBar.setMinimum(0);
            progressBar.setMaximum(3);
            progressBar.setIndeterminate(true);
            progressBar.setString("Searching for media");
            progressDialog.setVisible(true);
            MediaViewPanel p = AddMediaDialog.this.getMediaViewPanel();
            boolean isUrlValid = false;
            URL url = null;
            try {
                url = new URL(p.getUrlField().getText());
                InputStream in = url.openStream();
                int b = in.read();
                boolean bl = isUrlValid = b > -1;
                if (!isUrlValid) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("Unable to read from " + url.toExternalForm()));
                }
            }
            catch (Exception e1) {
                String s = "Failed to open URL, " + p.getUrlField().getText();
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)s);
                AddMediaDialog.this.log.warn(s, (Throwable)e1);
            }
            progressBar.setIndeterminate(false);
            if (isUrlValid) {
                Media primaryMedia;
                final URL fUrl = url;
                ArrayList<Media> mediaSet = new ArrayList<Media>(concept.getConceptMetadata().getMedias());
                Collection matchingMedia = Collections2.filter(mediaSet, (Predicate)new Predicate<Media>(){

                    public boolean apply(Media input) {
                        return input.getUrl().equals(fUrl.toExternalForm());
                    }
                });
                if (matchingMedia.size() > 0) {
                    AddMediaDialog.this.setConcept(null);
                    progressDialog.setVisible(false);
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("A media with the URL, '" + url.toExternalForm() + "', was already found in '" + concept.getPrimaryConceptName().getName() + "'."));
                }
                progressBar.setString("Building data");
                progressBar.setValue(1);
                Media media = AddMediaDialog.this.knowledgebaseFactory.newMedia();
                media.setUrl(url.toExternalForm());
                media.setCaption(p.getCaptionArea().getText());
                media.setCredit(p.getCreditArea().getText());
                String type = (String)p.getTypeComboBox().getSelectedItem();
                media.setType(type);
                boolean isPrimary = p.getPrimaryCheckBox().isSelected();
                media.setPrimary(isPrimary);
                if (isPrimary && (primaryMedia = concept.getConceptMetadata().getPrimaryMedia(MediaTypes.getType(type))) != null) {
                    AddMediaDialog.this.log.info("You are adding a primary media of '" + media.getUrl() + "' to " + concept.getPrimaryConceptName().getName() + ". This concept contained a primary media of '" + primaryMedia.getUrl() + "' which is now set to a secondary media");
                    primaryMedia.setPrimary(false);
                }
                progressBar.setString("Updating database");
                progressBar.setValue(2);
                History history = null;
                try {
                    concept.getConceptMetadata().addMedia(media);
                    dao.persist(media);
                    UserAccount userAccount = StateLookup.getUserAccount();
                    history = AddMediaDialog.this.historyFactory.add(userAccount, media);
                    concept.getConceptMetadata().addHistory(history);
                    dao.persist(history);
                }
                catch (Exception e1) {
                    String s = "Failed to upate '" + concept.getPrimaryConceptName().getName() + "' in the database. Removing the media reference to '" + url.toExternalForm() + "'.";
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)s);
                }
                dao.endTransaction();
                dao.close();
                progressBar.setString("Refreshing");
                progressBar.setValue(3);
                EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
            }
            AddMediaDialog.this.setConcept(null);
            progressDialog.setVisible(false);
            EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", (Object)concept.getPrimaryConceptName().getName());
        }
    }
}

