/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.LinkUtilities;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.History;
import vars.knowledgebase.HistoryFactory;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.LinkTemplateDAO;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.LinkEditorPanel;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.actions.ApproveHistoryTask;
import vars.shared.ui.OkCancelButtonPanel;

public class AddLinkTemplateDialog
extends JDialog {
    private OkCancelButtonPanel buttonPanel = null;
    private JPanel jContentPane = null;
    private LinkEditorPanel linkEditorPanel = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ApproveHistoryTask approveHistoryTask;
    private Concept concept;
    private final LinkTemplate emptyLinkTemplate;
    private final HistoryFactory historyFactory;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    private final KnowledgebaseFactory knowledgebaseFactory;
    private final ToolBelt toolBelt;

    public AddLinkTemplateDialog(ToolBelt toolBelt) {
        this(null, toolBelt);
    }

    public AddLinkTemplateDialog(Frame owner, ToolBelt toolBelt) {
        super(owner);
        this.toolBelt = toolBelt;
        this.knowledgebaseDAOFactory = toolBelt.getKnowledgebaseDAOFactory();
        this.knowledgebaseFactory = toolBelt.getKnowledgebaseFactory();
        this.historyFactory = toolBelt.getHistoryFactory();
        this.approveHistoryTask = toolBelt.getApproveHistoryTask();
        this.emptyLinkTemplate = this.knowledgebaseFactory.newLinkTemplate();
        this.emptyLinkTemplate.setLinkName("");
        this.emptyLinkTemplate.setToConcept("self");
        this.emptyLinkTemplate.setLinkValue("nil");
        this.initialize();
    }

    private OkCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OkCancelButtonPanel();
            this.buttonPanel.getOkayButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLinkTemplateDialog.this.setVisible(false);
                    LinkTemplate linkTemplate = AddLinkTemplateDialog.this.knowledgebaseFactory.newLinkTemplate();
                    LinkEditorPanel p = AddLinkTemplateDialog.this.getLinkEditorPanel();
                    linkTemplate.setLinkName(p.getLinkName());
                    linkTemplate.setToConcept(p.getToConcept());
                    linkTemplate.setLinkValue(p.getLinkValue());
                    Concept cOld = AddLinkTemplateDialog.this.getConcept();
                    if (cOld != null) {
                        AddLinkTemplateDialog.this.getConcept().getConceptMetadata().removeLinkTemplate(AddLinkTemplateDialog.this.emptyLinkTemplate);
                    }
                    Concept c = null;
                    ConceptDAO conceptDAO = AddLinkTemplateDialog.this.knowledgebaseDAOFactory.newConceptDAO();
                    conceptDAO.startTransaction();
                    try {
                        c = conceptDAO.findByName(p.getFromConcept());
                        c.getConceptMetadata();
                    }
                    catch (Exception e2) {
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (Object)("Failed to lookup '" + p.getFromConcept() + "' from the database. Unable to add '" + linkTemplate.stringValue() + "'"));
                    }
                    conceptDAO.endTransaction();
                    conceptDAO.close();
                    if (c != null) {
                        ArrayList<ILink> links = new ArrayList<ILink>();
                        LinkTemplateDAO linkTemplateDAO = AddLinkTemplateDialog.this.knowledgebaseDAOFactory.newLinkTemplateDAO();
                        linkTemplateDAO.startTransaction();
                        try {
                            links.addAll(linkTemplateDAO.findAllByLinkName(linkTemplate.getLinkName()));
                        }
                        catch (Exception e1) {
                            AddLinkTemplateDialog.this.log.error("Failed to look up linkname", (Throwable)e1);
                            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e1);
                        }
                        linkTemplateDAO.endTransaction();
                        Collection<ILink> matchingLinks = LinkUtilities.findMatchingLinksIn(links, linkTemplate);
                        if (matchingLinks.size() > 0) {
                            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)(links.size() + " LinkTemplate(s) with a LinkName of '" + linkTemplate.getLinkName() + "' and LinkValue of '" + linkTemplate.getLinkValue() + "' already exist. Unable to complete your request"));
                        } else {
                            UserAccount userAccount = StateLookup.getUserAccount();
                            History history = AddLinkTemplateDialog.this.historyFactory.add(userAccount, linkTemplate);
                            try {
                                linkTemplateDAO.startTransaction();
                                linkTemplateDAO.merge(c);
                                c.getConceptMetadata().addLinkTemplate(linkTemplate);
                                linkTemplateDAO.persist(linkTemplate);
                                c.getConceptMetadata().addHistory(history);
                                linkTemplateDAO.persist(history);
                                linkTemplateDAO.endTransaction();
                            }
                            catch (Exception e1) {
                                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e1);
                            }
                            EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
                        }
                    }
                    AddLinkTemplateDialog.this.setConcept(null);
                }
            });
            this.buttonPanel.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLinkTemplateDialog.this.getConcept().getConceptMetadata().removeLinkTemplate(AddLinkTemplateDialog.this.emptyLinkTemplate);
                    AddLinkTemplateDialog.this.setVisible(false);
                    AddLinkTemplateDialog.this.setConcept(null);
                }
            });
        }
        return this.buttonPanel;
    }

    public Concept getConcept() {
        return this.concept;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getLinkEditorPanel(), "Center");
        }
        return this.jContentPane;
    }

    private LinkEditorPanel getLinkEditorPanel() {
        if (this.linkEditorPanel == null) {
            this.linkEditorPanel = new LinkEditorPanel(this.toolBelt);
            this.linkEditorPanel.getSearchField().setEnabled(false);
            this.linkEditorPanel.getLinkComboBox().setEnabled(false);
        }
        return this.linkEditorPanel;
    }

    private void initialize() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initializing " + this.getClass().getName());
        }
        this.setDefaultCloseOperation(1);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
        this.setLocationRelativeTo(frame);
        this.pack();
    }

    public void setConcept(Concept concept) {
        if (concept != null) {
            concept.getConceptMetadata().addLinkTemplate(this.emptyLinkTemplate);
        }
        this.getLinkEditorPanel().setConcept(concept);
        this.getLinkEditorPanel().setLink(this.emptyLinkTemplate);
        this.concept = concept;
    }
}

