/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.bushe.swing.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.History;
import vars.knowledgebase.HistoryFactory;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.LinkRealization;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.LinkEditorPanel;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.actions.ApproveHistoryTask;
import vars.shared.ui.OkCancelButtonPanel;

public class AddLinkRealizationDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AddLinkRealizationDialog.class);
    private OkCancelButtonPanel buttonPanel = null;
    private JPanel jContentPane = null;
    private LinkEditorPanel linkEditorPanel = null;
    private Concept concept;
    private final ToolBelt toolBelt;

    public AddLinkRealizationDialog(ToolBelt toolBelt) {
        this(null, toolBelt);
    }

    public AddLinkRealizationDialog(Frame owner, ToolBelt toolBelt) {
        super(owner);
        this.setTitle("VARS - Add Property");
        this.toolBelt = toolBelt;
        this.initialize();
    }

    private OkCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OkCancelButtonPanel();
            this.buttonPanel.getOkayButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLinkRealizationDialog.this.onOkClick();
                }
            });
            this.buttonPanel.getCancelButton().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLinkRealizationDialog.this.onCancelClick();
                }
            });
        }
        return this.buttonPanel;
    }

    public Concept getConcept() {
        return this.concept;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getLinkEditorPanel(), "Center");
        }
        return this.jContentPane;
    }

    private LinkEditorPanel getLinkEditorPanel() {
        if (this.linkEditorPanel == null) {
            this.linkEditorPanel = new LinkEditorPanel(this.toolBelt);
            this.linkEditorPanel.getLinkNameField().setEditable(false);
            this.linkEditorPanel.getFromConceptComboBox().setEditable(false);
            this.linkEditorPanel.addPropertyChangeListener("link", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    AddLinkRealizationDialog.this.linkEditorPanel.getFromConceptComboBox().setEditable(false);
                    if (AddLinkRealizationDialog.this.concept != null) {
                        AddLinkRealizationDialog.this.linkEditorPanel.getFromConceptComboBox().setSelectedItem(AddLinkRealizationDialog.this.concept.getPrimaryConceptName().getName());
                    }
                }
            });
        }
        return this.linkEditorPanel;
    }

    private void initialize() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing " + this.getClass().getName());
        }
        this.setDefaultCloseOperation(1);
        this.setModal(true);
        this.setContentPane(this.getJContentPane());
        KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
        this.setLocationRelativeTo(frame);
        this.pack();
    }

    private void onCancelClick() {
        this.setVisible(false);
        this.setConcept(null);
    }

    private void onOkClick() {
        this.setVisible(false);
        UserAccount userAccount = StateLookup.getUserAccount();
        if (userAccount != null && !userAccount.isReadOnly()) {
            KnowledgebaseDAOFactory knowledgebaseDAOFactory = this.toolBelt.getKnowledgebaseDAOFactory();
            HistoryFactory historyFactory = this.toolBelt.getHistoryFactory();
            ApproveHistoryTask approveHistoryTask = this.toolBelt.getApproveHistoryTask();
            LinkRealization linkRealization = this.toolBelt.getKnowledgebaseFactory().newLinkRealization();
            LinkEditorPanel p = this.getLinkEditorPanel();
            linkRealization.setLinkName(p.getLinkName());
            linkRealization.setToConcept(p.getToConcept());
            linkRealization.setLinkValue(p.getLinkValue());
            Concept c = this.getConcept();
            try {
                ConceptDAO conceptDAO = knowledgebaseDAOFactory.newConceptDAO();
                conceptDAO.startTransaction();
                Concept toConcept = conceptDAO.findByName(linkRealization.getToConcept());
                conceptDAO.endTransaction();
                conceptDAO.close();
                if (toConcept != null) {
                    linkRealization.setToConcept(toConcept.getPrimaryConceptName().getName());
                }
                DAO dao = knowledgebaseDAOFactory.newDAO();
                dao.startTransaction();
                c = dao.find(c);
                this.concept.getConceptMetadata().addLinkRealization(linkRealization);
                dao.persist(linkRealization);
                History history = historyFactory.add(userAccount, linkRealization);
                c.getConceptMetadata().addHistory(history);
                dao.persist(history);
                dao.endTransaction();
                dao.close();
                EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)e);
                EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", (Object)c.getPrimaryConceptName().getName());
            }
            this.setConcept(null);
        }
    }

    public void setConcept(Concept concept) {
        this.getLinkEditorPanel().setConcept(concept);
        if (concept != null) {
            this.getLinkEditorPanel().getFromConceptComboBox().setSelectedItem(concept.getPrimaryConceptName().getName());
        }
        this.concept = concept;
    }
}

