/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.dialogs;

import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.SpinningDialWaitIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameDAO;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.History;
import vars.knowledgebase.HistoryFactory;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.actions.ApproveHistoryTask;
import vars.shared.ui.FancyButton;

public class AddConceptNameDialog2
extends JDialog {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ApproveHistoryTask approveHistoryTask;
    private JTextField authorField;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JRadioButton commonRb;
    private Concept concept;
    private final HistoryFactory historyFactory;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    private final KnowledgebaseFactory knowledgebaseFactory;
    private JLabel msgLabel;
    private JTextField nameField;
    private JButton okButton;
    private JRadioButton synonymRb;
    private JRadioButton formerRb;

    public AddConceptNameDialog2(Frame parent, boolean modal, ToolBelt toolBelt) {
        super(parent, modal);
        this.knowledgebaseDAOFactory = toolBelt.getKnowledgebaseDAOFactory();
        this.knowledgebaseFactory = toolBelt.getKnowledgebaseFactory();
        this.historyFactory = toolBelt.getHistoryFactory();
        this.approveHistoryTask = toolBelt.getApproveHistoryTask();
        this.initComponents();
        this.initModel();
        KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
        this.setLocationRelativeTo(frame);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void cancelButtonKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.cancelButtonActionPerformed(null);
        }
    }

    private void close() {
        this.setVisible(false);
        this.nameField.setText("");
        this.msgLabel.setText("");
        this.authorField.setText("");
    }

    public Concept getConcept() {
        return this.concept;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.nameField = new JTextField();
        this.authorField = new JTextField();
        this.commonRb = new JRadioButton();
        this.synonymRb = new JRadioButton();
        this.formerRb = new JRadioButton();
        this.cancelButton = new FancyButton();
        this.okButton = new FancyButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.msgLabel = new JLabel();
        this.setTitle("VARS - Add Concept Name");
        this.jLabel2.setText("Name:");
        this.jLabel3.setText("Author:");
        this.jLabel4.setText("Type:");
        this.nameField.setToolTipText("The name to store in the database");
        this.authorField.setToolTipText("An author that described this name in the literature");
        this.buttonGroup1.add(this.commonRb);
        this.commonRb.setText("Common");
        this.commonRb.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.commonRb.setMargin(new Insets(0, 10, 0, 0));
        this.buttonGroup1.add(this.synonymRb);
        this.synonymRb.setText("Synonym");
        this.synonymRb.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.synonymRb.setMargin(new Insets(0, 10, 0, 0));
        this.buttonGroup1.add(this.formerRb);
        this.formerRb.setText("Former");
        this.formerRb.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.formerRb.setMargin(new Insets(0, 10, 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/knowledgebase/delete2.png")));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddConceptNameDialog2.this.cancelButtonActionPerformed(evt);
            }
        });
        this.cancelButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AddConceptNameDialog2.this.cancelButtonKeyReleased(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/knowledgebase/check2.png")));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddConceptNameDialog2.this.okButtonActionPerformed(evt);
            }
        });
        this.okButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AddConceptNameDialog2.this.okButtonKeyReleased(evt);
            }
        });
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Add a concept name. Enter a name, author and the type of name. ");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.msgLabel.setForeground(new Color(153, 0, 0));
        this.msgLabel.setText(" ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.msgLabel, -1, 360, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 360, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.commonRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.synonymRb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formerRb)).addComponent(this.authorField, -1, 307, Short.MAX_VALUE).addComponent(this.nameField, -1, 307, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameField, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.authorField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.commonRb).addComponent(this.synonymRb).addComponent(this.formerRb)).addGap(17).addComponent(this.msgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addContainerGap()));
        this.getContentPane().setLayout(layout);
        this.pack();
    }

    private void initModel() {
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            void update() {
                String text = AddConceptNameDialog2.this.nameField.getText();
                AddConceptNameDialog2.this.okButton.setEnabled(text != null && text.length() > 0 && !text.matches("\\A\\s+"));
            }
        });
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        final String name = this.nameField.getText();
        Concept myConcept = this.getConcept();
        ConceptDAO conceptDAO = this.knowledgebaseDAOFactory.newConceptDAO();
        ConceptNameDAO conceptNameDAO = this.knowledgebaseDAOFactory.newConceptNameDAO();
        boolean okToProceed = true;
        Concept preexistingConcept = null;
        try {
            preexistingConcept = (Concept)Worker.post((Task)new Task(){

                public Object run() throws Exception {
                    return AddConceptNameDialog2.this.knowledgebaseDAOFactory.newConceptDAO().findByName(name);
                }
            });
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("Failed attempt to look up the concept '" + name + "'", (Throwable)e);
                this.msgLabel.setText("Failed to connect to database");
            }
            okToProceed = false;
        }
        if (okToProceed && preexistingConcept != null) {
            String preexistingName = preexistingConcept.getPrimaryConceptName().getName();
            this.msgLabel.setText("The name, " + preexistingName + ", already exits in the knowledgebase");
            okToProceed = false;
        }
        if (okToProceed) {
            SpinningDialWaitIndicator waitIndicator = new SpinningDialWaitIndicator((JFrame)this.getParent());
            ConceptName conceptName = this.knowledgebaseFactory.newConceptName();
            conceptName.setName(this.nameField.getText());
            conceptName.setAuthor(this.authorField.getText());
            String nameType = ConceptNameTypes.COMMON.toString();
            if (this.synonymRb.isSelected()) {
                nameType = ConceptNameTypes.SYNONYM.toString();
            } else if (this.formerRb.isSelected()) {
                nameType = ConceptNameTypes.FORMER.toString();
            }
            conceptName.setNameType(nameType);
            try {
                DAO dao = this.knowledgebaseDAOFactory.newDAO();
                dao.startTransaction();
                myConcept = dao.merge(myConcept);
                myConcept.addConceptName(conceptName);
                dao.persist(conceptName);
                UserAccount userAccount = StateLookup.getUserAccount();
                History history = this.historyFactory.add(userAccount, conceptName);
                myConcept.getConceptMetadata().addHistory(history);
                dao.persist(history);
                dao.endTransaction();
                EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            }
            this.close();
            waitIndicator.dispose();
        }
    }

    private void okButtonKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.okButtonActionPerformed(null);
        }
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.nameField.requestFocus();
            this.commonRb.setSelected(true);
        }
        super.setVisible(b);
    }
}

